/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.utxo.client;

import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClient;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.Utxo;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component(value="retryableUtxoClient")
@Qualifier(value="retryableUtxoClient")
public class RetryableUtxoClient
implements UtxoClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryableUtxoClient.class);
    private final UtxoClient delegate;

    public RetryableUtxoClient(UtxoClient utxoClient) {
        this.delegate = utxoClient;
    }

    @Retryable(value={Exception.class}, maxAttempts=5, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public List<AddressUtxo> getUtxosByIds(List<UtxoKey> utxoIds) {
        List utxos;
        if (log.isDebugEnabled()) {
            log.info("Trying to get utxo by ids.." + String.valueOf(utxoIds));
        }
        if ((utxos = this.delegate.getUtxosByIds(utxoIds)).size() != utxoIds.size()) {
            List<UtxoKey> fetchedUtxoKeys = utxos.stream().map(addressUtxo -> new UtxoKey(addressUtxo.getTxHash(), addressUtxo.getOutputIndex())).toList();
            List<UtxoKey> missingKeys = utxoIds.stream().filter(utxoKey -> !fetchedUtxoKeys.contains(utxoKey)).toList();
            throw new IllegalStateException("Utxos not found for all ids : " + String.valueOf(missingKeys));
        }
        return utxos;
    }

    @Retryable(value={Exception.class}, maxAttempts=5, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public Optional<AddressUtxo> getUtxoById(UtxoKey utxoId) {
        Optional utxo;
        if (log.isDebugEnabled()) {
            log.info("Trying to get utxo by id.." + String.valueOf(utxoId));
        }
        if ((utxo = this.delegate.getUtxoById(utxoId)).isEmpty()) {
            throw new IllegalStateException("Utxo not found for id" + String.valueOf(utxoId));
        }
        return utxo;
    }

    @Retryable(value={Exception.class}, maxAttempts=5, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public List<Utxo> getUtxoByAddress(String address, int page, int count) {
        return this.delegate.getUtxoByAddress(address, page, count);
    }
}

