/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.utxo.controller;

import com.bloxbean.cardano.yaci.store.api.utxo.service.UtxoService;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Transaction Service")
@RequestMapping(value={"${apiPrefix}/utxos"})
@ConditionalOnExpression(value="${store.utxo.endpoints.transaction.enabled:true}")
public class UtxoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoController.class);
    private final UtxoService utxoService;

    @GetMapping(value={"/{txHash}/{index}"}, produces={"application/json"})
    public AddressUtxo getUtxo(@PathVariable @Pattern(regexp="^[0-9a-fA-F]{64}$") @Pattern(regexp="^[0-9a-fA-F]{64}$") String txHash, @PathVariable Integer index) {
        return this.utxoService.getUtxo(txHash, index).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "UTxO not found"));
    }

    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    public List<AddressUtxo> getUtxos(@RequestBody List<UtxoKey> utxoIds) {
        List<AddressUtxo> utxos = this.utxoService.getUtxos(utxoIds);
        if (utxos == null || utxos.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "UTxO not found");
        }
        return utxos.stream().filter(addressUtxo -> addressUtxo != null).toList();
    }

    @Generated
    public UtxoController(UtxoService utxoService) {
        this.utxoService = utxoService;
    }
}

