/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.utxo.service;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.store.api.utxo.service.UtxoUtil;
import com.bloxbean.cardano.yaci.store.common.domain.Utxo;
import com.bloxbean.cardano.yaci.store.common.model.Order;
import com.bloxbean.cardano.yaci.store.utxo.domain.AddressTransaction;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorageReader;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AddressService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddressService.class);
    private final UtxoStorageReader utxoStorage;

    public List<Utxo> getUtxoByAddress(@NonNull String address, int page, int count, Order order) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return this.utxoStorage.findUtxoByAddress(address, page, count, order).stream().map(UtxoUtil::addressUtxoToUtxo).collect(Collectors.toList());
    }

    public List<Utxo> getUtxoByAddressAndAsset(@NonNull String address, String asset, int page, int count, Order order) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return this.utxoStorage.findUtxoByAddressAndAsset(address, asset, page, count, order).stream().map(UtxoUtil::addressUtxoToUtxo).collect(Collectors.toList());
    }

    public List<Utxo> getUtxoByPaymentCredential(@NonNull String addrOrPaymentCredOrVkh, int page, int count, Order order) {
        if (addrOrPaymentCredOrVkh == null) {
            throw new NullPointerException("addrOrPaymentCredOrVkh is marked non-null but is null");
        }
        String paymentCred = AddressService.getPaymentCredential(addrOrPaymentCredOrVkh);
        return this.utxoStorage.findUtxoByPaymentCredential(paymentCred, page, count, order).stream().map(UtxoUtil::addressUtxoToUtxo).collect(Collectors.toList());
    }

    public List<Utxo> getUtxoByPaymentCredentialAndAsset(@NonNull String addrOrPaymentCredOrVkh, String asset, int page, int count, Order order) {
        if (addrOrPaymentCredOrVkh == null) {
            throw new NullPointerException("addrOrPaymentCredOrVkh is marked non-null but is null");
        }
        String paymentCred = AddressService.getPaymentCredential(addrOrPaymentCredOrVkh);
        return this.utxoStorage.findUtxoByPaymentCredentialAndAsset(paymentCred, asset, page, count, order).stream().map(UtxoUtil::addressUtxoToUtxo).collect(Collectors.toList());
    }

    public List<Utxo> getUtxoByStakeAddress(@NonNull String stakeAddress, int page, int count, Order order) {
        if (stakeAddress == null) {
            throw new NullPointerException("stakeAddress is marked non-null but is null");
        }
        return this.utxoStorage.findUtxoByStakeAddress(stakeAddress, page, count, order).stream().map(UtxoUtil::addressUtxoToUtxo).collect(Collectors.toList());
    }

    public List<Utxo> getUtxoByStakeAddressAndAsset(@NonNull String stakeAddress, String asset, int page, int count, Order order) {
        if (stakeAddress == null) {
            throw new NullPointerException("stakeAddress is marked non-null but is null");
        }
        return this.utxoStorage.findUtxoByStakeAddressAndAsset(stakeAddress, asset, page, count, order).stream().map(UtxoUtil::addressUtxoToUtxo).collect(Collectors.toList());
    }

    public List<AddressTransaction> getTransactionsByAddress(@NonNull String address, int page, int count, Order order) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return this.utxoStorage.findTransactionsByAddress(address, page, count, order);
    }

    private static String getPaymentCredential(String address) {
        String paymentCredential;
        if (address.startsWith("addr_vkh")) {
            paymentCredential = HexUtil.encodeHexString((byte[])Bech32.decode((String)address).data);
        } else if (address.startsWith("addr")) {
            Address _address = new Address(address);
            paymentCredential = _address.getPaymentCredential().map(credential -> HexUtil.encodeHexString((byte[])credential.getBytes())).orElse(null);
        } else {
            paymentCredential = address;
        }
        return paymentCredential;
    }

    @Generated
    public AddressService(UtxoStorageReader utxoStorage) {
        this.utxoStorage = utxoStorage;
    }
}

