/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.processor;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressProvider;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import com.bloxbean.cardano.yaci.store.common.cache.Cache;
import com.bloxbean.cardano.yaci.store.common.cache.MVMapCache;
import com.bloxbean.cardano.yaci.store.common.cache.MVStoreFactory;
import com.bloxbean.cardano.yaci.store.common.config.StoreProperties;
import com.bloxbean.cardano.yaci.store.events.GenesisBlockEvent;
import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import com.bloxbean.cardano.yaci.store.events.internal.CommitEvent;
import com.bloxbean.cardano.yaci.store.utxo.UtxoStoreProperties;
import com.bloxbean.cardano.yaci.store.utxo.cache.GuavaCache;
import com.bloxbean.cardano.yaci.store.utxo.cache.NoCache;
import com.bloxbean.cardano.yaci.store.utxo.domain.Address;
import com.bloxbean.cardano.yaci.store.utxo.domain.AddressUtxoEvent;
import com.bloxbean.cardano.yaci.store.utxo.storage.AddressStorage;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AddressProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddressProcessor.class);
    private final AddressStorage addressStorage;
    private final UtxoStoreProperties utxoStoreProperties;
    private final StoreProperties storeProperties;
    private Cache<String, String> cache;
    private Map<String, com.bloxbean.cardano.yaci.store.utxo.domain.Address> addresseCache = new ConcurrentHashMap<String, com.bloxbean.cardano.yaci.store.utxo.domain.Address>();

    @PostConstruct
    public void init() {
        log.info("-- Address Processor Initialized with address cache size: {}, expiry: {} min", (Object)this.utxoStoreProperties.getAddressCacheSize(), (Object)this.utxoStoreProperties.getAddressCacheExpiryAfterAccess());
        if (this.utxoStoreProperties.isAddressCacheEnabled() && !this.storeProperties.isMvstoreEnabled()) {
            this.cache = new GuavaCache<String, String>(this.utxoStoreProperties.getAddressCacheSize(), this.utxoStoreProperties.getAddressCacheExpiryAfterAccess());
            log.info("<< Using Guava Cache for Address >>");
        } else if (!this.utxoStoreProperties.isAddressCacheEnabled()) {
            log.info("<< Address Cache is disabled >>");
            this.cache = new NoCache<String, String>();
        }
    }

    @EventListener
    public void handleAddress(AddressUtxoEvent addressUtxoEvent) {
        if (!this.utxoStoreProperties.isSaveAddress()) {
            return;
        }
        if (this.cache == null && this.utxoStoreProperties.isAddressCacheEnabled() && this.storeProperties.isMvstoreEnabled()) {
            this.cache = new MVMapCache(MVStoreFactory.getInstance().getStore(), "address");
            log.info("<< Using MVStore Cache for Address >>");
        }
        addressUtxoEvent.getTxInputOutputs().stream().flatMap(txInputOutput -> txInputOutput.getOutputs().stream()).filter(addressUtxo -> this.cache.get((Object)addressUtxo.getOwnerAddr()) == null).forEach(addressUtxo -> {
            Object address = ((Address.AddressBuilder)((Address.AddressBuilder)((Address.AddressBuilder)((Address.AddressBuilder)com.bloxbean.cardano.yaci.store.utxo.domain.Address.builder().address(addressUtxo.getOwnerAddr())).stakeAddress(addressUtxo.getOwnerStakeAddr())).paymentCredential(addressUtxo.getOwnerPaymentCredential())).stakeCredential(addressUtxo.getOwnerStakeCredential())).build();
            this.addresseCache.putIfAbsent(((com.bloxbean.cardano.yaci.store.utxo.domain.Address)address).getAddress(), (com.bloxbean.cardano.yaci.store.utxo.domain.Address)address);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    @Transactional
    public void handleCommit(CommitEvent commitEvent) {
        if (!this.utxoStoreProperties.isSaveAddress()) {
            return;
        }
        try {
            if (this.addresseCache.size() > 0) {
                long t1 = System.currentTimeMillis();
                this.addressStorage.save(this.addresseCache.values());
                if (!commitEvent.getMetadata().isSyncMode()) {
                    this.addresseCache.values().forEach(address -> this.cache.put((Object)address.getAddress(), (Object)""));
                }
                long t2 = System.currentTimeMillis();
                log.info("Address save size : {}, time: {} ms", (Object)this.addresseCache.size(), (Object)(t2 - t1));
                log.info("Address Cache Size: {}", (Object)this.cache.size());
            }
        }
        finally {
            this.addresseCache.clear();
        }
    }

    @EventListener
    @Transactional
    public void handleGenesisBalances(GenesisBlockEvent genesisBlockEvent) {
        if (!this.utxoStoreProperties.isSaveAddress()) {
            return;
        }
        List genesisBalances = genesisBlockEvent.getGenesisBalances();
        if (genesisBalances == null || genesisBalances.isEmpty()) {
            log.info("No genesis balances found");
            return;
        }
        Set<com.bloxbean.cardano.yaci.store.utxo.domain.Address> addresses = genesisBalances.stream().map(genesisBalance -> {
            String paymentCredential = null;
            String stakeCredential = null;
            String stakeAddress = null;
            try {
                Address address = new Address(genesisBalance.getAddress());
                paymentCredential = address.getPaymentCredential().map(credential -> HexUtil.encodeHexString((byte[])credential.getBytes())).orElse(null);
                stakeCredential = address.getDelegationCredential().map(delegCred -> HexUtil.encodeHexString((byte[])delegCred.getBytes())).orElse(null);
                stakeAddress = address.getDelegationCredential().map(delegCred -> AddressProvider.getStakeAddress((Address)address).toBech32()).orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ((Address.AddressBuilder)((Address.AddressBuilder)((Address.AddressBuilder)((Address.AddressBuilder)com.bloxbean.cardano.yaci.store.utxo.domain.Address.builder().address(genesisBalance.getAddress())).paymentCredential(paymentCredential)).stakeCredential(stakeCredential)).stakeAddress(stakeAddress)).build();
        }).collect(Collectors.toSet());
        this.addressStorage.save(addresses);
    }

    @EventListener
    @Transactional
    public void handleRollback(RollbackEvent rollbackEvent) {
        this.addresseCache.clear();
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Generated
    public AddressProcessor(AddressStorage addressStorage, UtxoStoreProperties utxoStoreProperties, StoreProperties storeProperties) {
        this.addressStorage = addressStorage;
        this.utxoStoreProperties = utxoStoreProperties;
        this.storeProperties = storeProperties;
    }
}

