/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.processor;

import com.bloxbean.cardano.yaci.core.model.Amount;
import com.bloxbean.cardano.yaci.core.model.byron.ByronTx;
import com.bloxbean.cardano.yaci.core.model.byron.ByronTxOut;
import com.bloxbean.cardano.yaci.helper.model.Utxo;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.Amt;
import com.bloxbean.cardano.yaci.store.common.domain.TxInput;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.events.ByronMainBlockEvent;
import com.bloxbean.cardano.yaci.store.events.EventMetadata;
import com.bloxbean.cardano.yaci.store.utxo.domain.AddressUtxoEvent;
import com.bloxbean.cardano.yaci.store.utxo.domain.TxInputOutput;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ByronUtxoProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ByronUtxoProcessor.class);
    private final UtxoStorage utxoStorage;
    private final ApplicationEventPublisher publisher;

    @EventListener
    @Transactional
    public void handleByronTransactionEvent(ByronMainBlockEvent event) {
        EventMetadata metadata = event.getMetadata();
        List byronTxList = event.getByronMainBlock().getBody().getTxPayload().stream().map(byronTxPayload -> byronTxPayload.getTransaction()).collect(Collectors.toList());
        ArrayList<TxInputOutput> txInputOutputList = new ArrayList<TxInputOutput>();
        for (ByronTx byronTx : byronTxList) {
            List<TxInput> spentOutputs = byronTx.getInputs().stream().map(txIn -> new UtxoKey(txIn.getTxId(), Integer.valueOf(txIn.getIndex()))).map(utxoKey -> {
                TxInput txInput = new TxInput();
                txInput.setTxHash(utxoKey.getTxHash());
                txInput.setOutputIndex(utxoKey.getOutputIndex());
                txInput.setSpentAtSlot(Long.valueOf(metadata.getSlot()));
                txInput.setSpentAtBlock(Long.valueOf(metadata.getBlock()));
                txInput.setSpentAtBlockHash(metadata.getBlockHash());
                txInput.setSpentBlockTime(Long.valueOf(metadata.getBlockTime()));
                txInput.setSpentEpoch(Integer.valueOf(metadata.getEpochNumber()));
                txInput.setSpentTxHash(byronTx.getTxHash());
                return txInput;
            }).collect(Collectors.toList());
            List<Utxo> utxos = this.getUtxosFromByronOutput(byronTx);
            List<AddressUtxo> outputAddressUtxos = utxos.stream().map(utxo -> this.getAddressUtxo(metadata, (Utxo)utxo)).collect(Collectors.toList());
            if (outputAddressUtxos.size() > 0) {
                this.utxoStorage.saveUnspent(outputAddressUtxos);
            }
            if (spentOutputs.size() > 0) {
                this.utxoStorage.saveSpent(spentOutputs);
            }
            if (outputAddressUtxos.size() <= 0) continue;
            txInputOutputList.add(new TxInputOutput(byronTx.getTxHash(), spentOutputs, outputAddressUtxos));
        }
        this.publisher.publishEvent((Object)new AddressUtxoEvent(metadata, txInputOutputList));
    }

    private List<Utxo> getUtxosFromByronOutput(ByronTx byronTx) {
        ArrayList<Utxo> utxos = new ArrayList<Utxo>();
        for (int index = 0; index < byronTx.getOutputs().size(); ++index) {
            ByronTxOut txOut = (ByronTxOut)byronTx.getOutputs().get(index);
            Utxo utxo = Utxo.builder().txHash(byronTx.getTxHash()).index(index).address(txOut.getAddress().getBase58Raw()).amounts(List.of(Amount.builder().unit("lovelace").assetName("lovelace").quantity(txOut.getAmount()).build())).build();
            utxos.add(utxo);
        }
        return utxos;
    }

    private AddressUtxo getAddressUtxo(@NonNull EventMetadata eventMetadata, @NonNull Utxo utxo) {
        if (eventMetadata == null) {
            throw new NullPointerException("eventMetadata is marked non-null but is null");
        }
        if (utxo == null) {
            throw new NullPointerException("utxo is marked non-null but is null");
        }
        List amounts = utxo.getAmounts().stream().map(amount -> Amt.builder().unit(amount.getUnit() != null ? amount.getUnit().replace(".", "") : null).policyId(amount.getPolicyId()).assetName(amount.getAssetName().replace('\u0000', ' ')).quantity(amount.getQuantity()).build()).collect(Collectors.toList());
        BigInteger lovelaceAmount = amounts.stream().filter(amount -> "lovelace".equals(amount.getUnit())).findFirst().map(Amt::getQuantity).orElse(BigInteger.ZERO);
        String stakeAddress = null;
        String paymentKeyHash = null;
        String stakeKeyHash = null;
        return ((AddressUtxo.AddressUtxoBuilder)((AddressUtxo.AddressUtxoBuilder)AddressUtxo.builder().slot(Long.valueOf(eventMetadata.getSlot())).blockNumber(Long.valueOf(eventMetadata.getBlock()))).blockHash(eventMetadata.getBlockHash()).blockTime(Long.valueOf(eventMetadata.getBlockTime()))).epoch(Integer.valueOf(eventMetadata.getEpochNumber())).txHash(utxo.getTxHash()).outputIndex(Integer.valueOf(utxo.getIndex())).ownerAddr(utxo.getAddress()).ownerStakeAddr(stakeAddress).ownerPaymentCredential(paymentKeyHash).ownerStakeCredential(stakeKeyHash).lovelaceAmount(lovelaceAmount).amounts(amounts).build();
    }

    @Generated
    public ByronUtxoProcessor(UtxoStorage utxoStorage, ApplicationEventPublisher publisher) {
        this.utxoStorage = utxoStorage;
        this.publisher = publisher;
    }
}

