/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.scheduler;

import com.bloxbean.cardano.yaci.store.common.service.CursorService;
import com.bloxbean.cardano.yaci.store.events.EpochChangeEvent;
import com.bloxbean.cardano.yaci.store.utxo.UtxoStoreProperties;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorage;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@ConditionalOnProperty(value={"store.utxo.pruning-enabled"}, havingValue="true", matchIfMissing=false)
public class UtxoPruningService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoPruningService.class);
    private final UtxoStorage utxoStorage;
    private final CursorService cursorService;
    private final UtxoStoreProperties utxoStoreProperties;
    private AtomicBoolean isPruning = new AtomicBoolean(false);

    @PostConstruct
    public void init() {
        log.info("<< Utxo Pruning Service Enabled >>");
    }

    @Scheduled(fixedRateString="${store.utxo.pruning-interval:86400}", timeUnit=TimeUnit.SECONDS, initialDelay=120L)
    public void handleUtxoPruning() {
        if (this.isPruning.get()) {
            log.info("Utxo pruning is already in progress. Skipping this run !!!");
            return;
        }
        Thread.startVirtualThread(() -> this.deleteSpentUtxos());
    }

    @EventListener
    @Transactional
    public void handleEpochChangeEvent(EpochChangeEvent epochChangeEvent) {
        if (this.isPruning.get()) {
            log.info("Utxo pruning is already in progress. Skipping this run !!!");
            return;
        }
        Thread.startVirtualThread(() -> this.deleteSpentUtxos());
    }

    private void deleteSpentUtxos() {
        this.isPruning.set(true);
        try {
            this.cursorService.getCursor().ifPresent(cursor -> {
                log.info("Current cursor: {}", (Object)cursor.getBlock());
                long block = cursor.getBlock() - (long)this.utxoStoreProperties.getPruningSafeBlocks();
                if (block > 0L) {
                    long t1 = System.currentTimeMillis();
                    int deleteCount = this.utxoStorage.deleteBySpentAndBlockLessThan(block);
                    long t2 = System.currentTimeMillis();
                    log.info("Deleted {} spent utxos before block {}, Time taken: {} ms", new Object[]{deleteCount, block, t2 - t1});
                }
            });
        }
        finally {
            this.isPruning.set(false);
        }
    }

    @Generated
    public UtxoPruningService(UtxoStorage utxoStorage, CursorService cursorService, UtxoStoreProperties utxoStoreProperties) {
        this.utxoStorage = utxoStorage;
        this.cursorService = cursorService;
        this.utxoStoreProperties = utxoStoreProperties;
    }
}

