/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.storage.impl;

import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.common.model.Order;
import com.bloxbean.cardano.yaci.store.utxo.domain.AddressTransaction;
import com.bloxbean.cardano.yaci.store.utxo.jooq.Tables;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorageReader;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.mapper.UtxoMapper;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.model.UtxoId;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.repository.UtxoRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectLimitPercentAfterOffsetStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class UtxoStorageReaderImpl
implements UtxoStorageReader {
    private final UtxoRepository utxoRepository;
    private final DSLContext dsl;
    private final UtxoMapper mapper = UtxoMapper.INSTANCE;

    @Override
    public Optional<AddressUtxo> findById(String txHash, int outputIndex) {
        return this.utxoRepository.findById(new UtxoId(txHash, outputIndex)).map(this.mapper::toAddressUtxo);
    }

    @Override
    public List<AddressUtxo> findUtxoByAddress(@NonNull String address, int page, int count, Order order) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        return this.utxoRepository.findUnspentByOwnerAddr(address, (Pageable)pageable).stream().flatMap(addressUtxoEntities -> addressUtxoEntities.stream().map(this.mapper::toAddressUtxo)).toList();
    }

    @Override
    public List<AddressUtxo> findUtxosByAsset(String unit, int page, int count, Order order) {
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        SelectLimitPercentAfterOffsetStep query = this.dsl.select((SelectFieldOrAsterisk[])Tables.ADDRESS_UTXO.fields()).from((TableLike)Tables.ADDRESS_UTXO).leftJoin((TableLike)Tables.TX_INPUT).using(new Field[]{DSL.field(Tables.ADDRESS_UTXO.TX_HASH), DSL.field(Tables.ADDRESS_UTXO.OUTPUT_INDEX)}).where(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\": \"" + unit + "\"")).or(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\":\"" + unit + "\"")))).and(Tables.TX_INPUT.TX_HASH.isNull()).offset((Number)pageable.getOffset()).limit((Number)pageable.getPageSize());
        return query.fetch().into(AddressUtxo.class);
    }

    @Override
    public List<AddressUtxo> findUtxoByAddressAndAsset(String address, String unit, int page, int count, Order order) {
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        SelectLimitPercentAfterOffsetStep query = this.dsl.select((SelectFieldOrAsterisk[])Tables.ADDRESS_UTXO.fields()).from((TableLike)Tables.ADDRESS_UTXO).leftJoin((TableLike)Tables.TX_INPUT).using(new Field[]{DSL.field(Tables.ADDRESS_UTXO.TX_HASH), DSL.field(Tables.ADDRESS_UTXO.OUTPUT_INDEX)}).where(Tables.ADDRESS_UTXO.OWNER_ADDR.eq((Object)address)).and(Tables.TX_INPUT.TX_HASH.isNull()).and(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\": \"" + unit + "\"")).or(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\":\"" + unit + "\"")))).offset((Number)pageable.getOffset()).limit((Number)pageable.getPageSize());
        return query.fetch().into(AddressUtxo.class);
    }

    @Override
    public List<AddressUtxo> findUtxoByPaymentCredential(@NonNull String paymentCredential, int page, int count, Order order) {
        if (paymentCredential == null) {
            throw new NullPointerException("paymentCredential is marked non-null but is null");
        }
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        return this.utxoRepository.findUnspentByOwnerPaymentCredential(paymentCredential, (Pageable)pageable).stream().flatMap(addressUtxoEntities -> addressUtxoEntities.stream().map(this.mapper::toAddressUtxo)).toList();
    }

    @Override
    public List<AddressUtxo> findUtxoByPaymentCredentialAndAsset(String paymentCredential, String unit, int page, int count, Order order) {
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        SelectLimitPercentAfterOffsetStep query = this.dsl.select((SelectFieldOrAsterisk[])Tables.ADDRESS_UTXO.fields()).from((TableLike)Tables.ADDRESS_UTXO).leftJoin((TableLike)Tables.TX_INPUT).using(new Field[]{DSL.field(Tables.ADDRESS_UTXO.TX_HASH), DSL.field(Tables.ADDRESS_UTXO.OUTPUT_INDEX)}).where(Tables.ADDRESS_UTXO.OWNER_PAYMENT_CREDENTIAL.eq((Object)paymentCredential)).and(Tables.TX_INPUT.TX_HASH.isNull()).and(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\": \"" + unit + "\"")).or(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\":\"" + unit + "\"")))).offset((Number)pageable.getOffset()).limit((Number)pageable.getPageSize());
        return query.fetch().into(AddressUtxo.class);
    }

    @Override
    public List<AddressUtxo> findUtxoByStakeAddress(@NonNull String stakeAddress, int page, int count, Order order) {
        if (stakeAddress == null) {
            throw new NullPointerException("stakeAddress is marked non-null but is null");
        }
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        return this.utxoRepository.findUnspentByOwnerStakeAddr(stakeAddress, (Pageable)pageable).stream().flatMap(addressUtxoEntities -> addressUtxoEntities.stream().map(this.mapper::toAddressUtxo)).toList();
    }

    @Override
    public List<AddressUtxo> findUtxoByStakeAddressAndAsset(@NonNull String stakeAddress, String unit, int page, int count, Order order) {
        if (stakeAddress == null) {
            throw new NullPointerException("stakeAddress is marked non-null but is null");
        }
        stakeAddress = stakeAddress.trim();
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        SelectLimitPercentAfterOffsetStep query = this.dsl.select((SelectFieldOrAsterisk[])Tables.ADDRESS_UTXO.fields()).from((TableLike)Tables.ADDRESS_UTXO).leftJoin((TableLike)Tables.TX_INPUT).using(new Field[]{DSL.field(Tables.ADDRESS_UTXO.TX_HASH), DSL.field(Tables.ADDRESS_UTXO.OUTPUT_INDEX)}).where(Tables.ADDRESS_UTXO.OWNER_STAKE_ADDR.eq((Object)stakeAddress)).and(Tables.TX_INPUT.TX_HASH.isNull()).and(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\": \"" + unit + "\"")).or(DSL.field(Tables.ADDRESS_UTXO.AMOUNTS).cast(String.class).contains((Object)("\"unit\":\"" + unit + "\"")))).offset((Number)pageable.getOffset()).limit((Number)pageable.getPageSize());
        return query.fetch().into(AddressUtxo.class);
    }

    @Override
    public List<AddressUtxo> findAllByIds(List<UtxoKey> utxoKeys) {
        List<UtxoId> utxoIds = utxoKeys.stream().map(utxoKey -> new UtxoId(utxoKey.getTxHash(), utxoKey.getOutputIndex())).toList();
        return this.utxoRepository.findAllById(utxoIds).stream().map(this.mapper::toAddressUtxo).toList();
    }

    @Override
    public List<AddressTransaction> findTransactionsByAddress(String address, int page, int count, Order order) {
        PageRequest pageable = UtxoStorageReaderImpl.getPageable(page, count, order);
        SelectConditionStep addressUtxoTx = this.dsl.select(Tables.ADDRESS_UTXO.TX_HASH, Tables.ADDRESS_UTXO.BLOCK, Tables.ADDRESS_UTXO.BLOCK_TIME).from((TableLike)Tables.ADDRESS_UTXO).where(Tables.ADDRESS_UTXO.OWNER_ADDR.eq((Object)address));
        SelectConditionStep spentTx = this.dsl.select((SelectField)Tables.TX_INPUT.SPENT_TX_HASH.as("tx_hash"), (SelectField)Tables.TX_INPUT.SPENT_AT_BLOCK.as("block"), (SelectField)Tables.TX_INPUT.SPENT_BLOCK_TIME.as("block_time")).from((TableLike)Tables.TX_INPUT).join((TableLike)Tables.ADDRESS_UTXO).on(Tables.TX_INPUT.TX_HASH.eq(Tables.ADDRESS_UTXO.TX_HASH)).and(Tables.TX_INPUT.OUTPUT_INDEX.eq(Tables.ADDRESS_UTXO.OUTPUT_INDEX)).where(Tables.ADDRESS_UTXO.OWNER_ADDR.eq((Object)address));
        Select combinedTx = addressUtxoTx.union((Select)spentTx);
        List result = this.dsl.selectDistinct((SelectField)DSL.field((String)"tx_hash", String.class).as("txHash"), (SelectField)DSL.field((String)"block", Long.class).as("blockNumber"), (SelectField)DSL.field((String)"block_time", Long.class).as("blockTime")).from((TableLike)combinedTx.asTable("combined_tx")).orderBy((OrderField)(order.equals((Object)Order.desc) ? DSL.field((String)"block").desc() : DSL.field((String)"block").asc())).limit((Number)pageable.getPageSize()).offset((Number)((int)pageable.getOffset())).fetchInto(AddressTransaction.class);
        return result;
    }

    private static PageRequest getPageable(int page, int count, Order order) {
        return PageRequest.of((int)page, (int)count).withSort(order.equals((Object)Order.desc) ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"slot", "txHash", "outputIndex"});
    }

    @Generated
    public UtxoStorageReaderImpl(UtxoRepository utxoRepository, DSLContext dsl) {
        this.utxoRepository = utxoRepository;
        this.dsl = dsl;
    }
}

