/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.processor;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.Amt;
import com.bloxbean.cardano.yaci.store.events.GenesisBalance;
import com.bloxbean.cardano.yaci.store.events.GenesisBlockEvent;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorage;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GenesisUtxoProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenesisUtxoProcessor.class);
    private final UtxoStorage utxoStorage;

    @EventListener
    @Transactional
    public void processGenesisUtxos(GenesisBlockEvent genesisBlockEvent) {
        log.info("Processing genesis utxos ...");
        List genesisBalanceList = genesisBlockEvent.getGenesisBalances();
        if (genesisBalanceList == null || genesisBalanceList.size() == 0) {
            log.info("No genesis utxos found");
            return;
        }
        ArrayList<AddressUtxo> genesisUtxos = new ArrayList<AddressUtxo>();
        for (GenesisBalance genesisBalance : genesisBalanceList) {
            String ownerPaymentCredential = null;
            String ownerStakeCredential = null;
            if (genesisBalance.getAddress() != null && genesisBalance.getAddress().startsWith("addr")) {
                Address address = new Address(genesisBalance.getAddress());
                ownerPaymentCredential = address.getPaymentCredential().map(paymentKeyHash -> HexUtil.encodeHexString((byte[])paymentKeyHash.getBytes())).orElse(null);
                ownerStakeCredential = address.getDelegationCredential().map(delegationHash -> HexUtil.encodeHexString((byte[])delegationHash.getBytes())).orElse(null);
            }
            AddressUtxo addressUtxo = ((AddressUtxo.AddressUtxoBuilder)((AddressUtxo.AddressUtxoBuilder)AddressUtxo.builder().slot(Long.valueOf(genesisBlockEvent.getSlot())).blockNumber(Long.valueOf(genesisBlockEvent.getBlock()))).blockHash(genesisBlockEvent.getBlockHash()).blockTime(Long.valueOf(genesisBlockEvent.getBlockTime()))).epoch(Integer.valueOf(0)).txHash(genesisBalance.getTxnHash()).outputIndex(Integer.valueOf(0)).ownerAddr(genesisBalance.getAddress()).ownerPaymentCredential(ownerPaymentCredential).ownerStakeCredential(ownerStakeCredential).lovelaceAmount(genesisBalance.getBalance()).amounts(List.of(new Amt("lovelace", "", "lovelace", genesisBalance.getBalance()))).build();
            genesisUtxos.add(addressUtxo);
        }
        this.utxoStorage.saveUnspent(genesisUtxos);
    }

    @Generated
    public GenesisUtxoProcessor(UtxoStorage utxoStorage) {
        this.utxoStorage = utxoStorage;
    }
}

