/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.processor;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressProvider;
import com.bloxbean.cardano.client.address.AddressType;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import com.bloxbean.cardano.yaci.helper.model.Transaction;
import com.bloxbean.cardano.yaci.helper.model.Utxo;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.Amt;
import com.bloxbean.cardano.yaci.store.common.domain.TxInput;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.common.util.ScriptReferenceUtil;
import com.bloxbean.cardano.yaci.store.common.util.StringUtil;
import com.bloxbean.cardano.yaci.store.events.EventMetadata;
import com.bloxbean.cardano.yaci.store.events.TransactionEvent;
import com.bloxbean.cardano.yaci.store.utxo.domain.AddressUtxoEvent;
import com.bloxbean.cardano.yaci.store.utxo.domain.TxInputOutput;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorage;
import com.bloxbean.cardano.yaci.store.utxo.util.Util;
import io.micrometer.core.instrument.MeterRegistry;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UtxoProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoProcessor.class);
    private final UtxoStorage utxoStorage;
    private final ApplicationEventPublisher publisher;
    private final MeterRegistry meterRegistry;

    @EventListener
    @Order(value=2)
    @Transactional
    public void handleTransactionEvent(TransactionEvent event) {
        try {
            List transactions = event.getTransactions();
            if (transactions == null) {
                return;
            }
            Stream transactionStream = transactions.stream();
            List<TxInputOutput> txInputOutputs = transactionStream.map(transaction -> {
                Optional<TxInputOutput> txInputOutputOptional = transaction.isInvalid() ? this.handleInvalidTransaction(event.getMetadata(), (Transaction)transaction) : this.handleValidTransaction(event.getMetadata(), (Transaction)transaction);
                return txInputOutputOptional;
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            this.utxoStorage.saveSpent(txInputOutputs.stream().flatMap(txInputOutput -> txInputOutput.getInputs().stream()).collect(Collectors.toList()));
            this.utxoStorage.saveUnspent(txInputOutputs.stream().flatMap(txInputOutput -> txInputOutput.getOutputs().stream()).collect(Collectors.toList()));
            this.publisher.publishEvent((Object)new AddressUtxoEvent(event.getMetadata(), txInputOutputs));
        }
        catch (Exception e) {
            log.error("Error saving : " + String.valueOf(event.getMetadata()), (Throwable)e);
            log.error("Stopping fetcher");
            throw new RuntimeException(e);
        }
    }

    private Optional<TxInputOutput> handleValidTransaction(EventMetadata metadata, Transaction transaction) {
        if (transaction.isInvalid()) {
            return Optional.empty();
        }
        List<TxInput> spentOutupts = transaction.getBody().getInputs().stream().map(transactionInput -> new UtxoKey(transactionInput.getTransactionId(), Integer.valueOf(transactionInput.getIndex()))).map(utxoKey -> {
            TxInput txInput = new TxInput();
            txInput.setTxHash(utxoKey.getTxHash());
            txInput.setOutputIndex(utxoKey.getOutputIndex());
            txInput.setSpentAtSlot(Long.valueOf(metadata.getSlot()));
            txInput.setSpentAtBlock(Long.valueOf(metadata.getBlock()));
            txInput.setSpentAtBlockHash(metadata.getBlockHash());
            txInput.setSpentBlockTime(Long.valueOf(metadata.getBlockTime()));
            txInput.setSpentEpoch(Integer.valueOf(metadata.getEpochNumber()));
            txInput.setSpentTxHash(transaction.getTxHash());
            return txInput;
        }).collect(Collectors.toList());
        List<AddressUtxo> outputAddressUtxos = transaction.getUtxos().stream().map(utxo -> this.getAddressUtxo(metadata, (Utxo)utxo)).collect(Collectors.toList());
        if (outputAddressUtxos.size() > 0 || spentOutupts.size() > 0) {
            return Optional.of(new TxInputOutput(transaction.getTxHash(), spentOutupts, outputAddressUtxos));
        }
        log.warn("No input or output found for transaction: " + transaction.getTxHash());
        return Optional.empty();
    }

    private Optional<TxInputOutput> handleInvalidTransaction(EventMetadata metadata, Transaction transaction) {
        if (!transaction.isInvalid()) {
            return Optional.empty();
        }
        AddressUtxo collateralOutputUtxo = Optional.ofNullable(transaction.getCollateralReturnUtxo()).map(utxo -> this.getCollateralReturnAddressUtxo(metadata, (Utxo)utxo)).orElse(null);
        if (collateralOutputUtxo != null) {
            collateralOutputUtxo.setOutputIndex(Integer.valueOf(transaction.getBody().getOutputs().size()));
        }
        List<TxInput> collateralInputUtxos = transaction.getBody().getCollateralInputs().stream().map(transactionInput -> {
            TxInput txInput = new TxInput();
            txInput.setTxHash(transactionInput.getTransactionId());
            txInput.setOutputIndex(Integer.valueOf(transactionInput.getIndex()));
            txInput.setSpentAtSlot(Long.valueOf(metadata.getSlot()));
            txInput.setSpentAtBlock(Long.valueOf(metadata.getBlock()));
            txInput.setSpentAtBlockHash(metadata.getBlockHash());
            txInput.setSpentBlockTime(Long.valueOf(metadata.getBlockTime()));
            txInput.setSpentEpoch(Integer.valueOf(metadata.getEpochNumber()));
            txInput.setSpentTxHash(transaction.getTxHash());
            return txInput;
        }).collect(Collectors.toList());
        if (collateralOutputUtxo != null) {
            // empty if block
        }
        List<AddressUtxo> outputs = collateralOutputUtxo != null ? List.of(collateralOutputUtxo) : Collections.emptyList();
        return Optional.of(new TxInputOutput(transaction.getTxHash(), collateralInputUtxos, outputs));
    }

    private AddressUtxo getAddressUtxo(@NonNull EventMetadata eventMetadata, @NonNull Utxo utxo) {
        String stakeKeyHash;
        String paymentKeyHash;
        String stakeAddress;
        BigInteger lovelaceAmount;
        List amounts;
        block8: {
            if (eventMetadata == null) {
                throw new NullPointerException("eventMetadata is marked non-null but is null");
            }
            if (utxo == null) {
                throw new NullPointerException("utxo is marked non-null but is null");
            }
            amounts = utxo.getAmounts().stream().map(amount -> Amt.builder().unit(amount.getUnit() != null ? amount.getUnit().replace(".", "") : null).policyId(amount.getPolicyId()).assetName(amount.getAssetName().replace('\u0000', ' ')).quantity(amount.getQuantity()).build()).collect(Collectors.toList());
            lovelaceAmount = amounts.stream().filter(amount -> "lovelace".equals(amount.getUnit())).findFirst().map(Amt::getQuantity).orElse(BigInteger.ZERO);
            stakeAddress = null;
            paymentKeyHash = null;
            stakeKeyHash = null;
            try {
                Address addr = new Address(utxo.getAddress());
                if (addr.getAddressType() == AddressType.Base) {
                    stakeAddress = AddressProvider.getStakeAddress((Address)addr).getAddress();
                }
                paymentKeyHash = Util.getPaymentKeyHash(addr).orElse(null);
                stakeKeyHash = Util.getStakeKeyHash(addr).orElse(null);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block8;
                log.error("Unable to get stake address for address : " + utxo.getAddress(), (Throwable)e);
            }
        }
        String referenceScriptHash = null;
        if (!StringUtil.isEmpty((String)utxo.getScriptRef())) {
            try {
                referenceScriptHash = ScriptReferenceUtil.getReferenceScriptHash((byte[])HexUtil.decodeHexString((String)utxo.getScriptRef()));
            }
            catch (Exception e) {
                log.error("Unable to get reference script hash for script ref. Block: {}, TxHash:  {}", (Object)eventMetadata.getBlock(), (Object)utxo.getTxHash());
                log.error("Unable to get reference script hash for script ref : " + utxo.getScriptRef(), (Throwable)e);
            }
        }
        return ((AddressUtxo.AddressUtxoBuilder)((AddressUtxo.AddressUtxoBuilder)AddressUtxo.builder().slot(Long.valueOf(eventMetadata.getSlot())).blockNumber(Long.valueOf(eventMetadata.getBlock()))).blockHash(eventMetadata.getBlockHash()).blockTime(Long.valueOf(eventMetadata.getBlockTime()))).epoch(Integer.valueOf(eventMetadata.getEpochNumber())).txHash(utxo.getTxHash()).outputIndex(Integer.valueOf(utxo.getIndex())).ownerAddr(utxo.getAddress()).ownerStakeAddr(stakeAddress).ownerPaymentCredential(paymentKeyHash).ownerStakeCredential(stakeKeyHash).lovelaceAmount(lovelaceAmount).amounts(amounts).dataHash(utxo.getDatumHash()).inlineDatum(utxo.getInlineDatum()).referenceScriptHash(referenceScriptHash).scriptRef(utxo.getScriptRef()).build();
    }

    private AddressUtxo getCollateralReturnAddressUtxo(EventMetadata metadata, Utxo utxo) {
        AddressUtxo addressUtxo = this.getAddressUtxo(metadata, utxo);
        addressUtxo.setIsCollateralReturn(Boolean.TRUE);
        return addressUtxo;
    }

    @Generated
    public UtxoProcessor(UtxoStorage utxoStorage, ApplicationEventPublisher publisher, MeterRegistry meterRegistry) {
        this.utxoStorage = utxoStorage;
        this.publisher = publisher;
        this.meterRegistry = meterRegistry;
    }
}

