/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.processor;

import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UtxoRollbackProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoRollbackProcessor.class);
    private final UtxoStorage utxoStorage;

    @EventListener
    @Transactional
    public void handleRollbackEvent(RollbackEvent rollbackEvent) {
        long rollBackToSlot = rollbackEvent.getRollbackTo().getSlot();
        int deletedUnspent = this.utxoStorage.deleteUnspentBySlotGreaterThan(rollBackToSlot);
        int deletedSpent = this.utxoStorage.deleteSpentBySlotGreaterThan(rollBackToSlot);
        log.info("Rollback -- {} address_utxos records", (Object)deletedUnspent);
        log.info("Rollback -- {} spent output records", (Object)deletedSpent);
    }

    @Generated
    public UtxoRollbackProcessor(UtxoStorage utxoStorage) {
        this.utxoStorage = utxoStorage;
    }
}

