/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.storage.impl;

import com.bloxbean.cardano.yaci.store.common.config.StoreProperties;
import com.bloxbean.cardano.yaci.store.common.util.AddressUtil;
import com.bloxbean.cardano.yaci.store.common.util.ListUtil;
import com.bloxbean.cardano.yaci.store.common.util.Tuple;
import com.bloxbean.cardano.yaci.store.utxo.domain.Address;
import com.bloxbean.cardano.yaci.store.utxo.jooq.Tables;
import com.bloxbean.cardano.yaci.store.utxo.storage.AddressStorage;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.jooq.DSLContext;
import org.jooq.InsertReturningStep;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class AddressStorageImpl
implements AddressStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddressStorageImpl.class);
    private final DSLContext dsl;
    private final StoreProperties storeProperties;

    @Override
    @Transactional
    public void save(Collection<Address> addresses) {
        if (this.storeProperties.isParallelWrite() && addresses.size() > this.storeProperties.getWriteThreadDefaultBatchSize()) {
            int partitionSize = this.getPartitionSize(addresses.size());
            ListUtil.partitionAndApply(addresses.stream().toList(), (int)partitionSize, this::saveBatch);
        } else {
            this.saveBatch(addresses);
        }
    }

    private void saveBatch(Collection<Address> addresses) {
        LocalDateTime localDateTime = LocalDateTime.now();
        List<InsertReturningStep> inserts = addresses.stream().map(address -> {
            Tuple addressTuple = AddressUtil.getAddress((String)address.getAddress());
            return this.dsl.insertInto((Table)Tables.ADDRESS).set(Tables.ADDRESS.ADDRESS_, (Object)((String)addressTuple._1)).set(Tables.ADDRESS.ADDR_FULL, (Object)((String)addressTuple._2)).set(Tables.ADDRESS.PAYMENT_CREDENTIAL, (Object)address.getPaymentCredential()).set(Tables.ADDRESS.STAKE_ADDRESS, (Object)address.getStakeAddress()).set(Tables.ADDRESS.STAKE_CREDENTIAL, (Object)address.getStakeCredential()).set(Tables.ADDRESS.UPDATE_DATETIME, (Object)localDateTime).onDuplicateKeyIgnore();
        }).toList();
        this.dsl.batch(inserts).execute();
    }

    private int getPartitionSize(int totalSize) {
        int partitionSize = totalSize;
        if (totalSize > this.storeProperties.getWriteThreadDefaultBatchSize()) {
            partitionSize = totalSize / this.storeProperties.getWriteThreadCount();
            log.info("\tAddress Partition size : {}", (Object)partitionSize);
        } else {
            log.info("\tAddress Partition size : {}", (Object)partitionSize);
        }
        return partitionSize;
    }

    @Generated
    public AddressStorageImpl(DSLContext dsl, StoreProperties storeProperties) {
        this.dsl = dsl;
        this.storeProperties = storeProperties;
    }
}

