/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.storage.impl;

import com.bloxbean.cardano.yaci.core.util.Tuple;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UtxoCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoCache.class);
    private Map<String, AddressUtxo> utxoCache = Collections.synchronizedMap(new HashMap());

    public Optional<AddressUtxo> get(String txHash, int outputIndex) {
        String key = this.getUtxoKey(txHash, outputIndex);
        AddressUtxo addrUtxo = this.utxoCache.get(key);
        if (addrUtxo == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(addrUtxo);
    }

    public void add(@NonNull AddressUtxo addressUtxo) {
        if (addressUtxo == null) {
            throw new NullPointerException("addressUtxo is marked non-null but is null");
        }
        String key = this.getUtxoKey(addressUtxo.getTxHash(), addressUtxo.getOutputIndex());
        this.utxoCache.put(key, addressUtxo);
    }

    public Tuple<List<AddressUtxo>, List<UtxoKey>> get(List<UtxoKey> utxoKeyList) {
        ArrayList<UtxoKey> notFoundList = null;
        ArrayList<AddressUtxo> foundList = new ArrayList<AddressUtxo>();
        for (UtxoKey utxoKey : utxoKeyList) {
            Optional<AddressUtxo> addressUtxoOptional = this.get(utxoKey.getTxHash(), utxoKey.getOutputIndex());
            if (addressUtxoOptional.isPresent()) {
                foundList.add(addressUtxoOptional.get());
                continue;
            }
            if (notFoundList == null) {
                notFoundList = new ArrayList<UtxoKey>();
            }
            notFoundList.add(utxoKey);
        }
        return new Tuple(foundList, notFoundList);
    }

    public List<AddressUtxo> getAll() {
        return new ArrayList<AddressUtxo>(this.utxoCache.values());
    }

    public int size() {
        return this.utxoCache.size();
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug("Clearing UTXO cache : " + this.utxoCache.size());
        }
        this.utxoCache.clear();
    }

    private String getUtxoKey(String txHash, int outputIndex) {
        return txHash + ":" + outputIndex;
    }
}

