/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.storage.impl;

import com.bloxbean.cardano.yaci.core.util.Tuple;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.TxInput;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.common.util.JsonUtil;
import com.bloxbean.cardano.yaci.store.events.internal.CommitEvent;
import com.bloxbean.cardano.yaci.store.utxo.jooq.Tables;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorage;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.UtxoCache;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.mapper.UtxoMapper;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.model.AddressUtxoEntity;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.model.UtxoId;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.repository.TxInputRepository;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.repository.UtxoRepository;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jooq.DSLContext;
import org.jooq.DeleteReturningStep;
import org.jooq.InsertOnDuplicateSetMoreStep;
import org.jooq.InsertReturningStep;
import org.jooq.JSON;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectLimitPercentStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public class UtxoStorageImpl
implements UtxoStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoStorageImpl.class);
    private final UtxoRepository utxoRepository;
    private final TxInputRepository spentOutputRepository;
    private final DSLContext dsl;
    private final UtxoMapper mapper = UtxoMapper.INSTANCE;
    private final UtxoCache utxoCache;
    private final PlatformTransactionManager transactionManager;
    private TransactionTemplate transactionTemplate;
    @Value(value="${store.utxo.pruning-batch-size:3000}")
    private int pruningBatchSize = 3000;

    @PostConstruct
    public void init() {
        this.transactionTemplate = new TransactionTemplate(this.transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
    }

    @Override
    public Optional<AddressUtxo> findById(String txHash, int outputIndex) {
        Optional<AddressUtxo> cacheUtxo = this.utxoCache.get(txHash, outputIndex);
        if (cacheUtxo.isPresent()) {
            return cacheUtxo;
        }
        Optional<AddressUtxo> savedUtxo = this.utxoRepository.findById(new UtxoId(txHash, outputIndex)).map(this.mapper::toAddressUtxo);
        savedUtxo.ifPresent(this.utxoCache::add);
        return savedUtxo;
    }

    @Override
    public List<AddressUtxo> findAllByIds(List<UtxoKey> utxoKeys) {
        Tuple<List<AddressUtxo>, List<UtxoKey>> cacheResult = this.utxoCache.get(utxoKeys);
        if (cacheResult._2 == null) {
            return (List)cacheResult._1;
        }
        List notFoundKeys = (List)cacheResult._2;
        List<UtxoId> utxoIds = notFoundKeys.stream().map(utxoKey -> new UtxoId(utxoKey.getTxHash(), utxoKey.getOutputIndex())).toList();
        List<AddressUtxo> savedUtxos = this.utxoRepository.findAllById(utxoIds).stream().map(this.mapper::toAddressUtxo).toList();
        if (savedUtxos != null) {
            savedUtxos.forEach(this.utxoCache::add);
        }
        ArrayList<AddressUtxo> finalUtxos = new ArrayList<AddressUtxo>();
        finalUtxos.addAll((Collection)cacheResult._1);
        finalUtxos.addAll(savedUtxos);
        return finalUtxos;
    }

    @Override
    @Transactional
    public int deleteUnspentBySlotGreaterThan(Long slot) {
        return this.utxoRepository.deleteBySlotGreaterThan(slot);
    }

    @Override
    @Transactional
    public int deleteSpentBySlotGreaterThan(Long slot) {
        return this.spentOutputRepository.deleteBySpentAtSlotGreaterThan(slot);
    }

    @Override
    @Transactional
    public int deleteBySpentAndBlockLessThan(Long block) {
        int count = 0;
        int totalCount = 0;
        int limit = this.pruningBatchSize;
        do {
            count = (Integer)this.transactionTemplate.execute(status -> {
                SelectLimitPercentStep spentSubQuery = this.dsl.select(Tables.TX_INPUT.TX_HASH, Tables.TX_INPUT.OUTPUT_INDEX).from((TableLike)Tables.TX_INPUT).where(Tables.TX_INPUT.SPENT_AT_BLOCK.lt((Object)block)).orderBy((OrderField)Tables.TX_INPUT.SPENT_AT_BLOCK.asc()).limit((Number)limit);
                int addressUtxoCount = this.dsl.deleteFrom((Table)Tables.ADDRESS_UTXO).where(DSL.row(Tables.ADDRESS_UTXO.TX_HASH, Tables.ADDRESS_UTXO.OUTPUT_INDEX).in((Select)spentSubQuery)).execute();
                DeleteReturningStep txInputQuery = this.dsl.deleteFrom((Table)Tables.TX_INPUT).where(Tables.TX_INPUT.SPENT_AT_BLOCK.lt((Object)block)).orderBy(new OrderField[]{Tables.TX_INPUT.SPENT_AT_BLOCK.asc()}).limit((Number)limit);
                int txInputCount = txInputQuery.execute();
                if (log.isDebugEnabled()) {
                    log.debug("Deleted {} address_utxo and {} utxo_amount records and tx_inputs: {}", (Object)addressUtxoCount, (Object)txInputCount);
                }
                int delCount = addressUtxoCount + txInputCount;
                return delCount;
            });
            totalCount += count;
        } while (count > 0);
        return totalCount;
    }

    @Override
    @Transactional
    public void saveUnspent(List<AddressUtxo> addressUtxoList) {
        List<AddressUtxoEntity> addressUtxoEntities = addressUtxoList.stream().map(this.mapper::toAddressUtxoEntity).toList();
        LocalDateTime localDateTime = LocalDateTime.now();
        List<InsertOnDuplicateSetMoreStep> inserts = addressUtxoEntities.stream().map(addressUtxo -> this.dsl.insertInto((Table)Tables.ADDRESS_UTXO).set(Tables.ADDRESS_UTXO.TX_HASH, (Object)addressUtxo.getTxHash()).set(Tables.ADDRESS_UTXO.OUTPUT_INDEX, (Object)addressUtxo.getOutputIndex()).set(Tables.ADDRESS_UTXO.SLOT, (Object)addressUtxo.getSlot()).set(Tables.ADDRESS_UTXO.BLOCK_HASH, (Object)addressUtxo.getBlockHash()).set(Tables.ADDRESS_UTXO.EPOCH, (Object)addressUtxo.getEpoch()).set(Tables.ADDRESS_UTXO.LOVELACE_AMOUNT, (Object)(addressUtxo.getLovelaceAmount() != null ? addressUtxo.getLovelaceAmount().longValue() : 0L)).set(Tables.ADDRESS_UTXO.AMOUNTS, (Object)JSON.valueOf((String)JsonUtil.getJson(addressUtxo.getAmounts()))).set(Tables.ADDRESS_UTXO.DATA_HASH, (Object)addressUtxo.getDataHash()).set(Tables.ADDRESS_UTXO.INLINE_DATUM, (Object)addressUtxo.getInlineDatum()).set(Tables.ADDRESS_UTXO.OWNER_ADDR, (Object)addressUtxo.getOwnerAddr()).set(Tables.ADDRESS_UTXO.OWNER_ADDR_FULL, (Object)addressUtxo.getOwnerAddrFull()).set(Tables.ADDRESS_UTXO.OWNER_STAKE_ADDR, (Object)addressUtxo.getOwnerStakeAddr()).set(Tables.ADDRESS_UTXO.OWNER_PAYMENT_CREDENTIAL, (Object)addressUtxo.getOwnerPaymentCredential()).set(Tables.ADDRESS_UTXO.OWNER_STAKE_CREDENTIAL, (Object)addressUtxo.getOwnerStakeCredential()).set(Tables.ADDRESS_UTXO.SCRIPT_REF, (Object)addressUtxo.getScriptRef()).set(Tables.ADDRESS_UTXO.REFERENCE_SCRIPT_HASH, (Object)addressUtxo.getReferenceScriptHash()).set(Tables.ADDRESS_UTXO.IS_COLLATERAL_RETURN, (Object)addressUtxo.getIsCollateralReturn()).set(Tables.ADDRESS_UTXO.BLOCK, (Object)addressUtxo.getBlockNumber()).set(Tables.ADDRESS_UTXO.BLOCK_TIME, (Object)addressUtxo.getBlockTime()).set(Tables.ADDRESS_UTXO.UPDATE_DATETIME, (Object)localDateTime).onDuplicateKeyUpdate().set(Tables.ADDRESS_UTXO.SLOT, (Object)addressUtxo.getSlot()).set(Tables.ADDRESS_UTXO.BLOCK_HASH, (Object)addressUtxo.getBlockHash()).set(Tables.ADDRESS_UTXO.EPOCH, (Object)addressUtxo.getEpoch()).set(Tables.ADDRESS_UTXO.LOVELACE_AMOUNT, (Object)(addressUtxo.getLovelaceAmount() != null ? addressUtxo.getLovelaceAmount().longValue() : 0L)).set(Tables.ADDRESS_UTXO.AMOUNTS, (Object)JSON.valueOf((String)JsonUtil.getJson(addressUtxo.getAmounts()))).set(Tables.ADDRESS_UTXO.DATA_HASH, (Object)addressUtxo.getDataHash()).set(Tables.ADDRESS_UTXO.INLINE_DATUM, (Object)addressUtxo.getInlineDatum()).set(Tables.ADDRESS_UTXO.OWNER_ADDR, (Object)addressUtxo.getOwnerAddr()).set(Tables.ADDRESS_UTXO.OWNER_ADDR_FULL, (Object)addressUtxo.getOwnerAddrFull()).set(Tables.ADDRESS_UTXO.OWNER_STAKE_ADDR, (Object)addressUtxo.getOwnerStakeAddr()).set(Tables.ADDRESS_UTXO.OWNER_PAYMENT_CREDENTIAL, (Object)addressUtxo.getOwnerPaymentCredential()).set(Tables.ADDRESS_UTXO.OWNER_STAKE_CREDENTIAL, (Object)addressUtxo.getOwnerStakeCredential()).set(Tables.ADDRESS_UTXO.SCRIPT_REF, (Object)addressUtxo.getScriptRef()).set(Tables.ADDRESS_UTXO.REFERENCE_SCRIPT_HASH, (Object)addressUtxo.getReferenceScriptHash()).set(Tables.ADDRESS_UTXO.IS_COLLATERAL_RETURN, (Object)addressUtxo.getIsCollateralReturn()).set(Tables.ADDRESS_UTXO.BLOCK, (Object)addressUtxo.getBlockNumber()).set(Tables.ADDRESS_UTXO.BLOCK_TIME, (Object)addressUtxo.getBlockTime()).set(Tables.ADDRESS_UTXO.UPDATE_DATETIME, (Object)localDateTime)).toList();
        this.dsl.batch(inserts).execute();
        addressUtxoList.forEach(this.utxoCache::add);
    }

    @Override
    @Transactional
    public void saveSpent(List<TxInput> txInputs) {
        if (txInputs == null || txInputs.isEmpty()) {
            return;
        }
        List<InsertReturningStep> inserts = txInputs.stream().map(spentOutput -> this.dsl.insertInto((Table)Tables.TX_INPUT).set(Tables.TX_INPUT.TX_HASH, (Object)spentOutput.getTxHash()).set(Tables.TX_INPUT.OUTPUT_INDEX, (Object)spentOutput.getOutputIndex()).set(Tables.TX_INPUT.SPENT_AT_SLOT, (Object)spentOutput.getSpentAtSlot()).set(Tables.TX_INPUT.SPENT_AT_BLOCK, (Object)spentOutput.getSpentAtBlock()).set(Tables.TX_INPUT.SPENT_AT_BLOCK_HASH, (Object)spentOutput.getSpentAtBlockHash()).set(Tables.TX_INPUT.SPENT_BLOCK_TIME, (Object)spentOutput.getSpentBlockTime()).set(Tables.TX_INPUT.SPENT_EPOCH, (Object)spentOutput.getSpentEpoch()).set(Tables.TX_INPUT.SPENT_TX_HASH, (Object)spentOutput.getSpentTxHash()).onDuplicateKeyIgnore()).toList();
        this.dsl.batch(inserts).execute();
    }

    @EventListener
    public void handleCommit(CommitEvent commitEvent) {
        this.utxoCache.clear();
    }

    @Generated
    public UtxoStorageImpl(UtxoRepository utxoRepository, TxInputRepository spentOutputRepository, DSLContext dsl, UtxoCache utxoCache, PlatformTransactionManager transactionManager) {
        this.utxoRepository = utxoRepository;
        this.spentOutputRepository = spentOutputRepository;
        this.dsl = dsl;
        this.utxoCache = utxoCache;
        this.transactionManager = transactionManager;
    }
}

