/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.storage.impl.mapper;

import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.TxInput;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.mapper.UtxoMapper;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.model.AddressUtxoEntity;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.model.TxInputEntity;

public class UtxoMapperDecorator
implements UtxoMapper {
    public static final int MAX_ADDR_SIZE = 500;
    private final UtxoMapper delegate;

    public UtxoMapperDecorator(UtxoMapper delegate) {
        this.delegate = delegate;
    }

    @Override
    public AddressUtxoEntity toAddressUtxoEntity(AddressUtxo addressUtxo) {
        AddressUtxoEntity entity = this.delegate.toAddressUtxoEntity(addressUtxo);
        if (addressUtxo.getOwnerAddr() != null && addressUtxo.getOwnerAddr().length() > 500) {
            entity.setOwnerAddr(addressUtxo.getOwnerAddr().substring(0, 500));
            entity.setOwnerAddrFull(addressUtxo.getOwnerAddr());
        }
        return entity;
    }

    @Override
    public AddressUtxo toAddressUtxo(AddressUtxoEntity entity) {
        AddressUtxo addressUtxo = this.delegate.toAddressUtxo(entity);
        if (entity.getOwnerAddrFull() != null && entity.getOwnerAddrFull().length() > 0) {
            addressUtxo.setOwnerAddr(entity.getOwnerAddrFull());
        }
        return addressUtxo;
    }

    @Override
    public TxInput toTxInput(TxInputEntity txInputEntity) {
        return this.delegate.toTxInput(txInputEntity);
    }
}

