/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.utxo.storage.impl.repository;

import com.bloxbean.cardano.yaci.store.utxo.storage.impl.model.AddressUtxoEntity;
import com.bloxbean.cardano.yaci.store.utxo.storage.impl.model.UtxoId;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface UtxoRepository
extends JpaRepository<AddressUtxoEntity, UtxoId> {
    @Query(value="SELECT a FROM AddressUtxoEntity a LEFT JOIN TxInputEntity s ON a.txHash = s.txHash AND a.outputIndex = s.outputIndex WHERE a.ownerAddr = :ownerAddress AND s.txHash IS NULL")
    public Optional<List<AddressUtxoEntity>> findUnspentByOwnerAddr(String var1, Pageable var2);

    @Query(value="SELECT a FROM AddressUtxoEntity a LEFT JOIN TxInputEntity s ON a.txHash = s.txHash AND a.outputIndex = s.outputIndex WHERE a.ownerStakeAddr = :ownerAddress AND s.txHash IS NULL")
    public Optional<List<AddressUtxoEntity>> findUnspentByOwnerStakeAddr(String var1, Pageable var2);

    @Query(value="SELECT a FROM AddressUtxoEntity a LEFT JOIN TxInputEntity s ON a.txHash = s.txHash AND a.outputIndex = s.outputIndex WHERE a.ownerPaymentCredential = :paymentKeyHash AND s.txHash IS NULL")
    public Optional<List<AddressUtxoEntity>> findUnspentByOwnerPaymentCredential(String var1, Pageable var2);

    @Query(value="SELECT a FROM AddressUtxoEntity a LEFT JOIN TxInputEntity s ON a.txHash = s.txHash AND a.outputIndex = s.outputIndex WHERE a.ownerStakeCredential = :delegationHash AND s.txHash IS NULL")
    public Optional<List<AddressUtxoEntity>> findUnspentByOwnerStakeCredential(String var1, Pageable var2);

    public List<AddressUtxoEntity> findAllById(Iterable<UtxoId> var1);

    public int deleteBySlotGreaterThan(Long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM AddressUtxoEntity a WHERE a IN (SELECT au FROM AddressUtxoEntity au JOIN TxInputEntity s ON au.txHash = s.txHash AND au.outputIndex = s.outputIndex AND s.spentAtBlock < :block)")
    public int deleteBySpentAndBlockLessThan(Long var1);
}

