/*
 * Decompiled with CFR 0.152.
 */
package com.blueapron.connect.protobuf;

import com.blueapron.connect.protobuf.ProtobufData;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.storage.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ProtobufConverter.class);
    private static final String PROTO_CLASS_NAME_CONFIG = "protoClassName";
    private static final String LEGACY_NAME_CONFIG = "legacyName";
    private static final String PROTO_MAP_CONVERSION_TYPE = "protoMapConversionType";
    private ProtobufData protobufData;

    private boolean isInvalidConfiguration(Object proto, boolean isKey) {
        return proto == null && !isKey;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object legacyName = configs.get(LEGACY_NAME_CONFIG);
        String legacyNameString = legacyName == null ? "legacy_name" : legacyName.toString();
        boolean useConnectSchemaMap = "map".equals(configs.get(PROTO_MAP_CONVERSION_TYPE));
        Object protoClassName = configs.get(PROTO_CLASS_NAME_CONFIG);
        if (this.isInvalidConfiguration(protoClassName, isKey)) {
            throw new ConnectException("Value converter must have a protoClassName configured");
        }
        if (protoClassName == null) {
            this.protobufData = null;
            return;
        }
        String protoClassNameString = protoClassName.toString();
        try {
            log.info("Initializing ProtobufData with args: [protoClassName={}, legacyName={}, useConnectSchemaMap={}]", new Object[]{protoClassNameString, legacyNameString, useConnectSchemaMap});
            this.protobufData = new ProtobufData(Class.forName(protoClassNameString).asSubclass(GeneratedMessageV3.class), legacyNameString, useConnectSchemaMap);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectException("Proto class " + protoClassNameString + " not found in the classpath");
        }
        catch (ClassCastException e) {
            throw new ConnectException("Proto class " + protoClassNameString + " is not a valid proto3 message class");
        }
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        if (this.protobufData == null || schema == null || value == null) {
            return null;
        }
        return this.protobufData.fromConnectData(value);
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        if (this.protobufData == null || value == null) {
            return SchemaAndValue.NULL;
        }
        return this.protobufData.toConnectData(value);
    }
}

