/*
 * Decompiled with CFR 0.152.
 */
package com.blueapron.connect.protobuf;

import com.blueapron.connect.protobuf.ProtobufUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.type.Date;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;

class ProtobufData {
    public static final String CONNECT_DECIMAL_PRECISION_PROP = "connect.decimal.precision";
    private final Method newBuilder;
    private final Schema schema;
    private final String legacyName;
    private final boolean useConnectSchemaMap;
    public static final Descriptors.FieldDescriptor.Type[] PROTO_TYPES_WITH_DEFAULTS = new Descriptors.FieldDescriptor.Type[]{Descriptors.FieldDescriptor.Type.INT32, Descriptors.FieldDescriptor.Type.INT64, Descriptors.FieldDescriptor.Type.SINT32, Descriptors.FieldDescriptor.Type.SINT64, Descriptors.FieldDescriptor.Type.FLOAT, Descriptors.FieldDescriptor.Type.DOUBLE, Descriptors.FieldDescriptor.Type.BOOL, Descriptors.FieldDescriptor.Type.STRING, Descriptors.FieldDescriptor.Type.BYTES, Descriptors.FieldDescriptor.Type.ENUM};
    private HashMap<String, String> connectProtoNameMap = new HashMap();

    private GeneratedMessageV3.Builder getBuilder() {
        try {
            return (GeneratedMessageV3.Builder)this.newBuilder.invoke(Object.class, new Object[0]);
        }
        catch (Exception e) {
            throw new ConnectException("Not a valid proto3 builder", (Throwable)e);
        }
    }

    private Message getMessage(byte[] value) {
        try {
            return this.getBuilder().mergeFrom(value).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new DataException("Invalid protobuf data", (Throwable)e);
        }
    }

    private String getProtoMapKey(String descriptorContainingTypeName, String connectFieldName) {
        return descriptorContainingTypeName.concat(connectFieldName);
    }

    private String getConnectFieldName(Descriptors.FieldDescriptor descriptor) {
        String name = descriptor.getName();
        for (Map.Entry option : descriptor.getOptions().getAllFields().entrySet()) {
            if (!((Descriptors.FieldDescriptor)option.getKey()).getFullName().equalsIgnoreCase(this.legacyName)) continue;
            name = option.getValue().toString();
        }
        this.connectProtoNameMap.put(this.getProtoMapKey(descriptor.getContainingType().getFullName(), name), descriptor.getName());
        return name;
    }

    private String getProtoFieldName(String descriptorForTypeName, String connectFieldName) {
        return this.connectProtoNameMap.get(this.getProtoMapKey(descriptorForTypeName, connectFieldName));
    }

    ProtobufData(Class<? extends GeneratedMessageV3> clazz, String legacyName) {
        this(clazz, legacyName, false);
    }

    ProtobufData(Class<? extends GeneratedMessageV3> clazz, String legacyName, boolean useConnectSchemaMap) {
        this.legacyName = legacyName;
        this.useConnectSchemaMap = useConnectSchemaMap;
        try {
            this.newBuilder = clazz.getDeclaredMethod("newBuilder", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConnectException("Proto class " + clazz.getCanonicalName() + " is not a valid proto3 message class", (Throwable)e);
        }
        this.schema = this.toConnectSchema(this.getBuilder().getDefaultInstanceForType());
    }

    SchemaAndValue toConnectData(byte[] value) {
        Message message = this.getMessage(value);
        if (message == null) {
            return SchemaAndValue.NULL;
        }
        return new SchemaAndValue(this.schema, this.toConnectData(this.schema, message));
    }

    private Schema toConnectSchema(Message message) {
        SchemaBuilder builder = SchemaBuilder.struct().name(message.getDescriptorForType().getName());
        List fieldDescriptorList = message.getDescriptorForType().getFields();
        for (Descriptors.FieldDescriptor descriptor : fieldDescriptorList) {
            builder.field(this.getConnectFieldName(descriptor), this.toConnectSchema(descriptor));
        }
        return builder.build();
    }

    private boolean isTimestampDescriptor(Descriptors.FieldDescriptor descriptor) {
        return descriptor.getMessageType().getFullName().equals("google.protobuf.Timestamp");
    }

    private boolean isDateDescriptor(Descriptors.FieldDescriptor descriptor) {
        return descriptor.getMessageType().getFullName().equals("google.type.Date");
    }

    private Schema toConnectSchema(Descriptors.FieldDescriptor descriptor) {
        SchemaBuilder builder;
        switch (descriptor.getType()) {
            case INT32: 
            case SINT32: {
                builder = SchemaBuilder.int32();
                break;
            }
            case INT64: 
            case SINT64: 
            case UINT32: {
                builder = SchemaBuilder.int64();
                break;
            }
            case UINT64: {
                builder = Decimal.builder((int)0).parameter(CONNECT_DECIMAL_PRECISION_PROP, "20");
                break;
            }
            case FLOAT: {
                builder = SchemaBuilder.float32();
                break;
            }
            case DOUBLE: {
                builder = SchemaBuilder.float64();
                break;
            }
            case BOOL: {
                builder = SchemaBuilder.bool();
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case BYTES: {
                builder = SchemaBuilder.bytes();
                break;
            }
            case ENUM: {
                builder = SchemaBuilder.string();
                break;
            }
            case MESSAGE: {
                if (this.isTimestampDescriptor(descriptor)) {
                    builder = org.apache.kafka.connect.data.Timestamp.builder();
                    break;
                }
                if (this.isDateDescriptor(descriptor)) {
                    builder = org.apache.kafka.connect.data.Date.builder();
                    break;
                }
                if (this.shouldConvertToConnectSchemaMap(descriptor)) {
                    Descriptors.FieldDescriptor keyFieldDescriptor = descriptor.getMessageType().findFieldByName("key");
                    Descriptors.FieldDescriptor valueFieldDescriptor = descriptor.getMessageType().findFieldByName("value");
                    builder = SchemaBuilder.map((Schema)this.toConnectSchema(keyFieldDescriptor), (Schema)this.toConnectSchema(valueFieldDescriptor));
                    break;
                }
                String jsonName = descriptor.getJsonName();
                builder = SchemaBuilder.struct().name(jsonName.substring(0, 1).toUpperCase() + jsonName.substring(1));
                for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getMessageType().getFields()) {
                    builder.field(this.getConnectFieldName(fieldDescriptor), this.toConnectSchema(fieldDescriptor));
                }
                break;
            }
            default: {
                throw new DataException("Unknown Connect schema type: " + descriptor.getType());
            }
        }
        builder.optional();
        Schema schema = builder.build();
        if (descriptor.isRepeated() && !this.shouldConvertToConnectSchemaMap(descriptor)) {
            SchemaBuilder arrayBuilder = SchemaBuilder.array((Schema)schema);
            arrayBuilder.optional();
            schema = arrayBuilder.build();
        }
        return schema;
    }

    private boolean shouldConvertToConnectSchemaMap(Descriptors.FieldDescriptor descriptor) {
        return this.useConnectSchemaMap && descriptor.isMapField();
    }

    private boolean isProtobufTimestamp(Schema schema) {
        return org.apache.kafka.connect.data.Timestamp.SCHEMA.name().equals(schema.name());
    }

    private boolean isProtobufDate(Schema schema) {
        return org.apache.kafka.connect.data.Date.SCHEMA.name().equals(schema.name());
    }

    private void setStructField(Schema schema, Message message, Struct result, Descriptors.FieldDescriptor fieldDescriptor) {
        String fieldName = this.getConnectFieldName(fieldDescriptor);
        Field field = schema.field(fieldName);
        Object obj = null;
        if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || fieldDescriptor.isRepeated() || fieldDescriptor.isMapField() || message.hasField(fieldDescriptor)) {
            obj = this.toConnectData(field.schema(), message.getField(fieldDescriptor));
        }
        result.put(fieldName, obj);
    }

    Object toConnectData(Schema schema, Object value) {
        try {
            if (this.isProtobufTimestamp(schema)) {
                Timestamp timestamp = (Timestamp)value;
                return org.apache.kafka.connect.data.Timestamp.toLogical((Schema)schema, (long)Timestamps.toMillis((Timestamp)timestamp));
            }
            if (this.isProtobufDate(schema)) {
                Date date = (Date)value;
                return ProtobufUtils.convertFromGoogleDate(date);
            }
            Object converted = null;
            switch (schema.type()) {
                case INT32: {
                    Integer intValue = (Integer)((Object)value);
                    converted = value;
                    break;
                }
                case INT64: {
                    try {
                        Long longValue = (Long)((Object)value);
                        converted = value;
                    }
                    catch (ClassCastException e) {
                        Integer intValue = (Integer)((Object)value);
                        converted = Integer.toUnsignedLong(intValue);
                    }
                    break;
                }
                case FLOAT32: {
                    Float floatValue = (Float)((Object)value);
                    converted = value;
                    break;
                }
                case FLOAT64: {
                    Double doubleValue = (Double)((Object)value);
                    converted = value;
                    break;
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)((Object)value);
                    converted = value;
                    break;
                }
                case STRING: {
                    if (value instanceof String) {
                        converted = value;
                        break;
                    }
                    if (value instanceof CharSequence || value instanceof Enum || value instanceof Descriptors.EnumValueDescriptor) {
                        converted = value.toString();
                        break;
                    }
                    throw new DataException("Invalid class for string type, expecting String or CharSequence but found " + value.getClass());
                }
                case BYTES: {
                    if (value instanceof byte[]) {
                        converted = ByteBuffer.wrap((byte[])value);
                        break;
                    }
                    if (value instanceof ByteString) {
                        byte[] valueBytes = ((ByteString)value).toByteArray();
                        converted = ByteBuffer.wrap(valueBytes);
                        break;
                    }
                    if (value instanceof ByteBuffer) {
                        converted = value;
                        break;
                    }
                    if (value instanceof Long) {
                        BigInteger unsigned = ProtobufData.toUnsigned(BigInteger.valueOf((Long)((Object)value)), 8);
                        converted = new BigDecimal(unsigned, 0);
                        break;
                    }
                    throw new DataException("Invalid class for bytes type, expecting byte[], ByteString, or ByteBuffer but found " + value.getClass());
                }
                case ARRAY: {
                    Schema valueSchema = schema.valueSchema();
                    Collection original = (Collection)((Object)value);
                    ArrayList<Object> result = new ArrayList<Object>(original.size());
                    for (Object elem : original) {
                        result.add(this.toConnectData(valueSchema, elem));
                    }
                    converted = result;
                    break;
                }
                case MAP: {
                    Collection original = (Collection)((Object)value);
                    converted = original.stream().collect(Collectors.toMap(entry -> this.toConnectData(schema.keySchema(), entry.getKey()), entry -> this.toConnectData(schema.valueSchema(), entry.getValue())));
                    break;
                }
                case STRUCT: {
                    Message message = (Message)value;
                    Struct result = new Struct(schema.schema());
                    Descriptors.Descriptor descriptor = message.getDescriptorForType();
                    for (Descriptors.OneofDescriptor oneOfDescriptor : descriptor.getOneofs()) {
                        Descriptors.FieldDescriptor fieldDescriptor = message.getOneofFieldDescriptor(oneOfDescriptor);
                        if (fieldDescriptor == null) continue;
                        this.setStructField(schema, message, result, fieldDescriptor);
                    }
                    for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                        Descriptors.OneofDescriptor oneOfDescriptor = fieldDescriptor.getContainingOneof();
                        if (oneOfDescriptor != null) continue;
                        this.setStructField(schema, message, result, fieldDescriptor);
                    }
                    converted = result;
                    break;
                }
                default: {
                    throw new DataException("Unknown Connect schema type: " + schema.type());
                }
            }
            return converted;
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    private static BigInteger toUnsigned(BigInteger num, int sizeInBytes) {
        return num.andNot(BigInteger.valueOf(-1L).shiftLeft(sizeInBytes * 8));
    }

    byte[] fromConnectData(Object value) {
        GeneratedMessageV3.Builder builder = this.getBuilder();
        Struct struct = (Struct)value;
        for (Field field : this.schema.fields()) {
            this.fromConnectData(builder, field, struct.get(field));
        }
        return builder.build().toByteArray();
    }

    private void fromConnectData(GeneratedMessageV3.Builder builder, Field field, Object value) {
        String protobufFieldName = this.getProtoFieldName(builder.getDescriptorForType().getFullName(), field.name());
        Descriptors.FieldDescriptor fieldDescriptor = builder.getDescriptorForType().findFieldByName(protobufFieldName);
        if (fieldDescriptor == null) {
            return;
        }
        Schema schema = field.schema();
        Schema.Type schemaType = schema.type();
        try {
            switch (schemaType) {
                case INT32: {
                    if (this.isProtobufDate(schema)) {
                        java.util.Date date = (java.util.Date)value;
                        builder.setField(fieldDescriptor, (Object)ProtobufUtils.convertToGoogleDate(date));
                        return;
                    }
                    Integer intValue = (Integer)value;
                    builder.setField(fieldDescriptor, (Object)intValue);
                    return;
                }
                case INT64: {
                    if (this.isProtobufTimestamp(schema)) {
                        java.util.Date timestamp = (java.util.Date)value;
                        builder.setField(fieldDescriptor, (Object)Timestamps.fromMillis((long)org.apache.kafka.connect.data.Timestamp.fromLogical((Schema)schema, (java.util.Date)timestamp)));
                        return;
                    }
                    Long longValue = (Long)value;
                    builder.setField(fieldDescriptor, (Object)longValue);
                    return;
                }
                case FLOAT32: {
                    Float floatValue = (Float)value;
                    builder.setField(fieldDescriptor, (Object)floatValue);
                    return;
                }
                case FLOAT64: {
                    Double doubleValue = (Double)value;
                    builder.setField(fieldDescriptor, (Object)doubleValue);
                    return;
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)value;
                    builder.setField(fieldDescriptor, (Object)boolValue);
                    return;
                }
                case STRING: {
                    String stringValue = (String)value;
                    builder.setField(fieldDescriptor, (Object)stringValue);
                    return;
                }
                case BYTES: {
                    ByteBuffer bytesValue = value instanceof byte[] ? ByteBuffer.wrap((byte[])value) : (ByteBuffer)value;
                    builder.setField(fieldDescriptor, (Object)ByteString.copyFrom((ByteBuffer)bytesValue));
                    return;
                }
            }
            throw new DataException("Unknown schema type: " + schema.type());
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }
}

