/*
 * Decompiled with CFR 0.152.
 */
package com.bluecatcode.junit.rules;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.ExternalResource;

public abstract class SynchronisedExternalResource<T>
extends ExternalResource {
    private static final Logger log = Logger.getLogger(SynchronisedExternalResource.class.getName());
    private static final int LOCK_TRY_TIMEOUT = 10;
    private static final ReentrantLock lock = new ReentrantLock(true);
    private final T resource;

    protected SynchronisedExternalResource(T resource) {
        this.resource = resource;
    }

    protected abstract void doBefore() throws Exception;

    protected abstract void doAfter() throws Exception;

    public T getResource() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, String.format("thread %s calls getResource(), %s", Thread.currentThread().getId(), lock));
        }
        if (!lock.isHeldByCurrentThread()) {
            log.log(Level.WARNING, String.format("Invoked by thread not holding the lock, %s", lock));
        }
        return this.resource;
    }

    protected final synchronized void before() throws Throwable {
        block7: {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, String.format("thread %s enters before(), %s", Thread.currentThread().getId(), lock));
            }
            try {
                if (lock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        this.doBefore();
                        break block7;
                    }
                    catch (Exception e) {
                        SynchronisedExternalResource.unlockIfHeldByCurrentThread();
                        throw new RuntimeException(e);
                    }
                }
                String message = String.format("Couldn't get a lock on the database for %s seconds, %s", 10, lock);
                log.log(Level.SEVERE, message);
                throw new IllegalStateException(message);
            }
            catch (InterruptedException e) {
                SynchronisedExternalResource.unlockIfHeldByCurrentThread();
                throw new IllegalStateException(String.format("Current thread was interrupted while acquiring the lock, %s", lock));
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, String.format("thread %s exits before(), %s", Thread.currentThread().getId(), lock));
        }
    }

    protected final synchronized void after() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, String.format("thread %s enters after(), %s", Thread.currentThread().getId(), lock));
        }
        try {
            this.doAfter();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            SynchronisedExternalResource.unlockIfHeldByCurrentThread();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, String.format("thread %s exits after(), %s", Thread.currentThread().getId(), lock));
        }
    }

    private static void unlockIfHeldByCurrentThread() {
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
        } else {
            log.log(Level.SEVERE, String.format("Cannot unlock as it's not held by the current thread, %s", lock));
        }
    }
}

