/*
 * Decompiled with CFR 0.152.
 */
package com.bluecatcode.junit.rules;

import com.bluecatcode.junit.rules.Repeat;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    public Statement apply(Statement statement, Description description) {
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        Statement statement1 = RepeatStatement.createFromAnnotationWith(repeat, statement);
        return statement1 == null ? statement : statement1;
    }

    static class RepeatStatement
    extends Statement {
        private final int times;
        private final Statement statement;

        private RepeatStatement(int times, Statement statement) {
            this.times = times;
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            for (int i = 0; i < this.times; ++i) {
                this.statement.evaluate();
            }
        }

        @Nullable
        public static Statement createFromAnnotationWith(@Nullable Repeat repeat, Statement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Expected non-null statement");
            }
            if (repeat == null) {
                return null;
            }
            int times = repeat.times();
            return new RepeatStatement(times, statement);
        }
    }
}

