/*
 * Decompiled with CFR 0.152.
 */
package com.bluecats.sdk;

import a.a.a.b2;
import a.a.a.d0;
import a.a.a.i0;
import a.a.a.k1;
import a.a.a.s1;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import com.bluecats.sdk.BCBeaconCommandCallback;
import com.bluecats.sdk.BCBeaconInternal;
import com.bluecats.sdk.BCBeaconUpdates;
import com.bluecats.sdk.BCError;
import com.bluecats.sdk.BCLog;
import com.bluecats.sdk.BCOperation;
import com.bluecats.sdk.BCPeripheralCommand;
import com.bluecats.sdk.SecurityUtils;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

@TargetApi(value=18)
public class BCBeaconCommand {
    public static final String TAG = "BCBeaconCommand";
    public static final long BC_DEFAULT_MAX_ALLOWED_COMMAND_STATE_TIME_INTERVAL_IN_MILLISECONDS = 30000L;
    public static final long BC_MAX_READY_TIME_INTERVAL_IN_MILLISECONDS = 30000L;
    public static final long BC_MAX_ALLOWED_CONNECTING_TIME_INTERVAL_IN_MILLISECONDS = 30000L;
    public static final long BC_MAX_ALLOWED_FIRMWARE_UPDATE_CONNECTED_TIME_INTERVAL_IN_MILLISECONDS = 360000L;
    public static final UUID CH_UUID_INDICATOR = UUID.fromString("EB459771-C9D6-4841-8748-DF477740AC0B");
    public static final UUID CH_UUID_WATER = UUID.fromString("9993F233-AC1E-4139-84C2-62DB29EA081C");
    public static final UUID CH_UUID_MILK = UUID.fromString("233E302C-8BD5-42C7-9868-2F8D67555051");
    public static final UUID CH_UUID_CONTROL = UUID.fromString("67A29537-CA4A-4536-ABEC-8B5C0A5B425B");
    public static final UUID CH_UUID_GRAVY = UUID.fromString("fc2bfb4c-bc72-4382-8dfc-91fe7d05c335");
    public static final UUID DESCRIPTOR_UUID_INDICATOR = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    public static final int BULK_WRITE_FW_BLOCK_SIZE = 98;
    public static final int BULK_WRITE_DATA_BLOCK_SIZE = 18;
    public static final int SETTINGS_STR_WRITE_DATA_BLOCK_SIZE = 18;
    public static final int MAC_WRITE_DATA_BLOCK_SIZE = 17;
    public static final int INIT_VECTORE_WRItE_DATA_BLOCK_SIZE = 17;
    public static final int CHUNK_SIZE = 16;
    public boolean mImmediateCommand;
    public int retryCount;
    public byte[] mPasscodeData;
    public BCBeaconIndicatorResponse mLoginResult;
    public BCBeaconInternal mBeacon;
    public String mPeripheralIdentifier;
    public BCBeaconCommandState mState;
    public Date mStateChangedAt;
    public BluetoothDevice mPeripheral;
    public BCPeripheralCommand mCurrentCommand;
    public int mfirmwareBlockSize;
    public Object mHasIndicatorLock;
    public boolean mHasIndicator;
    public Handler mUiHandler;
    public a.a.a.b mBeaconCommandManagerCallback;
    public BCBeaconCommandCallback mBeaconCommandCallback;
    public k a;
    public byte[] milkData;
    public k b;
    public k c;
    public k mCommandResultCallback;
    public k mLoginCommandSuccessCallback;
    public byte[] statusData;
    public k d;
    public k e;
    public int dataIndex;
    public int dataLength;
    public boolean waitingForNotify;
    public int writeDataBlockSize;
    public byte[] lastNotifiedData;
    public byte[] writeData;

    /*
     * WARNING - void declaration
     */
    public BCBeaconCommand(BCBeaconInternal beacon, String peripheralIdentifier) {
        void var2_2;
        void var1_1;
        BCBeaconCommand bCBeaconCommand = this;
        BCBeaconCommand bCBeaconCommand2 = this;
        bCBeaconCommand2.mImmediateCommand = false;
        bCBeaconCommand2.mfirmwareBlockSize = 96;
        bCBeaconCommand2.mHasIndicatorLock = new Object();
        bCBeaconCommand2.mHasIndicator = false;
        bCBeaconCommand2.a = new k(){

            @Override
            public void a(Object object) {
                BCBeaconCommand.this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FINISHED;
            }
        };
        bCBeaconCommand2.milkData = null;
        bCBeaconCommand2.b = new k(){

            @Override
            public void a(Object object) {
                Object[] objectArray;
                if ((object = (BluetoothGattCharacteristic)object).getUuid().compareTo(CH_UUID_WATER) == 0) {
                    byte[] byArray = object.getValue();
                    object = byArray;
                    Object[] objectArray2 = new Object[1];
                    Object[] objectArray3 = objectArray2;
                    objectArray2[0] = k1.a().toJson(object);
                    BCLog.Log.d(BCBeaconCommand.TAG, "water: %s", objectArray3);
                    if (byArray.length == 4) {
                        objectArray.BCBeaconCommand.this.writeMilkForLSFRWaterData((byte[])object, true);
                    } else if (((Object)object).length == 8) {
                        objectArray.BCBeaconCommand.this.writeMilkForPasscodeWaterData((byte[])object);
                    } else if (((Object)object).length > 4 && ((Object)object).length <= 18) {
                        Object object2 = object;
                        Object object3 = object2[0];
                        Object object4 = object2[1];
                        if (((Object)object2).length - 2 != object4) {
                            objectArray.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED);
                            objectArray.BCBeaconCommand.this.failedWithErrorDescription("Water length does not match length in header.");
                            return;
                        }
                        Object object5 = object;
                        object = new byte[object4];
                        System.arraycopy(object5, 2, object, 0, (int)object4);
                        Object[] objectArray4 = new Object[2];
                        Object[] objectArray5 = objectArray4;
                        objectArray4[0] = (byte)object3;
                        objectArray4[1] = k1.a().toJson(object);
                        BCLog.Log.d(BCBeaconCommand.TAG, "secType: %d, waterData: %s", objectArray5);
                        if (object3 == BCBeaconUpdates.BCBeaconSecurityType.NONE.getValue()) {
                            objectArray.BCBeaconCommand.this.mLoginCommandSuccessCallback.a(null);
                            BCBeaconCommand.a(objectArray.BCBeaconCommand.this, null);
                            return;
                        }
                        if (object3 == BCBeaconUpdates.BCBeaconSecurityType.PASSCODE.getValue()) {
                            objectArray.BCBeaconCommand.this.writeMilkForPasscodeWaterData((byte[])object);
                        } else if ((object3 == BCBeaconUpdates.BCBeaconSecurityType.TRIPLE_KEY.getValue() || object3 == BCBeaconUpdates.BCBeaconSecurityType.ONE_KEY.getValue()) && objectArray.BCBeaconCommand.this.statusData != null) {
                            objectArray.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_GET_MILK_FROM_API);
                            BCBeaconCommand bCBeaconCommand = objectArray.BCBeaconCommand.this;
                            bCBeaconCommand.writeMilkForWaterData((byte[])object, bCBeaconCommand.statusData);
                        } else {
                            if (object3 != BCBeaconUpdates.BCBeaconSecurityType.LEGACY_TWO_KEY.getValue() && object3 != BCBeaconUpdates.BCBeaconSecurityType.LEGACY.getValue()) {
                                objectArray = new Object[]{};
                                BCLog.Log.d(BCBeaconCommand.TAG, "Security type not recognized or not valid", objectArray);
                                objectArray.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED);
                                objectArray.BCBeaconCommand.this.failedWithErrorDescription("Security type not recognized or not valid");
                                return;
                            }
                            objectArray.BCBeaconCommand.this.writeMilkForLSFRWaterData((byte[])object);
                        }
                    } else {
                        Object[] objectArray6 = objectArray;
                        objectArray = new Object[]{};
                        BCLog.Log.d(BCBeaconCommand.TAG, "auth is probably disabled", objectArray);
                        objectArray6.BCBeaconCommand.this.writeMilkForLSFRWaterData(new byte[]{0, 0, 0, 0}, false);
                    }
                } else if (object.getUuid().compareTo(CH_UUID_INDICATOR) == 0) {
                    Object[] objectArray7 = new Object[1];
                    objectArray = objectArray7;
                    objectArray7[0] = k1.a().toJson((Object)object.getValue());
                    BCLog.Log.d(BCBeaconCommand.TAG, "indicator data druing writing milk: %s", objectArray);
                }
            }
        };
        new k(){

            @Override
            public void a(Object object) {
                if (object instanceof BluetoothGattDescriptor) {
                    BCBeaconCommand bCBeaconCommand = objectArray.BCBeaconCommand.this;
                    if (!bCBeaconCommand.writeCharacteristicData(bCBeaconCommand.milkData, CH_UUID_MILK)) {
                        objectArray.BCBeaconCommand.this.failedWithErrorDescription("Write milk failed.");
                        return;
                    }
                    objectArray.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_LOGIN_WRITE_MILK);
                    BCBeaconCommand bCBeaconCommand2 = objectArray.BCBeaconCommand.this;
                    bCBeaconCommand2.setBeaconCommandResultCallback(bCBeaconCommand2.c);
                    Object[] objectArray = new Object[]{};
                    BCLog.Log.d(BCBeaconCommand.TAG, "write milk", objectArray);
                }
            }
        };
        bCBeaconCommand2.c = new k(){

            @Override
            public void a(Object object) {
                if ((object = (BluetoothGattCharacteristic)object) != null && object.getValue() != null && object.getValue().length >= 2) {
                    Object[] objectArray = objectArray2;
                    byte[] byArray = object.getValue();
                    byte cfr_ignored_0 = byArray[0];
                    byte cfr_ignored_1 = byArray[1];
                    objectArray.BCBeaconCommand.this.mUiHandler.post(new Runnable(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            if (a3.BCBeaconCommand.this.mBeaconCommandManagerCallback == null) return;
                            BluetoothGatt bluetoothGatt = a3.BCBeaconCommand.this.mBeaconCommandManagerCallback.a();
                            a a3 = a3.BCBeaconCommand.this.mBeaconCommandManagerCallback.b();
                            if (bluetoothGatt == null || a3 == null) return;
                            try {
                                bluetoothGatt.setCharacteristicNotification(a3.getCharacteristic(CH_UUID_INDICATOR), true);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            return;
                        }
                    });
                    objectArray.BCBeaconCommand.this.mLoginCommandSuccessCallback.a(null);
                    BCBeaconCommand.a(objectArray2.BCBeaconCommand.this, null);
                    Object[] objectArray2 = new Object[]{};
                    BCLog.Log.d(BCBeaconCommand.TAG, "mLoginStatusNotifiedCallback read indicator", objectArray2);
                    return;
                }
                objectArray2.BCBeaconCommand.this.failedWithErrorDescription("Error in data from indicator output.");
            }
        };
        bCBeaconCommand2.mCommandResultCallback = bCBeaconCommand2.a;
        bCBeaconCommand2.mLoginCommandSuccessCallback = null;
        bCBeaconCommand2.statusData = null;
        bCBeaconCommand2.d = new k(){

            @Override
            public void a(Object objectArray) {
                if (objectArray instanceof BluetoothGattDescriptor) {
                    BluetoothGattDescriptor cfr_ignored_0 = (BluetoothGattDescriptor)objectArray;
                    if (objectArray2.BCBeaconCommand.this.readCharacteristicData(CH_UUID_INDICATOR)) {
                        objectArray2.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_LOGIN_READ_STATUS);
                        Object[] objectArray2 = new Object[]{};
                        BCLog.Log.d(BCBeaconCommand.TAG, "reading status", objectArray2);
                        return;
                    }
                } else if (objectArray instanceof BluetoothGattCharacteristic && (objectArray = (BluetoothGattCharacteristic)objectArray).getUuid().compareTo(CH_UUID_INDICATOR) == 0) {
                    BCBeaconCommand.b(objectArray2.BCBeaconCommand.this, objectArray.getValue());
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = k1.a().toJson((Object)objectArray2.BCBeaconCommand.this.statusData);
                    BCLog.Log.d(BCBeaconCommand.TAG, "read status: %s", objectArray);
                    BCBeaconCommand bCBeaconCommand = objectArray2.BCBeaconCommand.this;
                    bCBeaconCommand.loginLegacy(bCBeaconCommand.mLoginCommandSuccessCallback);
                    return;
                }
                objectArray2.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED);
                objectArray2.BCBeaconCommand.this.failedWithErrorDescription("callbackLoginReadStatusIndicator failed.");
            }
        };
        bCBeaconCommand2.e = new k(){
            public boolean a = false;
            public boolean b = false;

            @Override
            public void a(Object object) {
                Object[] objectArray5;
                if ((object = (BluetoothGattCharacteristic)object) != null && object.getUuid().compareTo(CH_UUID_MILK) == 0) {
                    objectArray5.a = true;
                    object = new Object[]{};
                    BCLog.Log.d(BCBeaconCommand.TAG, "milk write done. waiting for indicator", (Object[])object);
                } else if (object != null && object.getUuid().compareTo(CH_UUID_INDICATOR) == 0) {
                    objectArray5.b = true;
                    byte[] byArray = object.getValue();
                    object = byArray;
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = k1.a().toJson(object);
                    BCLog.Log.d(BCBeaconCommand.TAG, "milk response from indicator. %s", objectArray2);
                    if (byArray.length >= 2) {
                        reference var2_3 = (object[0] << 8) + object[1];
                        Object[] objectArray3 = new Object[2];
                        Object[] objectArray4 = objectArray3;
                        objectArray4[0] = object.toString();
                        objectArray3[1] = (int)var2_3;
                        BCLog.Log.d(BCBeaconCommand.TAG, "milk response: %s, result:%s", objectArray4);
                        objectArray5.BCBeaconCommand.this.mLoginResult = BCBeaconIndicatorResponse.getType((int)var2_3);
                        object = objectArray5.BCBeaconCommand.this;
                        BCBeaconIndicatorResponse bCBeaconIndicatorResponse = ((BCBeaconCommand)object).mLoginResult;
                        if (bCBeaconIndicatorResponse != BCBeaconIndicatorResponse.LOGIN_RESULT_SUCCESS && bCBeaconIndicatorResponse != BCBeaconIndicatorResponse.LOGIN_RESULT_DISABLED) {
                            if (bCBeaconIndicatorResponse == BCBeaconIndicatorResponse.LOGIN_RESULT_FAILED) {
                                ((BCBeaconCommand)object).failedWithErrorDescription("Login Failed.");
                                return;
                            }
                            ((BCBeaconCommand)object).failedWithErrorDescription("Unrecognized milk response.");
                            return;
                        }
                    } else {
                        objectArray5.BCBeaconCommand.this.failedWithErrorDescription("Unrecognized milk response 2.");
                        return;
                    }
                }
                if (objectArray5.b && objectArray5.a) {
                    Object[] objectArray = objectArray5;
                    objectArray5 = new Object[]{};
                    BCLog.Log.d(BCBeaconCommand.TAG, "milk done and indicator done.", objectArray5);
                    objectArray.BCBeaconCommand.this.mLoginCommandSuccessCallback.a(null);
                }
            }
        };
        this.mBeacon = var1_1;
        bCBeaconCommand.mPeripheralIdentifier = var2_2;
        bCBeaconCommand.mUiHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - void declaration
     */
    private void writeMilkForLSFRWaterData(byte[] water) {
        void var1_1;
        this.writeMilkForLSFRWaterData((byte[])var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private void writeMilkForLSFRWaterData(byte[] water, boolean isLegacy) {
        void var2_2;
        byte[] byArray = (byte[])SecurityUtils.nativeConverter(water, "".getBytes());
        this.milkData = byArray;
        if (byArray == null) {
            this.failedWithErrorDescription("Milk is null.");
            return;
        }
        this.writeMilkDataForResponse(byArray, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void writeMilkDataForResponse(byte[] milkToWrite, boolean isLegacy) {
        Object[] this_;
        void var2_2;
        BluetoothGattService bluetoothGattService;
        if (!this_.writeCharacteristicData((byte[])bluetoothGattService, CH_UUID_MILK)) {
            this_.failedWithErrorDescription("Milk mixed passcode fail.");
            return;
        }
        this_.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_LOGIN_WRITE_MILK);
        bluetoothGattService = this_.mBeaconCommandManagerCallback.b();
        if (var2_2 == false && bluetoothGattService != null && bluetoothGattService.getCharacteristic(CH_UUID_INDICATOR) != null) {
            this_.setBeaconCommandResultCallback(this_.e);
            this_ = new Object[]{};
            BCLog.Log.d(TAG, "waiting for milk response.", this_);
            return;
        }
        Object[] objectArray = this_;
        objectArray.setBeaconCommandResultCallback(objectArray.mLoginCommandSuccessCallback);
        this_.mLoginCommandSuccessCallback = null;
        this_ = new Object[]{};
        BCLog.Log.d(TAG, "write milk.", this_);
    }

    /*
     * WARNING - void declaration
     */
    private void writeMilkDataForResponse(byte[] milkToWrite) {
        void var1_1;
        this.writeMilkDataForResponse((byte[])var1_1, false);
    }

    private void writeMilkForPasscodeWaterData(byte[] water) {
        byte[] byArray;
        void v02 = byArray;
        byArray = new byte[16];
        Object[] objectArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[8];
        int n2 = Math.min(8, ((void)v02).length);
        System.arraycopy(v02, 0, byArray, 0, n2);
        byte[] byArray4 = this_.mPasscodeData;
        if (this_.mPasscodeData != null) {
            int n3 = Math.min(16, byArray4.length);
            System.arraycopy(byArray4, 0, byArray2, 0, n3);
        }
        Object[] objectArray2 = new Object[3];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = k1.a().toJson((Object)byArray);
        objectArray2[1] = k1.a().toJson((Object)byArray2);
        objectArray2[2] = k1.a().toJson((Object)objectArray);
        BCLog.Log.d(TAG, "waterbytes: %s, passcodebytes:%s,iv:%s", objectArray3);
        byArray = SecurityUtils.nativeTransform(byArray, byArray2, objectArray);
        Object[] objectArray4 = new Object[2];
        objectArray = objectArray4;
        objectArray4[0] = k1.a().toJson((Object)byArray);
        objectArray4[1] = k1.a().toJson((Object)byArray2);
        BCLog.Log.d(TAG, "milk with passcode: %s, passcode: %s", objectArray);
        if (byArray != null && byArray.length >= 8) {
            Object[] objectArray5 = this_;
            System.arraycopy(byArray, 0, byArray3, 0, 8);
            Object[] objectArray6 = new Object[1];
            Object[] this_ = objectArray6;
            objectArray6[0] = k1.a().toJson((Object)byArray3);
            BCLog.Log.d(TAG, "dataToWrite with milk:%s", this_);
            super.writeMilkDataForResponse(byArray3);
            return;
        }
        this_.failedWithErrorDescription("writeMilkForPasscodeWaterData failed.");
    }

    private void writeMilkForWaterData(byte[] water, byte[] status) {
        HashMap<String, String> hashMap;
        d0 d02;
        d0 d03;
        Object[] objectArray;
        Object[] objectArray2;
        String string;
        Object[] objectArray3 = new Object[1];
        Object object = objectArray3;
        objectArray3[0] = this.mBeacon.getBeaconID();
        object = String.format(Locale.US, "beacons/%s/milk", object);
        String string2 = string;
        string = new String(Base64.encode((byte[])objectArray2, (int)2));
        objectArray2 = objectArray;
        objectArray = new String(Base64.encode((byte[])d03, (int)2));
        d03 = d02;
        d03();
        d02.a((String)object);
        d02.a(BCOperation.BCOperationType.BC_OPERATION_TYPE_GET_MILK);
        object = hashMap;
        new HashMap<String, String>().put("water", string2);
        object.put("status", objectArray2);
        d02.a((Map<String, String>)object);
        Object[] objectArray4 = new Object[2];
        objectArray2 = objectArray4;
        objectArray2[0] = k1.a().toJson(object);
        objectArray4[1] = d03.d();
        BCLog.Log.d(TAG, "get milk api:%s, path: %s", objectArray2);
        d02.a(new s1(){

            @Override
            public void a(BCOperation object, Bundle objectArray) {
                byte[] byArray = objectArray.getByteArray("BlueCatsSDK_EXTRA_BEACON_MILK_BYTES_ARRAY");
                object = byArray;
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = k1.a().toJson(object);
                objectArray2[1] = object2.BCBeaconCommand.this.getState();
                BCLog.Log.d(BCBeaconCommand.TAG, "milk from api:%s, state: %s", objectArray);
                if (byArray != null && object2.BCBeaconCommand.this.getState() == BCBeaconCommandState.BC_BEACON_COMMAND_STATE_GET_MILK_FROM_API) {
                    a a3 = object2;
                    Object object2 = Base64.decode((byte[])object, (int)2);
                    a3.BCBeaconCommand.this.writeMilkDataForResponse((byte[])object2);
                    return;
                }
                a a4 = object2;
                a4.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED);
                a4.BCBeaconCommand.this.failedWithErrorDescription("Failed to get milk from API.");
            }

            @Override
            public void a(BCOperation bCOperation, BCError bCError) {
                a a3 = this;
                a3.BCBeaconCommand.this.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED);
                a3.BCBeaconCommand.this.failedWithErrorDescription("Failed to get milk from API (request failed).");
            }

            @Override
            public void b(BCOperation bCOperation, Bundle bundle) {
            }
        });
    }

    public static byte char2Hex(char c3) {
        char c4;
        if ('0' <= c4 && c4 <= '9') {
            return (byte)(c4 - 48);
        }
        if ('A' <= c4 && c4 <= 'F') {
            return (byte)(c4 - 65 + 10);
        }
        return 0;
    }

    public static /* synthetic */ k a(BCBeaconCommand bCBeaconCommand, k k2) {
        bCBeaconCommand.mLoginCommandSuccessCallback = k2;
        return k2;
    }

    public static /* synthetic */ byte[] b(BCBeaconCommand bCBeaconCommand, byte[] byArray) {
        bCBeaconCommand.statusData = byArray;
        return byArray;
    }

    public void updatePeripheralIdentifier(BCBeaconInternal beacon) {
        BCBeaconInternal bCBeaconInternal;
        if (beacon != null && (bCBeaconInternal = this.mBeacon) != null) {
            Object[] objectArray;
            bCBeaconInternal.setPeripheralIdentifier(objectArray.getPeripheralIdentifier());
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.mBeacon.getPeripheralIdentifier();
            BCLog.Log.d(TAG, "beacon peripheral changed: %s", objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setImmediateCommand(boolean value) {
        void var1_1;
        this.mImmediateCommand = var1_1;
    }

    public boolean isImmediateCommand() {
        return this.mImmediateCommand;
    }

    public byte[] getPasscodeData() {
        return this.mPasscodeData;
    }

    /*
     * WARNING - void declaration
     */
    public void setPasscodeData(byte[] data) {
        void var1_1;
        this.mPasscodeData = var1_1;
    }

    public String getPeripheralIdentifier() {
        return this.mPeripheralIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    public void setPeripheralIdentifier(String value) {
        void var1_1;
        this.mPeripheralIdentifier = var1_1;
    }

    public BCBeaconCommandState getState() {
        return this.mState;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(BCBeaconCommandState value) {
        Object object;
        void var1_1;
        Object object2 = ((BCBeaconCommand)object).mState;
        if (value != object2) {
            Date date;
            BCBeaconCommand bCBeaconCommand = object;
            bCBeaconCommand.mState = var1_1;
            object = date;
            date = new Date();
            bCBeaconCommand.mStateChangedAt = object;
        }
        object = TAG;
        String string = "Beacon command state changed from %s to %s";
        Object[] objectArray = new Object[2];
        int n2 = 0;
        object2 = object2 == null ? "null" : object2.getDisplayName();
        objectArray[n2] = object2;
        objectArray[1] = var1_1.getDisplayName();
        BCLog.Log.d((String)object, string, objectArray);
    }

    public Date getStateChangedAt() {
        return this.mStateChangedAt;
    }

    /*
     * WARNING - void declaration
     */
    public void setStateChangedAt(Date value) {
        void var1_1;
        this.mStateChangedAt = var1_1;
    }

    public BluetoothDevice getPeripheral() {
        return this.mPeripheral;
    }

    /*
     * WARNING - void declaration
     */
    public void setPeripheral(BluetoothDevice value) {
        void var1_1;
        this.mPeripheral = var1_1;
    }

    public BCBeaconCommandCallback getBeaconCommandCallback() {
        return this.mBeaconCommandCallback;
    }

    /*
     * WARNING - void declaration
     */
    public void setBeaconCommandCallback(BCBeaconCommandCallback value) {
        void var1_1;
        this.mBeaconCommandCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void registerBeaconCommandManagerCallback(a.a.a.b callback) {
        void var1_1;
        this.mBeaconCommandManagerCallback = var1_1;
    }

    public int hashCode() {
        int n2 = 31;
        BCBeaconInternal bCBeaconInternal = ((BCBeaconCommand)this).mBeacon;
        if (bCBeaconInternal != null) {
            n2 = bCBeaconInternal.hashCode() + n2;
        }
        if ((this = ((BCBeaconCommand)this).mPeripheralIdentifier) != null) {
            n2 += ((String)this).hashCode();
        }
        return n2;
    }

    public boolean equals(Object obj) {
        Object object;
        Object object2;
        if (!(obj instanceof BCBeaconCommand)) {
            return false;
        }
        object2 = (BCBeaconCommand)object2;
        BCBeaconInternal bCBeaconInternal = ((BCBeaconCommand)object).mBeacon;
        if (bCBeaconInternal != null) {
            object = ((BCBeaconCommand)object2).mBeacon;
            if (object != null) {
                return bCBeaconInternal.equals(object);
            }
            return false;
        }
        if (((BCBeaconCommand)object2).mBeacon != null) {
            return false;
        }
        object = ((BCBeaconCommand)object).mPeripheralIdentifier;
        if (object != null) {
            object2 = ((BCBeaconCommand)object2).mPeripheralIdentifier;
            if (object2 != null) {
                return ((String)object).equalsIgnoreCase((String)object2);
            }
            return false;
        }
        return ((BCBeaconCommand)object2).mPeripheralIdentifier == null;
    }

    public a.a.a.b getBeaconCommandManagerCallback() {
        return this.mBeaconCommandManagerCallback;
    }

    /*
     * WARNING - void declaration
     */
    public BCError getErrorWithDescription(String description) {
        void var1_1;
        HashMap<String, String> hashMap;
        String string = "com.bluecats." + string.getClass().getName();
        HashMap<String, String> hashMap2 = hashMap;
        hashMap2();
        hashMap.put(string, (String)var1_1);
        return new BCError(-1, (String)var1_1, hashMap2);
    }

    /*
     * WARNING - void declaration
     */
    public void setOverallProgress(int progress, String status) {
        if (this.getBeaconCommandCallback() != null) {
            void var2_2;
            void var1_1;
            this.getBeaconCommandCallback().onDidUpdateProgress(256, (int)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDataTXProgress(int progress, String status) {
        if (this.getBeaconCommandCallback() != null) {
            void var2_2;
            void var1_1;
            this.getBeaconCommandCallback().onDidUpdateProgress(258, (int)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFirmwareProgress(int progress, String status) {
        if (this.getBeaconCommandCallback() != null) {
            void var2_2;
            void var1_1;
            this.getBeaconCommandCallback().onDidUpdateProgress(257, (int)var1_1, (String)var2_2);
        }
    }

    public void updateFirmwareProgress() {
        if (this.getBeaconCommandCallback() != null) {
            this.getBeaconCommandCallback().onDidUpdateStatus();
        }
    }

    public void reloadCachedBeacon() {
        BCBeaconInternal bCBeaconInternal = i0.o().c().d(this.mBeacon);
        if (bCBeaconInternal != null) {
            this.mBeacon = bCBeaconInternal;
            this.mPeripheralIdentifier = bCBeaconInternal.getPeripheralIdentifier();
        }
    }

    public void prepareForConnection() {
        this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_PREPARING_FOR_CONNECTION;
    }

    public void connect() {
        a.a.a.b b3 = this.mBeaconCommandManagerCallback;
        if (b3 != null) {
            this.mPeripheral = b3.a(this.mBeacon.getPeripheralIdentifier());
            if (this.mPeripheral != null) {
                BCBeaconCommand bCBeaconCommand = this;
                bCBeaconCommand.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_CONNECTING);
                bCBeaconCommand.mBeaconCommandManagerCallback.b(this.mPeripheral);
            } else {
                this.failedWithErrorDescription("Peripheral is null.");
            }
        }
    }

    public void connected() {
        this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_CONNECTED;
    }

    public void disconnect() {
        this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_DISCONNECTING;
        a.a.a.b b3 = this.mBeaconCommandManagerCallback;
        if (b3 != null) {
            b3.a(this.mPeripheral);
        }
    }

    public void finish() {
        this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FINISHED;
        a.a.a.b b3 = this.mBeaconCommandManagerCallback;
        if (b3 != null) {
            b3.a(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void failedWithError(BCError error) {
        this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED;
        a.a.a.b b3 = this.mBeaconCommandManagerCallback;
        if (b3 != null) {
            void var1_1;
            b3.a(this, (BCError)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void failedWithErrorDescription(String description) {
        void var1_1;
        BCBeaconCommand bCBeaconCommand = this;
        bCBeaconCommand.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED);
        bCBeaconCommand.failedWithError(new BCError(-1, (String)var1_1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean timeoutForOperationState() {
        boolean bl = false;
        if (this.getState() == BCBeaconCommandState.BC_BEACON_COMMAND_STATE_READY) {
            BCError bCError;
            if (System.currentTimeMillis() - this.getStateChangedAt().getTime() <= 30000L) return bl;
            Object[] objectArray = new Object[]{};
            BCLog.Log.d(TAG, "BeaconCommandM did canceling command with Ready timeout", objectArray);
            if (this.getBeaconCommandCallback() == null) return true;
            BCError bCError2 = bCError;
            bCError = new BCError(-4, "command ready timeout(30s), check bluetooth.");
            this.getBeaconCommandCallback().onDidComplete(bCError2);
            return true;
        }
        if (this.getState() == BCBeaconCommandState.BC_BEACON_COMMAND_STATE_PREPARING_FOR_CONNECTION) {
            if (System.currentTimeMillis() - this.getStateChangedAt().getTime() <= 30000L) return bl;
            return true;
        }
        if (this.getState() == BCBeaconCommandState.BC_BEACON_COMMAND_STATE_CONNECTING) {
            BCError bCError;
            if (System.currentTimeMillis() - this.getStateChangedAt().getTime() <= 30000L) return bl;
            Object[] objectArray = new Object[]{};
            BCLog.Log.d(TAG, "BeaconCommandM did canceling command with connecting timeout", objectArray);
            if (this.getBeaconCommandCallback() == null) return true;
            BCError bCError3 = bCError;
            bCError = new BCError(-1, "connecting timeout(30s)");
            this.getBeaconCommandCallback().onDidComplete(bCError3);
            return true;
        }
        if (System.currentTimeMillis() - this.getStateChangedAt().getTime() <= 30000L) return bl;
        Object[] objectArray = new Object[]{};
        BCLog.Log.d(TAG, "BeaconCommandM did cancelling command with command state timeout", objectArray);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean enableIndicator(boolean enable) {
        a.a.a.b b3 = this.mBeaconCommandManagerCallback;
        if (b3 != null) {
            void var1_1;
            if ((b3 = b3.a()) == null) {
                this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED;
                return false;
            }
            BluetoothGattService bluetoothGattService = this.mBeaconCommandManagerCallback.b();
            if (bluetoothGattService == null) {
                this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED;
                return false;
            }
            if ((bluetoothGattService = bluetoothGattService.getCharacteristic(CH_UUID_INDICATOR)) == null) {
                this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED;
                return false;
            }
            this.mUiHandler.post(new Runnable(this, (BluetoothGatt)b3, (BluetoothGattCharacteristic)bluetoothGattService, (boolean)var1_1){
                public final /* synthetic */ BluetoothGatt a;
                public final /* synthetic */ BluetoothGattCharacteristic b;
                public final /* synthetic */ boolean c;
                {
                    this.a = bluetoothGatt;
                    this.b = bluetoothGattCharacteristic;
                    this.c = bl;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    b b3 = this;
                    b b4 = b3;
                    b b5 = b3;
                    b b6 = this;
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = b6.b;
                    b3.a.setCharacteristicNotification(bluetoothGattCharacteristic, b6.c);
                    bluetoothGattCharacteristic = b5.b.getDescriptor(DESCRIPTOR_UUID_INDICATOR);
                    byte[] byArray = b4.c ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
                    b b7 = this;
                    bluetoothGattCharacteristic.setValue(byArray);
                    Object[] objectArray = new Object[1];
                    try {
                        objectArray[0] = this.c;
                        BCLog.Log.d(BCBeaconCommand.TAG, "enable indicator %s", objectArray);
                        b7.a.writeDescriptor((BluetoothGattDescriptor)bluetoothGattCharacteristic);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return;
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeCharacteristicData(byte[] characteristicData, UUID characteristicUUID) {
        void var2_2;
        void var1_1;
        return this.writeCharacteristicDataBase((byte[])var1_1, (UUID)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeCharacteristicDataNoResponse(byte[] characteristicData, UUID characteristicUUID) {
        void var2_2;
        void var1_1;
        return this.writeCharacteristicDataBase((byte[])var1_1, (UUID)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeCharacteristicDataBase(byte[] characteristicData, UUID characteristicUUID, boolean noRsp) {
        a.a.a.b b3 = this.mBeaconCommandManagerCallback;
        if (b3 != null) {
            void var3_3;
            void var1_1;
            void var2_2;
            if ((b3 = b3.a()) == null) {
                this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED;
                return false;
            }
            final BluetoothGattService bluetoothGattService = this.mBeaconCommandManagerCallback.b();
            if (bluetoothGattService == null) {
                this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED;
                return false;
            }
            this.mUiHandler.post(new Runnable(this, (UUID)var2_2, (byte[])var1_1, (boolean)var3_3, (BluetoothGatt)b3){
                public final /* synthetic */ UUID b;
                public final /* synthetic */ byte[] c;
                public final /* synthetic */ boolean d;
                public final /* synthetic */ BluetoothGatt e;
                {
                    this.b = uUID;
                    this.c = byArray;
                    this.d = bl;
                    this.e = bluetoothGatt;
                }

                @Override
                public void run() {
                    c c3 = this;
                    c c4 = c3;
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = c3.bluetoothGattService.getCharacteristic(this.b);
                    bluetoothGattCharacteristic.setValue(this.c);
                    int n2 = c4.d ? 1 : 2;
                    try {
                        bluetoothGattCharacteristic.setWriteType(n2);
                        this.e.writeCharacteristic(bluetoothGattCharacteristic);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            return true;
        }
        return false;
    }

    public boolean readCharacteristicData(UUID characteristicUUID) {
        a.a.a.b b3 = this.mBeaconCommandManagerCallback;
        if (b3 != null && (b3 = b3.a()) != null) {
            BluetoothGattCharacteristic bluetoothGattCharacteristic;
            BluetoothGattService bluetoothGattService = this.mBeaconCommandManagerCallback.b();
            if (bluetoothGattService == null) {
                this.mState = BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED;
                return false;
            }
            bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic((UUID)bluetoothGattCharacteristic);
            this.mUiHandler.post(new Runnable(this, (BluetoothGatt)b3, bluetoothGattCharacteristic){
                public final /* synthetic */ BluetoothGatt a;
                public final /* synthetic */ BluetoothGattCharacteristic b;
                {
                    this.a = bluetoothGatt;
                    this.b = bluetoothGattCharacteristic;
                }

                @Override
                public void run() {
                    try {
                        this.a.readCharacteristic(this.b);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void writeVersionLine1(byte loudnessLevel, int targetSpeedMs, byte measuredPowerAt1Meter, byte beaconMode, int major, int minor, int privacyDruation) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Object[] objectArray = this_;
        Object[] objectArray2 = new Object[6];
        Object[] this_ = objectArray2;
        this_[0] = (byte)var1_1;
        this_[1] = (int)var2_2;
        this_[2] = (byte)var3_3;
        this_[3] = (byte)var4_4;
        this_[4] = (int)var5_5;
        objectArray2[5] = (int)var6_6;
        BCLog.Log.d(TAG, "loudness: %d,targetSpeedMs:%d,measuredPowerAt1Meter:%d,beaconMode:%d,major:%d,minor:%d", this_);
        objectArray.writeOpcode(BCBeaconOpcode.BC_BEACON_OPCODE_WRITE_VERSION_LINE_1, (byte[])SecurityUtils.nativeCompositor((byte)var1_1, (int)var2_2, (byte)var3_3, (byte)var4_4, (int)var5_5, (int)var6_6, (int)var7_7, 10000));
    }

    /*
     * WARNING - void declaration
     */
    public void writeOpcode(BCBeaconOpcode opcode, byte[] values) {
        byte[] byArray;
        void var1_1;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var1_1;
        BCLog.Log.d(TAG, "writeOpcode %s", objectArray2);
        int n2 = var1_1.getValue();
        if (values != null) {
            void v12 = byArray;
            byte[] byArray2 = new byte[((void)v12).length + 1];
            byArray = byArray2;
            byArray2[0] = n2;
            n2 = ((void)v12).length;
            System.arraycopy(v12, 0, byArray, 1, n2);
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = n2;
        }
        if (!this.writeCharacteristicData(byArray, CH_UUID_CONTROL)) {
            this.failedWithErrorDescription("Write control data fail");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeVersionLine2(String proximityUUIDString) {
        void var1_1;
        BCBeaconCommand bCBeaconCommand = this;
        bCBeaconCommand.writeOpcode(BCBeaconOpcode.BC_BEACON_OPCODE_WRITE_VERSION_LINE_2, bCBeaconCommand.getDataFromHexString((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void writeVersionLine3(byte version) {
        void var1_1;
        BCBeaconCommand bCBeaconCommand = this_;
        byte[] byArray = new byte[1];
        Object this_ = byArray;
        byArray[0] = var1_1;
        bCBeaconCommand.writeOpcode(BCBeaconOpcode.BC_BEACON_OPCODE_WRITE_VERSION_LINE_3, (byte[])this_);
    }

    /*
     * WARNING - void declaration
     */
    public void setBeaconCommandResultCallback(k cb) {
        void var1_1;
        this.mCommandResultCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void success(Object obj) {
        k this_ = ((BCBeaconCommand)((Object)this_)).mCommandResultCallback;
        if (this_ != null) {
            void var1_1;
            this_.a(var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIndicator() {
        BCBeaconCommand bCBeaconCommand = this_;
        Object this_ = bCBeaconCommand.mHasIndicatorLock;
        synchronized (this_) {
            return bCBeaconCommand.mHasIndicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setHasIndicator(boolean value) {
        Object object = this.mHasIndicatorLock;
        synchronized (object) {
            void var1_1;
            this.mHasIndicator = var1_1;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void login(k loginSuccessCallback) {
        a.a.a.b b3 = this_.mBeaconCommandManagerCallback;
        if (b3 != null && b3.a() != null && (b3 = this_.mBeaconCommandManagerCallback.b()) != null) {
            void var1_1;
            b3 = b3.getCharacteristic(CH_UUID_INDICATOR);
            String string = TAG;
            String string2 = "CH_UUID_INDICATOR is %s, mPasscode: %s";
            Object[] objectArray = new Object[2];
            int n2 = 0;
            String string3 = b3 == null ? "null" : b3.getUuid().toString();
            objectArray[n2] = string3;
            objectArray[1] = b2.a(this_.mPasscodeData);
            BCLog.Log.d(string, string2, objectArray);
            boolean bl = b3 != null;
            this_.setHasIndicator(bl);
            this_.mLoginCommandSuccessCallback = var1_1;
            if (b3 != null) {
                Object[] objectArray2 = this_;
                Object[] objectArray3 = this_;
                objectArray2.enableIndicator(true);
                objectArray3.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_ENABLE_INDICATOR);
                objectArray3.setBeaconCommandResultCallback(objectArray2.d);
                return;
            }
            Object[] objectArray4 = this_;
            Object[] this_ = new Object[]{};
            BCLog.Log.d(TAG, "call legacy login 2.", this_);
            objectArray4.loginLegacy((k)var1_1);
            return;
        }
        this_.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_FAILED);
        this_.failedWithErrorDescription("Read water failed.");
    }

    /*
     * WARNING - void declaration
     */
    public void loginLegacy(k loginSuccessCallback) {
        void var1_1;
        if (!this_.readCharacteristicData(CH_UUID_WATER)) {
            this_.failedWithErrorDescription("Read water failed.");
            return;
        }
        Object[] objectArray = this_;
        objectArray.setState(BCBeaconCommandState.BC_BEACON_COMMAND_STATE_LOGIN_READ_WATER);
        this_.setBeaconCommandResultCallback(objectArray.b);
        this_.mLoginCommandSuccessCallback = var1_1;
        Object[] this_ = new Object[]{};
        BCLog.Log.d(TAG, "read water", this_);
    }

    /*
     * WARNING - void declaration
     */
    public void writeBulkData(byte[] characteristicData, int blockSize) {
        void var2_2;
        void var1_1;
        this.writeBlockData((byte[])var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public void writeBlockData(byte[] characteristicData, int blockSize, boolean enable) {
        void var2_2;
        void var1_1;
        this.dataIndex = 0;
        int n2 = ((void)var1_1).length;
        BCBeaconCommand bCBeaconCommand = this;
        bCBeaconCommand.dataLength = n2;
        bCBeaconCommand.writeDataBlockSize = var2_2;
        Object[] objectArray = new byte[n2];
        this.writeData = objectArray;
        System.arraycopy(var1_1, 0, objectArray, 0, n2);
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = b2.a((byte[])var1_1);
        BCLog.Log.d(TAG, "bulk data to write: [%s]", objectArray);
        if (enable) {
            void var3_4;
            this.enableIndicator((boolean)var3_4);
        } else {
            this.writeNextDataPacket();
        }
    }

    public void writeNextDataPacket() {
        BCBeaconCommand bCBeaconCommand = this;
        int n2 = Math.min(bCBeaconCommand.writeDataBlockSize, this.dataLength - this.dataIndex);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.writeData, this.dataIndex, byArray, 0, n2);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = b2.a(byArray);
        BCLog.Log.d(TAG, "writing bulk data: [%s]", objectArray2);
        if (!bCBeaconCommand.writeCharacteristicData(byArray, CH_UUID_CONTROL)) {
            this.failedWithErrorDescription("Write bulk data failed.");
            return;
        }
        this.dataIndex += n2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBulkDataBlocks(BCBeaconOpcode code, byte[] bulkData) {
        ByteArrayOutputStream byteArrayOutputStream;
        int n2 = 16;
        int n3 = bulkData.length / n2;
        if (bulkData.length % n2 != 0) {
            ++n3;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < n3; ++i2) {
            BCBeaconOpcode bCBeaconOpcode;
            void var2_3;
            int n4 = i2 * n2;
            int n5 = Math.min(n2, ((void)var2_3).length - n4);
            if (bCBeaconOpcode == BCBeaconOpcode.BC_BEACON_OPCODE_SETTINGS_BULK && i2 == n3 - 1) {
                bCBeaconOpcode = BCBeaconOpcode.BC_BEACON_OPCODE_SETTINGS_BULK_END;
            }
            byteArrayOutputStream2.write(bCBeaconOpcode.getValue());
            byteArrayOutputStream2.write(i2);
            byteArrayOutputStream2.write((byte[])var2_3, n4, n5);
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public void writeInitVector(byte[] iv) {
        Object[] objectArray;
        BCBeaconCommand bCBeaconCommand = this_;
        byte[] byArray = new byte[17];
        Object this_ = byArray;
        byArray[0] = (byte)BCBeaconOpcode.BC_BEACON_OPCODE_SECURE_SETTINGS_INITIALIZATION_VECTOR.getValue();
        System.arraycopy(objectArray, 0, this_, 1, 16);
        bCBeaconCommand.writeCharacteristicData((byte[])this_, CH_UUID_CONTROL);
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = b2.a((byte[])this_);
        BCLog.Log.d(TAG, "writing iv...[%s]", objectArray);
    }

    public void writeMACData(byte[] mac) {
        Object[] objectArray;
        BCBeaconCommand bCBeaconCommand = this_;
        byte[] byArray = new byte[17];
        Object this_ = byArray;
        byArray[0] = (byte)BCBeaconOpcode.BC_BEACON_OPCODE_SECURE_SETTINGS_MAC.getValue();
        System.arraycopy(objectArray, 0, this_, 1, 16);
        bCBeaconCommand.writeCharacteristicData((byte[])this_, CH_UUID_CONTROL);
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = b2.a((byte[])this_);
        BCLog.Log.d(TAG, "writing mac data...[%s]", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public void writeSettingsStrEnd(int seqNum) {
        void var1_1;
        if (!this_.writeCharacteristicData(new byte[]{(byte)BCBeaconOpcode.BC_BEACON_OPCODE_SETTINGS_STRING_END.getValue(), (byte)var1_1}, CH_UUID_CONTROL)) {
            Object[] objectArray = this_;
            Object[] this_ = new Object[]{};
            BCLog.Log.d(TAG, "Write settings string end opcode failed.", this_);
            objectArray.failedWithErrorDescription("Write settings string end opcode failed.");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeStreamData(byte[] streamData, int chunkSize) {
        void var2_3;
        void var1_1;
        BCBeaconCommand bCBeaconCommand = object;
        ((BCBeaconCommand)object).dataIndex = 0;
        int n2 = ((void)var1_1).length;
        BCBeaconCommand bCBeaconCommand2 = object;
        bCBeaconCommand2.dataLength = n2;
        bCBeaconCommand2.writeDataBlockSize = var2_3;
        byte[] byArray = new byte[n2];
        Object object = byArray;
        bCBeaconCommand.writeData = byArray;
        System.arraycopy(streamData, 0, object, 0, n2);
    }

    public void writeNextStreamDataPacket() {
        BCBeaconCommand bCBeaconCommand = this;
        int n2 = Math.min(bCBeaconCommand.writeDataBlockSize, this.dataLength - this.dataIndex);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.writeData, this.dataIndex, byArray, 0, n2);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = b2.a(byArray);
        BCLog.Log.d(TAG, "writing stream data: %s", objectArray2);
        if (!bCBeaconCommand.writeCharacteristicDataNoResponse(byArray, CH_UUID_GRAVY)) {
            this.failedWithErrorDescription("Write gravy data failed.");
            return;
        }
        this.dataIndex += n2;
    }

    public void writeDFUData() {
        if (!this_.writeCharacteristicData(new byte[]{(byte)BCBeaconOpcode.BC_BEACON_OPCODE_GO_DFU.getValue()}, CH_UUID_CONTROL)) {
            Object[] objectArray = this_;
            Object[] this_ = new Object[]{};
            BCLog.Log.d(TAG, "DFU write status op fail.", this_);
            objectArray.failedWithErrorDescription("Write DFU OP failed.");
            return;
        }
    }

    public byte[] getDataFromHexString(String hexString) {
        Object object = hexString.replace("-", "");
        if (((String)object).length() != 32) {
            return new byte[0];
        }
        object = ((String)object).toUpperCase(Locale.US);
        int n2 = 16;
        byte[] byArray = new byte[16];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 2;
            byArray[i2] = (byte)(BCBeaconCommand.char2Hex(((String)object).charAt(n3)) << 4);
            byArray[i2] = (byte)(byArray[i2] | BCBeaconCommand.char2Hex(((String)object).charAt(n3 + 1)));
        }
        return byArray;
    }

    public static interface k {
        public void a(Object var1);
    }

    public static final class BCBeaconLoginResult
    extends Enum<BCBeaconLoginResult> {
        public static final /* enum */ BCBeaconLoginResult UNKNOWN;
        public static final /* enum */ BCBeaconLoginResult SUCCESS;
        public static final /* enum */ BCBeaconLoginResult FAILED;
        public static final /* enum */ BCBeaconLoginResult DISABLED;
        public static final /* synthetic */ BCBeaconLoginResult[] $VALUES;
        public int value;

        public static BCBeaconLoginResult[] values() {
            return (BCBeaconLoginResult[])$VALUES.clone();
        }

        public static BCBeaconLoginResult valueOf(String name) {
            String string;
            return Enum.valueOf(BCBeaconLoginResult.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public BCBeaconLoginResult(int v2) {
            void var3_3;
            this.value = var3_3;
        }

        public static BCBeaconLoginResult getType(int v2) {
            int n2;
            if (v2 == 1) {
                return SUCCESS;
            }
            if (n2 == 2) {
                return FAILED;
            }
            if (n2 == 3) {
                return DISABLED;
            }
            return UNKNOWN;
        }

        static {
            BCBeaconLoginResult bCBeaconLoginResult;
            UNKNOWN = new BCBeaconLoginResult(0);
            SUCCESS = new BCBeaconLoginResult(1);
            FAILED = new BCBeaconLoginResult(2);
            BCBeaconLoginResult bCBeaconLoginResult2 = bCBeaconLoginResult;
            DISABLED = new BCBeaconLoginResult(3);
            $VALUES = new BCBeaconLoginResult[]{UNKNOWN, SUCCESS, FAILED, bCBeaconLoginResult2};
        }
    }

    public static final class BCBeaconIndicatorResponse
    extends Enum<BCBeaconIndicatorResponse> {
        public static final /* enum */ BCBeaconIndicatorResponse LOGIN_RESULT_UNKNOWN;
        public static final /* enum */ BCBeaconIndicatorResponse LOGIN_RESULT_SUCCESS;
        public static final /* enum */ BCBeaconIndicatorResponse LOGIN_RESULT_FAILED;
        public static final /* enum */ BCBeaconIndicatorResponse LOGIN_RESULT_DISABLED;
        public static final /* enum */ BCBeaconIndicatorResponse SETTINGS_FORMAT_ERROR;
        public static final /* enum */ BCBeaconIndicatorResponse OTA_RETRANS_REQ;
        public static final /* enum */ BCBeaconIndicatorResponse PACKET_SIZE_UPDATE;
        public static final /* enum */ BCBeaconIndicatorResponse OTA_ALIGN_ERROR;
        public static final /* synthetic */ BCBeaconIndicatorResponse[] $VALUES;
        public int mValue;

        public static BCBeaconIndicatorResponse[] values() {
            return (BCBeaconIndicatorResponse[])$VALUES.clone();
        }

        public static BCBeaconIndicatorResponse valueOf(String name) {
            String string;
            return Enum.valueOf(BCBeaconIndicatorResponse.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public BCBeaconIndicatorResponse(int value) {
            void var3_3;
            this.mValue = var3_3;
        }

        public static BCBeaconIndicatorResponse getType(int v2) {
            switch (v2) {
                default: {
                    return LOGIN_RESULT_UNKNOWN;
                }
                case 4: {
                    return SETTINGS_FORMAT_ERROR;
                }
                case 3: {
                    return LOGIN_RESULT_DISABLED;
                }
                case 2: {
                    return LOGIN_RESULT_FAILED;
                }
                case 1: 
            }
            return LOGIN_RESULT_SUCCESS;
        }

        static {
            BCBeaconIndicatorResponse bCBeaconIndicatorResponse;
            LOGIN_RESULT_UNKNOWN = new BCBeaconIndicatorResponse(0);
            LOGIN_RESULT_SUCCESS = new BCBeaconIndicatorResponse(1);
            LOGIN_RESULT_FAILED = new BCBeaconIndicatorResponse(2);
            LOGIN_RESULT_DISABLED = new BCBeaconIndicatorResponse(3);
            SETTINGS_FORMAT_ERROR = new BCBeaconIndicatorResponse(4);
            OTA_RETRANS_REQ = new BCBeaconIndicatorResponse(257);
            PACKET_SIZE_UPDATE = new BCBeaconIndicatorResponse(258);
            BCBeaconIndicatorResponse bCBeaconIndicatorResponse2 = bCBeaconIndicatorResponse;
            OTA_ALIGN_ERROR = new BCBeaconIndicatorResponse(259);
            $VALUES = new BCBeaconIndicatorResponse[]{LOGIN_RESULT_UNKNOWN, LOGIN_RESULT_SUCCESS, LOGIN_RESULT_FAILED, LOGIN_RESULT_DISABLED, SETTINGS_FORMAT_ERROR, OTA_RETRANS_REQ, PACKET_SIZE_UPDATE, bCBeaconIndicatorResponse2};
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static final class BCBeaconOpcode
    extends Enum<BCBeaconOpcode> {
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_ERASE_BLOCK_0;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_ERASE_BLOCK_1;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_ERASE_POINTER;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_GO_DFU;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_POWER_ON;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_RESTART;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_RESET;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_WRITE_VERSION_LINE_1;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_WRITE_VERSION_LINE_2;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_WRITE_VERSION_LINE_3;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_GO_SECURE_MODE;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_GO_IBEACON_MODE;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_GO_IBEACON_PLUS_SECURE_MODE;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_REQUEST_DATA;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_RESPONSE_DATA;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_SECURE_SETTINGS_INITIALIZATION_VECTOR;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_SECURE_SETTINGS_BULK_DATA;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_SECURE_SETTINGS_MAC;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_SETTINGS_BULK;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_SETTINGS_STRING_BULK;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_SETTINGS_BULK_END;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_SETTINGS_STRING_END;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_PREPARE_FUTURE_SETTINGS_UPDATE;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_PREPARE_OTA;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_GET_UNENCRYPTED_STATUS;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_GET_ENCRYPTED_STATUS;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_BIM_ERASE;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_OTA_HEADER_WRITE;
        public static final /* enum */ BCBeaconOpcode BC_BEACON_OPCODE_GET_CHALLENGE;
        public static final /* synthetic */ BCBeaconOpcode[] $VALUES;
        public String mDisplayName;
        public int mValue;

        public static BCBeaconOpcode[] values() {
            return (BCBeaconOpcode[])$VALUES.clone();
        }

        public static BCBeaconOpcode valueOf(String name) {
            String string;
            return Enum.valueOf(BCBeaconOpcode.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public BCBeaconOpcode(String displayName, int value) {
            void var4_4;
            void var3_3;
            this.mDisplayName = var3_3;
            this.mValue = var4_4;
        }

        static {
            BCBeaconOpcode bCBeaconOpcode;
            BC_BEACON_OPCODE_ERASE_BLOCK_0 = new BCBeaconOpcode("Erase Block 0", 0);
            BC_BEACON_OPCODE_ERASE_BLOCK_1 = new BCBeaconOpcode("Erase Block 1", 1);
            BC_BEACON_OPCODE_ERASE_POINTER = new BCBeaconOpcode("Erase Pointer", 2);
            BC_BEACON_OPCODE_GO_DFU = new BCBeaconOpcode("Go DFU", 3);
            BC_BEACON_OPCODE_POWER_ON = new BCBeaconOpcode("Power On", 4);
            BC_BEACON_OPCODE_RESTART = new BCBeaconOpcode("Restart", 11);
            BC_BEACON_OPCODE_RESET = new BCBeaconOpcode("Reset", 12);
            BC_BEACON_OPCODE_WRITE_VERSION_LINE_1 = new BCBeaconOpcode("Write Version Line 1", 13);
            BC_BEACON_OPCODE_WRITE_VERSION_LINE_2 = new BCBeaconOpcode("Write Version Line 2", 14);
            BC_BEACON_OPCODE_WRITE_VERSION_LINE_3 = new BCBeaconOpcode("Write Version Line 3", 15);
            BC_BEACON_OPCODE_GO_SECURE_MODE = new BCBeaconOpcode("Go Secure Mode", 16);
            BC_BEACON_OPCODE_GO_IBEACON_MODE = new BCBeaconOpcode("Go iBeacon Mode", 17);
            BC_BEACON_OPCODE_GO_IBEACON_PLUS_SECURE_MODE = new BCBeaconOpcode("Go iBeacon+Secure Mode", 18);
            BC_BEACON_OPCODE_REQUEST_DATA = new BCBeaconOpcode("Request Data", 19);
            BC_BEACON_OPCODE_RESPONSE_DATA = new BCBeaconOpcode("Response Data", 20);
            BC_BEACON_OPCODE_SECURE_SETTINGS_INITIALIZATION_VECTOR = new BCBeaconOpcode("Secure Settings Initialization Vector", 21);
            BC_BEACON_OPCODE_SECURE_SETTINGS_BULK_DATA = new BCBeaconOpcode("Secure Settings Bulk Data", 22);
            BC_BEACON_OPCODE_SECURE_SETTINGS_MAC = new BCBeaconOpcode("Secure Settings MAC", 23);
            BC_BEACON_OPCODE_SETTINGS_BULK = new BCBeaconOpcode("Settings Bulk", 24);
            BC_BEACON_OPCODE_SETTINGS_STRING_BULK = new BCBeaconOpcode("Settings String", 24);
            BC_BEACON_OPCODE_SETTINGS_BULK_END = new BCBeaconOpcode("Settings Bulk End", 25);
            BC_BEACON_OPCODE_SETTINGS_STRING_END = new BCBeaconOpcode("Settings String End", 25);
            BC_BEACON_OPCODE_PREPARE_FUTURE_SETTINGS_UPDATE = new BCBeaconOpcode("Prepare Future Settings Update", 26);
            BC_BEACON_OPCODE_PREPARE_OTA = new BCBeaconOpcode("Prepare OTA", 27);
            BC_BEACON_OPCODE_GET_UNENCRYPTED_STATUS = new BCBeaconOpcode("Get Unencrypted Status", 28);
            BC_BEACON_OPCODE_GET_ENCRYPTED_STATUS = new BCBeaconOpcode("Get encrypted Status", 29);
            BC_BEACON_OPCODE_BIM_ERASE = new BCBeaconOpcode("Erase BIM", 30);
            BC_BEACON_OPCODE_OTA_HEADER_WRITE = new BCBeaconOpcode("OTA header write", 31);
            BCBeaconOpcode bCBeaconOpcode2 = bCBeaconOpcode;
            BC_BEACON_OPCODE_GET_CHALLENGE = new BCBeaconOpcode("Get challenge", 32);
            $VALUES = new BCBeaconOpcode[]{BC_BEACON_OPCODE_ERASE_BLOCK_0, BC_BEACON_OPCODE_ERASE_BLOCK_1, BC_BEACON_OPCODE_ERASE_POINTER, BC_BEACON_OPCODE_GO_DFU, BC_BEACON_OPCODE_POWER_ON, BC_BEACON_OPCODE_RESTART, BC_BEACON_OPCODE_RESET, BC_BEACON_OPCODE_WRITE_VERSION_LINE_1, BC_BEACON_OPCODE_WRITE_VERSION_LINE_2, BC_BEACON_OPCODE_WRITE_VERSION_LINE_3, BC_BEACON_OPCODE_GO_SECURE_MODE, BC_BEACON_OPCODE_GO_IBEACON_MODE, BC_BEACON_OPCODE_GO_IBEACON_PLUS_SECURE_MODE, BC_BEACON_OPCODE_REQUEST_DATA, BC_BEACON_OPCODE_RESPONSE_DATA, BC_BEACON_OPCODE_SECURE_SETTINGS_INITIALIZATION_VECTOR, BC_BEACON_OPCODE_SECURE_SETTINGS_BULK_DATA, BC_BEACON_OPCODE_SECURE_SETTINGS_MAC, BC_BEACON_OPCODE_SETTINGS_BULK, BC_BEACON_OPCODE_SETTINGS_STRING_BULK, BC_BEACON_OPCODE_SETTINGS_BULK_END, BC_BEACON_OPCODE_SETTINGS_STRING_END, BC_BEACON_OPCODE_PREPARE_FUTURE_SETTINGS_UPDATE, BC_BEACON_OPCODE_PREPARE_OTA, BC_BEACON_OPCODE_GET_UNENCRYPTED_STATUS, BC_BEACON_OPCODE_GET_ENCRYPTED_STATUS, BC_BEACON_OPCODE_BIM_ERASE, BC_BEACON_OPCODE_OTA_HEADER_WRITE, bCBeaconOpcode2};
        }

        public String getDisplayName() {
            return this.mDisplayName;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static final class BCBeaconCommandState
    extends Enum<BCBeaconCommandState> {
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_UNKNOWN;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_READY;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_PREPARING_FOR_CONNECTION;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_CONNECTING;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_CONNECTED;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_DISCONNECTING;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_FINISHED;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_FAILED;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_LOGIN_READ_WATER;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_LOGIN_WRITE_MILK;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_WRITE_CONTROL_DATA;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_WRITE_UUID;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_WRITE_VERSION;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_CONFIRM_VERSION;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_REFRESH_BEACON;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_CONTINUE_BLOCK_DATA;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_ENABLE_INDICATOR;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_LOGIN_READ_STATUS;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_LOGIN_READ_STATUS_INDICATOR;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_GET_MILK_FROM_API;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_KEEP_ALIVE;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_WRITE_FIRMWARE;
        public static final /* enum */ BCBeaconCommandState BC_BEACON_COMMAND_STATE_WAITING_FOR_STATUS;
        public static final /* synthetic */ BCBeaconCommandState[] $VALUES;
        public String mDisplayName;
        public int mValue;

        public static BCBeaconCommandState[] values() {
            return (BCBeaconCommandState[])$VALUES.clone();
        }

        public static BCBeaconCommandState valueOf(String name) {
            String string;
            return Enum.valueOf(BCBeaconCommandState.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public BCBeaconCommandState(String displayName, int value) {
            void var4_4;
            void var3_3;
            this.mDisplayName = var3_3;
            this.mValue = var4_4;
        }

        static {
            BCBeaconCommandState bCBeaconCommandState;
            BC_BEACON_COMMAND_STATE_UNKNOWN = new BCBeaconCommandState("Unknown", 0);
            BC_BEACON_COMMAND_STATE_READY = new BCBeaconCommandState("Ready", 1);
            BC_BEACON_COMMAND_STATE_PREPARING_FOR_CONNECTION = new BCBeaconCommandState("Preparing For Connection", 2);
            BC_BEACON_COMMAND_STATE_CONNECTING = new BCBeaconCommandState("Connecting", 3);
            BC_BEACON_COMMAND_STATE_CONNECTED = new BCBeaconCommandState("Connected", 4);
            BC_BEACON_COMMAND_STATE_DISCONNECTING = new BCBeaconCommandState("Disconnected", 5);
            BC_BEACON_COMMAND_STATE_FINISHED = new BCBeaconCommandState("Finished", 6);
            BC_BEACON_COMMAND_STATE_FAILED = new BCBeaconCommandState("Failed", 7);
            BC_BEACON_COMMAND_STATE_LOGIN_READ_WATER = new BCBeaconCommandState("login read water", 8);
            BC_BEACON_COMMAND_STATE_LOGIN_WRITE_MILK = new BCBeaconCommandState("login write milk", 9);
            BC_BEACON_COMMAND_STATE_WRITE_CONTROL_DATA = new BCBeaconCommandState("write control data", 10);
            BC_BEACON_COMMAND_STATE_WRITE_UUID = new BCBeaconCommandState("write uuid", 11);
            BC_BEACON_COMMAND_STATE_WRITE_VERSION = new BCBeaconCommandState("write version", 12);
            BC_BEACON_COMMAND_STATE_CONFIRM_VERSION = new BCBeaconCommandState("confirm version", 13);
            BC_BEACON_COMMAND_STATE_REFRESH_BEACON = new BCBeaconCommandState("refresh beacon", 14);
            BC_BEACON_COMMAND_STATE_CONTINUE_BLOCK_DATA = new BCBeaconCommandState("continue block data", 15);
            BC_BEACON_COMMAND_STATE_ENABLE_INDICATOR = new BCBeaconCommandState("enable indicator", 16);
            BC_BEACON_COMMAND_STATE_LOGIN_READ_STATUS = new BCBeaconCommandState("login read status", 17);
            BC_BEACON_COMMAND_STATE_LOGIN_READ_STATUS_INDICATOR = new BCBeaconCommandState("login read status indicator", 18);
            BC_BEACON_COMMAND_STATE_GET_MILK_FROM_API = new BCBeaconCommandState("get milk from api", 19);
            BC_BEACON_COMMAND_STATE_KEEP_ALIVE = new BCBeaconCommandState("keep alive", 20);
            BC_BEACON_COMMAND_STATE_WRITE_FIRMWARE = new BCBeaconCommandState("write fw", 21);
            BCBeaconCommandState bCBeaconCommandState2 = bCBeaconCommandState;
            BC_BEACON_COMMAND_STATE_WAITING_FOR_STATUS = new BCBeaconCommandState("waiting for status", 22);
            $VALUES = new BCBeaconCommandState[]{BC_BEACON_COMMAND_STATE_UNKNOWN, BC_BEACON_COMMAND_STATE_READY, BC_BEACON_COMMAND_STATE_PREPARING_FOR_CONNECTION, BC_BEACON_COMMAND_STATE_CONNECTING, BC_BEACON_COMMAND_STATE_CONNECTED, BC_BEACON_COMMAND_STATE_DISCONNECTING, BC_BEACON_COMMAND_STATE_FINISHED, BC_BEACON_COMMAND_STATE_FAILED, BC_BEACON_COMMAND_STATE_LOGIN_READ_WATER, BC_BEACON_COMMAND_STATE_LOGIN_WRITE_MILK, BC_BEACON_COMMAND_STATE_WRITE_CONTROL_DATA, BC_BEACON_COMMAND_STATE_WRITE_UUID, BC_BEACON_COMMAND_STATE_WRITE_VERSION, BC_BEACON_COMMAND_STATE_CONFIRM_VERSION, BC_BEACON_COMMAND_STATE_REFRESH_BEACON, BC_BEACON_COMMAND_STATE_CONTINUE_BLOCK_DATA, BC_BEACON_COMMAND_STATE_ENABLE_INDICATOR, BC_BEACON_COMMAND_STATE_LOGIN_READ_STATUS, BC_BEACON_COMMAND_STATE_LOGIN_READ_STATUS_INDICATOR, BC_BEACON_COMMAND_STATE_GET_MILK_FROM_API, BC_BEACON_COMMAND_STATE_KEEP_ALIVE, BC_BEACON_COMMAND_STATE_WRITE_FIRMWARE, bCBeaconCommandState2};
        }

        public String getDisplayName() {
            return this.mDisplayName;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

