/*
 * Decompiled with CFR 0.152.
 */
package com.bluecats.sdk;

import a.a.a.a1;
import a.a.a.g1;
import a.a.a.i0;
import android.bluetooth.BluetoothDevice;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.bluecats.sdk.BCBatteryStatus;
import com.bluecats.sdk.BCBeacon;
import com.bluecats.sdk.BCBeaconApi;
import com.bluecats.sdk.BCBeaconCallback;
import com.bluecats.sdk.BCBeaconCommandCallback;
import com.bluecats.sdk.BCBeaconLoudness;
import com.bluecats.sdk.BCBeaconMode;
import com.bluecats.sdk.BCBeaconRegion;
import com.bluecats.sdk.BCBeaconUpdates;
import com.bluecats.sdk.BCCategory;
import com.bluecats.sdk.BCCustomValue;
import com.bluecats.sdk.BCEddystone;
import com.bluecats.sdk.BCLog;
import com.bluecats.sdk.BCMapPoint;
import com.bluecats.sdk.BCNetworkAccess;
import com.bluecats.sdk.BCTargetSpeed;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BCBeaconInternal
extends BCBeaconUpdates
implements Parcelable,
BCBeacon {
    public static final String TAG = "BCBeacon";
    public static final Parcelable.Creator<BCBeaconInternal> CREATOR = new Parcelable.Creator<BCBeaconInternal>(){

        /*
         * WARNING - void declaration
         */
        public BCBeaconInternal createFromParcel(Parcel in) {
            void var1_1;
            return new BCBeaconInternal((Parcel)var1_1, null);
        }

        public BCBeaconInternal[] newArray(int size) {
            return new BCBeaconInternal[size];
        }
    };
    public volatile String name;
    public final Object mNameLock = new Object();
    public volatile String message;
    public final Object mMessageLock = new Object();
    public volatile Integer measuredPowerAt1Meter;
    public final Object mMeasuredPowerAt1MeterLock = new Object();
    public volatile String wireframeUrl;
    public final Object mWireframeURLLock = new Object();
    public volatile String serialNumber;
    public final Object mSerialNumberLock = new Object();
    public volatile Date createdAt;
    public final Object mCreatedAtLock = new Object();
    public volatile Date modifiedAt;
    public final Object mModifiedAtLock = new Object();
    public volatile BCBeaconRegion beaconRegion;
    public final Object mBeaconRegionLock = new Object();
    public volatile BCBeaconMode beaconMode;
    public final Object mBeaconModeLock = new Object();
    public volatile BCBatteryStatus batteryStatus;
    public final Object mBatteryStatusLock = new Object();
    public volatile BCMapPoint mapPoint;
    public final Object mMapPointLock = new Object();
    public volatile Date lastRangedAt;
    public final Object mLastRangedAtLock = new Object();
    public volatile Date firstRangedAt;
    public final Object mFirstRangedAtLock = new Object();
    public volatile Date cachedAt;
    public final Object mCachedAtLock = new Object();
    public volatile Double accuracy;
    public final Object mAccuracyLock = new Object();
    public volatile Integer rssi;
    public final Object mRSSILock = new Object();
    public volatile BCBeacon.BCProximity proximity;
    public final Object mProximityLock = new Object();
    public volatile BCNetworkAccess networkAccess;
    public final Object mNetworkAccessLock = new Object();
    public volatile String mCacheIdentifier;
    public final Object mCacheIdentifierLock = new Object();
    public volatile String mUptime;
    public final Object mUptimeLock = new Object();
    public volatile Integer featureBitmask;
    public final Object mFeatureBitMaskLock = new Object();
    public volatile BluetoothDevice mDevice;
    public final Object mDeviceLock = new Object();

    public BCBeaconInternal() {
        this.mAdData = new HashMap<String, Map<String, String>>();
        this.syncStatus = BCBeacon.BCSyncStatus.BC_SYNC_STATUS_NOT_SYNCED;
        this.accuracy = -1.0;
        this.reassembledBlockData = new ArrayList<Map<String, String>>();
    }

    public static BCBeacon.BCProximity getProximityFromString(String value) {
        String string;
        if (value.equals("BC_PROXIMITY_IMMEDIATE")) {
            return BCBeacon.BCProximity.BC_PROXIMITY_IMMEDIATE;
        }
        if (string.equals("BC_PROXIMITY_NEAR")) {
            return BCBeacon.BCProximity.BC_PROXIMITY_NEAR;
        }
        if (string.equals("BC_PROXIMITY_FAR")) {
            return BCBeacon.BCProximity.BC_PROXIMITY_FAR;
        }
        return BCBeacon.BCProximity.BC_PROXIMITY_UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags bitmask) {
        void var1_1;
        return this.getFeatureBitMask() != null && var1_1 != null && (this.getFeatureBitMask() & var1_1.getValue()) != 0;
    }

    private boolean shouldUpgradeFirmware() {
        if (this.getFirmwareUpdateAvailabilityStatus() == BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_AVAILABLE) {
            if (g1.b(this.getLatestFirmwareUID())) {
                return false;
            }
            String string = this.getStringFromLatestBlueCatsAdDataForKey("BC_AD_DATA_FIRMWARE_UID_KEY");
            if (g1.b(string)) {
                return false;
            }
            if (!string.equalsIgnoreCase(this.getLatestFirmwareUID())) {
                return true;
            }
            if (g1.b(this.getFirmwareUID()) && g1.b(this.getPendingVersion())) {
                return true;
            }
            if (g1.b(this.getPendingVersion()) && !this.getLatestFirmwareUID().equalsIgnoreCase(this.getFirmwareUID())) {
                return true;
            }
            if (g1.b(this.getFirmwareVersion()) && this.getPendingVersion() == null) {
                return true;
            }
            if (!this.getLatestFirmwareVersion().equalsIgnoreCase(this.getFirmwareVersion()) && this.getPendingVersion() == null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public BCBeaconInternal(Parcel in) {
        HashMap<String, String> hashMap;
        void var1_1;
        this.id = var1_1.readString();
        this.name = var1_1.readString();
        this.teamID = var1_1.readString();
        this.siteID = var1_1.readString();
        this.siteName = var1_1.readString();
        this.bluetoothAddress = var1_1.readString();
        this.setBluetoothAddressUpperCase();
        this.measuredPowerAt1Meter = (Integer)var1_1.readValue(Integer.class.getClassLoader());
        this.firmwareVersion = var1_1.readString();
        this.latestFirmwareVersion = var1_1.readString();
        this.firmwareUID = var1_1.readString();
        this.latestFirmwareUID = var1_1.readString();
        this.modelNumber = var1_1.readString();
        this.serialNumber = var1_1.readString();
        boolean bl = in.readInt() == 1;
        this.upgradableOTA = bl;
        this.privacyDuration = (Integer)var1_1.readValue(Integer.class.getClassLoader());
        this.lastKnownBatteryLevel = (Integer)var1_1.readValue(Integer.class.getClassLoader());
        this.version = var1_1.readString();
        this.pendingVersion = var1_1.readString();
        Object object = (Long)var1_1.readValue(Long.class.getClassLoader());
        if (object != null) {
            this.createdAt = new Date((Long)object);
        }
        if ((object = (Long)var1_1.readValue(Long.class.getClassLoader())) != null) {
            this.modifiedAt = new Date((Long)object);
        }
        this.featureBitmask = (Integer)var1_1.readValue(Integer.class.getClassLoader());
        this.beaconRegion = (BCBeaconRegion)var1_1.readParcelable(BCBeaconRegion.class.getClassLoader());
        this.beaconMode = (BCBeaconMode)var1_1.readParcelable(BCBeaconMode.class.getClassLoader());
        this.batteryStatus = (BCBatteryStatus)var1_1.readParcelable(BCBatteryStatus.class.getClassLoader());
        this.beaconLoudness = (BCBeaconLoudness)var1_1.readParcelable(BCBeaconLoudness.class.getClassLoader());
        this.targetSpeed = (BCTargetSpeed)var1_1.readParcelable(BCTargetSpeed.class.getClassLoader());
        this.mapPoint = (BCMapPoint)var1_1.readParcelable(BCMapPoint.class.getClassLoader());
        this.categories = (BCCategory[])var1_1.createTypedArray(BCCategory.CREATOR);
        this.customValues = (BCCustomValue[])var1_1.createTypedArray(BCCustomValue.CREATOR);
        this.peripheralIdentifier = var1_1.readString();
        object = (Long)var1_1.readValue(Long.class.getClassLoader());
        if (object != null) {
            this.firstDiscoveredAt = new Date((Long)object);
        }
        if ((object = (Long)var1_1.readValue(Long.class.getClassLoader())) != null) {
            this.lastDiscoveredAt = new Date((Long)object);
        }
        object = var1_1.readString();
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        this.mAdData = new HashMap<String, Map<String, String>>();
        Bundle bundle = var1_1.readBundle(String.class.getClassLoader());
        for (String string : bundle.keySet()) {
            hashMap2.put(string, bundle.getString(string));
        }
        this.mAdData.put((String)object, hashMap2);
        this.proximityUUID = var1_1.readString();
        this.setProximityUUIDStringUpperCase();
        this.major = (Integer)var1_1.readValue(Integer.class.getClassLoader());
        this.minor = (Integer)var1_1.readValue(Integer.class.getClassLoader());
        object = (Long)var1_1.readValue(Long.class.getClassLoader());
        if (object != null) {
            this.lastRangedAt = new Date((Long)object);
        }
        if ((object = (Long)var1_1.readValue(Long.class.getClassLoader())) != null) {
            this.firstRangedAt = new Date((Long)object);
        }
        if ((object = (Long)var1_1.readValue(Long.class.getClassLoader())) != null) {
            this.cachedAt = new Date((Long)object);
        }
        if ((object = (Long)var1_1.readValue(Long.class.getClassLoader())) != null) {
            this.syncedAt = new Date((Long)object);
        }
        this.syncStatus = (BCBeacon.BCSyncStatus)((Object)var1_1.readSerializable());
        this.accuracy = (Double)var1_1.readValue(Double.class.getClassLoader());
        this.rssi = (Integer)var1_1.readValue(Integer.class.getClassLoader());
        this.proximity = (BCBeacon.BCProximity)((Object)var1_1.readSerializable());
        this.networkAccess = (BCNetworkAccess)var1_1.readParcelable(BCNetworkAccess.class.getClassLoader());
        this.eddystone = (BCEddystone)var1_1.readParcelable(BCEddystone.class.getClassLoader());
        this.mCacheIdentifier = var1_1.readString();
        this.wireframeUrl = var1_1.readString();
    }

    private void cancelRunningBeaconCommand() {
        i0.o().c().f();
    }

    private void cancelAllQueuedBeaconCommands() {
        i0.o().c().e();
    }

    /*
     * WARNING - void declaration
     */
    private BCBeacon getCachedBeaconForBeacon(BCBeacon copiedBeacon) {
        void var1_1;
        return i0.o().c().d((BCBeaconInternal)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ BCBeaconInternal(Parcel x02, 1 x12) {
        this((Parcel)var1_1);
        void var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mNameLock;
        synchronized (this_) {
            return bCBeaconInternal.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setName(String value) {
        Object object = this.mNameLock;
        synchronized (object) {
            void var1_1;
            this.name = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mMessageLock;
        synchronized (this_) {
            return bCBeaconInternal.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMessage(String value) {
        Object object = this.mMessageLock;
        synchronized (object) {
            void var1_1;
            this.message = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getMeasuredPowerAt1Meter() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mMeasuredPowerAt1MeterLock;
        synchronized (this_) {
            return bCBeaconInternal.measuredPowerAt1Meter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setMeasuredPowerAt1Meter(Integer value) {
        Object object = this.mMeasuredPowerAt1MeterLock;
        synchronized (object) {
            void var1_1;
            this.measuredPowerAt1Meter = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWireframeURLString() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mWireframeURLLock;
        synchronized (this_) {
            return bCBeaconInternal.wireframeUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setWireframeURLString(String value) {
        Object object = this.mWireframeURLLock;
        synchronized (object) {
            void var1_1;
            this.wireframeUrl = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerialNumber() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mSerialNumberLock;
        synchronized (this_) {
            return bCBeaconInternal.serialNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setSerialNumber(String value) {
        Object object = this.mSerialNumberLock;
        synchronized (object) {
            void var1_1;
            this.serialNumber = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getCreatedAt() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mCreatedAtLock;
        synchronized (this_) {
            return bCBeaconInternal.createdAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setCreatedAt(Date value) {
        Object object = this.mCreatedAtLock;
        synchronized (object) {
            void var1_1;
            this.createdAt = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getModifiedAt() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mModifiedAtLock;
        synchronized (this_) {
            return bCBeaconInternal.modifiedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setModifiedAt(Date value) {
        Object object = this.mModifiedAtLock;
        synchronized (object) {
            void var1_1;
            this.modifiedAt = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BCBeaconRegion getBeaconRegion() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mBeaconRegionLock;
        synchronized (this_) {
            return bCBeaconInternal.beaconRegion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setBeaconRegion(BCBeaconRegion value) {
        Object object = this.mBeaconRegionLock;
        synchronized (object) {
            void var1_1;
            this.beaconRegion = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BCBeaconMode getBeaconMode() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mBeaconModeLock;
        synchronized (this_) {
            return bCBeaconInternal.beaconMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setBeaconMode(BCBeaconMode value) {
        Object object = this.mBeaconModeLock;
        synchronized (object) {
            void var1_1;
            this.beaconMode = var1_1;
            return;
        }
    }

    public BCBeaconMode getBeaconModeFromBlueCatsAdData() {
        int n2;
        try {
            n2 = Integer.parseInt(this.getStringFromLatestBlueCatsAdDataForKey("BC_AD_DATA_BEACON_MODE_ID_KEY"));
        }
        catch (Exception exception) {
            return null;
        }
        return new BCBeaconMode(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BCBatteryStatus getBatteryStatus() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mBatteryStatusLock;
        synchronized (this_) {
            return bCBeaconInternal.batteryStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setBatteryStatus(BCBatteryStatus value) {
        Object object = this.mBatteryStatusLock;
        synchronized (object) {
            void var1_1;
            this.batteryStatus = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BCMapPoint getMapPoint() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mMapPointLock;
        synchronized (this_) {
            return bCBeaconInternal.mapPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMapPoint(BCMapPoint value) {
        Object object = this.mMapPointLock;
        synchronized (object) {
            void var1_1;
            this.mapPoint = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getLastRangedAt() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mLastRangedAtLock;
        synchronized (this_) {
            return bCBeaconInternal.lastRangedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setLastRangedAt(Date value) {
        Object object = this.mLastRangedAtLock;
        synchronized (object) {
            void var1_1;
            this.lastRangedAt = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFirstRangedAt() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mFirstRangedAtLock;
        synchronized (this_) {
            return bCBeaconInternal.firstRangedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setFirstRangedAt(Date value) {
        Object object = this.mFirstRangedAtLock;
        synchronized (object) {
            void var1_1;
            this.firstRangedAt = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getCachedAt() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mCachedAtLock;
        synchronized (this_) {
            return bCBeaconInternal.cachedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setCachedAt(Date value) {
        Object object = this.mCachedAtLock;
        synchronized (object) {
            void var1_1;
            this.cachedAt = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getAccuracy() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mAccuracyLock;
        synchronized (this_) {
            return bCBeaconInternal.accuracy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setAccuracy(Double value) {
        Object object = this.mAccuracyLock;
        synchronized (object) {
            void var1_1;
            this.accuracy = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getRSSI() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mRSSILock;
        synchronized (this_) {
            return bCBeaconInternal.rssi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setRSSI(Integer value) {
        Object object = this.mRSSILock;
        synchronized (object) {
            void var1_1;
            this.rssi = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BCBeacon.BCProximity getProximity() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mProximityLock;
        synchronized (this_) {
            return bCBeaconInternal.proximity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setProximity(BCBeacon.BCProximity value) {
        Object object = this.mProximityLock;
        synchronized (object) {
            void var1_1;
            this.proximity = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BCNetworkAccess getNetworkAccess() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mNetworkAccessLock;
        synchronized (this_) {
            return bCBeaconInternal.networkAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setNetworkAccess(BCNetworkAccess value) {
        Object object = this.mNetworkAccessLock;
        synchronized (object) {
            void var1_1;
            this.networkAccess = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCacheIdentifier() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mCacheIdentifierLock;
        synchronized (this_) {
            return bCBeaconInternal.mCacheIdentifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setCacheIdentifier(String value) {
        Object object = this.mCacheIdentifierLock;
        synchronized (object) {
            void var1_1;
            this.mCacheIdentifier = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUptime() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mUptimeLock;
        synchronized (this_) {
            return bCBeaconInternal.mUptime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setUptime(String value) {
        Object object = this.mUptimeLock;
        synchronized (object) {
            void var1_1;
            this.mUptime = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getFeatureBitMask() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mFeatureBitMaskLock;
        synchronized (this_) {
            return bCBeaconInternal.featureBitmask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setFeatureBitMask(Integer value) {
        Object object = this.mFeatureBitMaskLock;
        synchronized (object) {
            void var1_1;
            this.featureBitmask = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothDevice getDevice() {
        BCBeaconInternal bCBeaconInternal = this_;
        Object this_ = bCBeaconInternal.mDeviceLock;
        synchronized (this_) {
            return bCBeaconInternal.mDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setDevice(BluetoothDevice device) {
        Object object = this.mDeviceLock;
        synchronized (object) {
            void var1_1;
            this.mDevice = var1_1;
            return;
        }
    }

    @Override
    public BCBeacon copy() {
        return this.copyInternal();
    }

    public BCBeaconInternal copyInternal() {
        BCBeaconInternal bCBeaconInternal;
        BCBeaconInternal bCBeaconInternal2 = bCBeaconInternal;
        bCBeaconInternal2();
        bCBeaconInternal2.setCacheIdentifier(this.getCacheIdentifier());
        bCBeaconInternal2.setUptime(this.getUptime());
        bCBeaconInternal2.setBeaconID(this.getBeaconID());
        bCBeaconInternal2.setName(this.getName());
        bCBeaconInternal2.setTeamID(this.getTeamID());
        bCBeaconInternal2.setSiteID(this.getSiteID());
        bCBeaconInternal2.setSiteName(this.getSiteName());
        bCBeaconInternal2.setSite(this.getSite());
        bCBeaconInternal2.setBluetoothAddress(this.getBluetoothAddress());
        bCBeaconInternal2.setMeasuredPowerAt1Meter(this.getMeasuredPowerAt1Meter());
        bCBeaconInternal2.setFirmwareVersion(this.getFirmwareVersion());
        bCBeaconInternal2.setLatestFirmwareVersion(this.getLatestFirmwareVersion());
        bCBeaconInternal2.setFirmwareUID(this.getFirmwareUID());
        bCBeaconInternal2.setLatestFirmwareUID(this.getLatestFirmwareUID());
        bCBeaconInternal2.setModelNumber(this.getModelNumber());
        bCBeaconInternal2.setSerialNumber(this.getSerialNumber());
        bCBeaconInternal2.setUpgradableOTA(this.getUpgradableOTA());
        bCBeaconInternal2.setPrivacyDuration(this.getPrivacyDuration());
        bCBeaconInternal2.setVersion(this.getVersion());
        bCBeaconInternal2.setPendingVersion(this.getPendingVersion());
        bCBeaconInternal2.setCreatedAt(this.getCreatedAt());
        bCBeaconInternal2.setModifiedAt(this.getModifiedAt());
        bCBeaconInternal2.setBeaconRegion(this.getBeaconRegion());
        bCBeaconInternal2.setBeaconMode(this.getBeaconMode());
        bCBeaconInternal2.setBatteryStatus(this.getBatteryStatus());
        bCBeaconInternal2.setBeaconLoudness(this.getBeaconLoudness());
        bCBeaconInternal2.setTargetSpeed(this.getTargetSpeed());
        bCBeaconInternal.setMapPoint(this.getMapPoint());
        if (this.getCategories() != null) {
            bCBeaconInternal2.setCategories((BCCategory[])this.getCategories().clone());
        }
        if (this.getCustomValues() != null) {
            bCBeaconInternal2.setCustomValues((BCCustomValue[])this.getCustomValues().clone());
        }
        BCBeaconInternal bCBeaconInternal3 = bCBeaconInternal2;
        bCBeaconInternal2.setPeripheralIdentifier(this.getPeripheralIdentifier());
        bCBeaconInternal2.setFirstDiscoveredAt(this.getFirstDiscoveredAt());
        bCBeaconInternal2.setLastDiscoveredAt(this.getLastDiscoveredAt());
        bCBeaconInternal2.copyAdData(this.getAdData());
        bCBeaconInternal2.setDevice(this.getDevice());
        bCBeaconInternal2.setReassembledBlockData(this.getReassembledBlockData());
        bCBeaconInternal2.setProximityUUIDString(this.getProximityUUIDString());
        bCBeaconInternal2.setMajor(this.getMajor());
        bCBeaconInternal2.setMinor(this.getMinor());
        bCBeaconInternal2.setLastRangedAt(this.getLastRangedAt());
        bCBeaconInternal2.setFirstRangedAt(this.getFirstRangedAt());
        bCBeaconInternal2.setCachedAt(this.getCachedAt());
        bCBeaconInternal2.setSyncedAt(this.getSyncedAt());
        bCBeaconInternal2.setSyncStatus(this.getSyncStatus());
        bCBeaconInternal2.setAccuracy(this.getAccuracy());
        bCBeaconInternal2.setRSSI(this.getRSSI());
        bCBeaconInternal2.setProximity(this.getProximity());
        bCBeaconInternal2.setNetworkAccess(this.getNetworkAccess());
        bCBeaconInternal2.setEddystone(this.getEddystone());
        bCBeaconInternal2.setCacheIdentifier(this.getCacheIdentifier());
        bCBeaconInternal2.setFeatureBitMask(this.getFeatureBitMask());
        bCBeaconInternal2.setWireframeURLString(this.getWireframeURLString());
        bCBeaconInternal2.setMeasurements(this.getMeasurements());
        bCBeaconInternal3.setIdentifierData(this.getIdentifierData());
        return bCBeaconInternal3;
    }

    @Override
    public void copyApiPropertiesFromBeacon(BCBeacon beacon2) {
        BCBeaconInternal bCBeaconInternal;
        BCBeaconInternal bCBeaconInternal2 = this;
        bCBeaconInternal = bCBeaconInternal;
        bCBeaconInternal2.setBeaconID(bCBeaconInternal.getBeaconID());
        if (!g1.b(bCBeaconInternal2.getBeaconID())) {
            Date date;
            Date date2 = date;
            date = new Date();
            this.setSyncedAt(date2);
        }
        BCBeaconInternal bCBeaconInternal3 = this;
        this.setSerialNumber(bCBeaconInternal.getSerialNumber());
        this.setBluetoothAddress(bCBeaconInternal.getBluetoothAddress());
        this.setProximityUUIDString(bCBeaconInternal.getProximityUUIDString());
        this.setMajor(bCBeaconInternal.getMajor());
        this.setMinor(bCBeaconInternal.getMinor());
        bCBeaconInternal3.setSiteID(bCBeaconInternal.getSiteID());
        if (g1.b(bCBeaconInternal3.getSiteID())) {
            this.setSite(null);
        }
        BCBeaconInternal bCBeaconInternal4 = this;
        this.setSiteName(bCBeaconInternal.getSiteName());
        this.setTeamID(bCBeaconInternal.getTeamID());
        this.setFeatureBitMask(bCBeaconInternal.getFeatureBitMask());
        this.setEddystone(bCBeaconInternal.getEddystone());
        bCBeaconInternal4.setWireframeURLString(bCBeaconInternal.getWireframeURLString());
        bCBeaconInternal4.setMeasurements(bCBeaconInternal4.getMeasurements());
        if (bCBeaconInternal.getNetworkAccess() != null) {
            this.setNetworkAccess(bCBeaconInternal.getNetworkAccess());
        }
        if (bCBeaconInternal.getCreatedAt() != null) {
            if (this.getSyncedAt() == null) {
                BCBeaconInternal bCBeaconInternal5 = this;
                bCBeaconInternal5.setSyncedAt(new Date());
                bCBeaconInternal5.setSyncStatus(BCBeacon.BCSyncStatus.BC_SYNC_STATUS_SYNCED);
            }
            this.setName(bCBeaconInternal.getName());
            this.setPrivacyDuration(bCBeaconInternal.getPrivacyDuration());
            this.setSiteName(bCBeaconInternal.getSiteName());
            this.setCreatedAt(bCBeaconInternal.getCreatedAt());
            this.setModifiedAt(bCBeaconInternal.getModifiedAt());
            this.setBatteryStatus(bCBeaconInternal.getBatteryStatus());
            this.setBeaconLoudness(bCBeaconInternal.getBeaconLoudness());
            this.setTargetSpeed(bCBeaconInternal.getTargetSpeed());
            this.setBeaconMode(bCBeaconInternal.getBeaconMode());
            this.setBeaconRegion(bCBeaconInternal.getBeaconRegion());
            this.setCategories(bCBeaconInternal.getCategories());
            this.setCustomValues(bCBeaconInternal.getCustomValues());
            this.setMapPoint(bCBeaconInternal.getMapPoint());
            this.setVersion(bCBeaconInternal.getVersion());
            this.setPendingVersion(bCBeaconInternal.getPendingVersion());
            this.setMeasuredPowerAt1Meter(bCBeaconInternal.getMeasuredPowerAt1Meter());
            this.setFirmwareVersion(bCBeaconInternal.getFirmwareVersion());
            this.setLatestFirmwareVersion(bCBeaconInternal.getLatestFirmwareVersion());
            this.setFirmwareUID(bCBeaconInternal.getFirmwareUID());
            this.setLatestFirmwareUID(bCBeaconInternal.getLatestFirmwareUID());
            this.setModelNumber(bCBeaconInternal.getModelNumber());
            this.setUpgradableOTA(bCBeaconInternal.getUpgradableOTA());
            this.setLastKnownBatteryLevel(bCBeaconInternal.getLastKnownBatteryLevel());
        }
    }

    public boolean isSynced() {
        return this.getSyncStatus() == BCBeacon.BCSyncStatus.BC_SYNC_STATUS_SYNCED;
    }

    @Override
    public boolean isSyncedOrRestored() {
        return this.getSyncStatus() == BCBeacon.BCSyncStatus.BC_SYNC_STATUS_SYNCED || this.getSyncStatus() == BCBeacon.BCSyncStatus.BC_SYNC_STATUS_RESTORED;
    }

    public String getIBeaconKey() {
        BCBeaconInternal bCBeaconInternal = this_;
        Integer this_ = bCBeaconInternal.major;
        return a1.a(((BCBeaconApi)((Object)this_)).proximityUUID, this_, bCBeaconInternal.minor);
    }

    public boolean supportsTargetSpeedChange() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.TARGET_SPEED_CHANGEABLE);
    }

    public boolean supportsTemperatureData() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.TEMP);
    }

    public boolean supportsTwoWayDataTransfer() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.BLE_REQUEST_SUPPORTED);
    }

    public boolean supportsLegacyBLEFirmwareUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.FIRMWARE_UPDATE_BLE_LEGACY);
    }

    public boolean supportsUnencryptedBLEFirmwareUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.FIRMWARE_UPDATE_BLE_UNENCRYPTED);
    }

    public boolean supportsAES128CMACBLEFirmwareUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.FIRMWARE_UPDATE_BLE_AES128CMAC);
    }

    public boolean supportsLegacyBLESettingsUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.SETTINGS_UPDATE_BLE_LEGACY);
    }

    public boolean supportsUnencryptedBLESettingsUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.SETTINGS_UPDATE_BLE_UNENCRYPTED);
    }

    public boolean supportsAES128CMACBLESettingsUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.SETTINGS_UPDATE_BLE_AES128CMAC);
    }

    @Override
    public boolean supportsButton() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.BUTTON);
    }

    public boolean supportsTwoKeyBLESettingsUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.TWO_KEY);
    }

    public boolean supportsOneKeyBLESettingsUpdate() {
        return this.checkFeatureBitMask(BCBeaconUpdates.BCFeatureFlags.ONE_KEY);
    }

    public BCBeaconUpdates.BCAvailabilityStatus getSettingsUpdateAvailabilityStatus() {
        if (this.isDiscovered() && this.getSyncStatus() == BCBeacon.BCSyncStatus.BC_SYNC_STATUS_SYNCED) {
            if (!(this.supportsLegacyBLESettingsUpdate() || this.supportsUnencryptedBLESettingsUpdate() || this.supportsAES128CMACBLESettingsUpdate())) {
                return BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_NOT_AVAILABLE;
            }
            return BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_AVAILABLE;
        }
        return BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_NOT_DETERMINED;
    }

    public BCBeaconUpdates.BCAvailabilityStatus getFirmwareUpdateAvailabilityStatus() {
        if (this.isDiscovered() && this.getSyncStatus() == BCBeacon.BCSyncStatus.BC_SYNC_STATUS_SYNCED) {
            if (!(this.supportsLegacyBLEFirmwareUpdate() || this.supportsUnencryptedBLEFirmwareUpdate() || this.supportsAES128CMACBLEFirmwareUpdate())) {
                return BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_NOT_AVAILABLE;
            }
            return BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_AVAILABLE;
        }
        return BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_NOT_DETERMINED;
    }

    public boolean shouldUpdate() {
        Object[] objectArray = new Object[]{};
        BCLog.Log.d(TAG, "Beacon.shouldUpdate()??", objectArray);
        return this.shouldUpdateVersionCrowdSourced(false) || this.shouldUpgradeFirmware();
    }

    public boolean shouldUpdateVersionCrowdSourced(boolean crowdSourced) {
        if (((BCBeaconInternal)((Object)this_)).getSettingsUpdateAvailabilityStatus() == BCBeaconUpdates.BCAvailabilityStatus.BC_AVAILABILITY_STATUS_AVAILABLE) {
            if (((BCBeaconUpdates)((Object)this_)).getPendingVersion() != null) {
                return true;
            }
            BCBeaconInternal bCBeaconInternal = this_;
            String this_ = bCBeaconInternal.getStringFromLatestBlueCatsAdDataForKey("BC_AD_DATA_SETTINGS_VERSION_KEY");
            try {
                if (Double.parseDouble(bCBeaconInternal.version) != Double.parseDouble(this_)) {
                    return true;
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception;
                BCLog.Log.d(TAG, "shouldUpdateVersionCrowdSourced-fw020: %s", objectArray2);
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        BCBeaconInternal bCBeaconInternal;
        if (this == bCBeaconInternal) {
            return true;
        }
        if (bCBeaconInternal == null) {
            return false;
        }
        if (BCBeaconInternal.class != bCBeaconInternal.getClass()) {
            return false;
        }
        bCBeaconInternal = bCBeaconInternal;
        return !(i0.o().g().C() ? (this.id == null ? bCBeaconInternal.id != null : !this.id.equals(bCBeaconInternal.id)) : (this.mCacheIdentifier == null ? bCBeaconInternal.mCacheIdentifier != null : !this.mCacheIdentifier.equals(bCBeaconInternal.mCacheIdentifier)));
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = this.id == null ? (this.peripheralIdentifier == null ? 0 : this.peripheralIdentifier.hashCode()) : this.id.hashCode();
        return n2 + n3;
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        var1_1.writeString(this.id);
        var1_1.writeString(this.name);
        var1_1.writeString(this.teamID);
        var1_1.writeString(this.siteID);
        var1_1.writeString(this.siteName);
        var1_1.writeString(this.bluetoothAddress);
        var1_1.writeValue((Object)this.measuredPowerAt1Meter);
        var1_1.writeString(this.firmwareVersion);
        var1_1.writeString(this.latestFirmwareVersion);
        var1_1.writeString(this.firmwareUID);
        var1_1.writeString(this.latestFirmwareUID);
        var1_1.writeString(this.modelNumber);
        var1_1.writeString(this.serialNumber);
        var1_1.writeInt(this.upgradableOTA ? 1 : 0);
        var1_1.writeValue((Object)this.privacyDuration);
        var1_1.writeValue((Object)this.lastKnownBatteryLevel);
        var1_1.writeString(this.version);
        var1_1.writeString(this.pendingVersion);
        Object object = this.createdAt == null ? null : Long.valueOf(this.createdAt.getTime());
        var1_1.writeValue(object);
        object = this.modifiedAt == null ? null : Long.valueOf(this.modifiedAt.getTime());
        var1_1.writeValue(object);
        var1_1.writeValue((Object)this.featureBitmask);
        var1_1.writeParcelable((Parcelable)this.beaconRegion, (int)var2_2);
        var1_1.writeParcelable((Parcelable)this.beaconMode, (int)var2_2);
        var1_1.writeParcelable((Parcelable)this.batteryStatus, (int)var2_2);
        var1_1.writeParcelable((Parcelable)this.beaconLoudness, (int)var2_2);
        var1_1.writeParcelable((Parcelable)this.targetSpeed, (int)var2_2);
        var1_1.writeParcelable((Parcelable)this.mapPoint, (int)var2_2);
        var1_1.writeTypedArray((Parcelable[])this.categories, (int)var2_2);
        var1_1.writeTypedArray((Parcelable[])this.customValues, (int)var2_2);
        var1_1.writeString(this.peripheralIdentifier);
        object = this.firstDiscoveredAt == null ? null : Long.valueOf(this.firstDiscoveredAt.getTime());
        var1_1.writeValue(object);
        object = this.lastDiscoveredAt == null ? null : Long.valueOf(this.lastDiscoveredAt.getTime());
        var1_1.writeValue(object);
        object = this.mAdData.entrySet().iterator();
        if (object.hasNext()) {
            object = (Map.Entry)object.next();
            var1_1.writeString((String)object.getKey());
            object = (Map)object.getValue();
            if (object != null) {
                Bundle bundle;
                Object object2 = object;
                object = bundle;
                bundle = new Bundle();
                for (Map.Entry entry : object2.entrySet()) {
                    object.putString((String)entry.getKey(), (String)entry.getValue());
                }
                var1_1.writeBundle((Bundle)object);
            }
        }
        var1_1.writeString(this.proximityUUID);
        var1_1.writeValue((Object)this.major);
        var1_1.writeValue((Object)this.minor);
        object = this.lastRangedAt == null ? null : Long.valueOf(this.lastRangedAt.getTime());
        var1_1.writeValue(object);
        object = this.firstRangedAt == null ? null : Long.valueOf(this.firstRangedAt.getTime());
        var1_1.writeValue(object);
        object = this.cachedAt == null ? null : Long.valueOf(this.cachedAt.getTime());
        var1_1.writeValue(object);
        object = this.syncedAt == null ? null : Long.valueOf(this.syncedAt.getTime());
        var1_1.writeValue(object);
        var1_1.writeSerializable((Serializable)((Object)this.syncStatus));
        var1_1.writeValue((Object)this.accuracy);
        var1_1.writeValue((Object)this.rssi);
        var1_1.writeSerializable((Serializable)((Object)this.proximity));
        var1_1.writeParcelable((Parcelable)this.networkAccess, (int)var2_2);
        var1_1.writeParcelable((Parcelable)this.eddystone, (int)var2_2);
        var1_1.writeString(this.mCacheIdentifier);
        var1_1.writeString(this.wireframeUrl);
    }

    /*
     * WARNING - void declaration
     */
    public void requestDataArrayFromBeaconEndpoint(BCBeaconUpdates.BCBeaconEndpoint beaconEndpoint, List<ByteBuffer> reqDatas, BCBeaconCommandCallback cb) {
        void var3_3;
        void var2_2;
        i0.o().c().a(this, (List<ByteBuffer>)var2_2, (BCBeaconCommandCallback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void requestDataForLasso(List<ByteBuffer> reqDatas, BCBeaconCommandCallback cb) {
        void var2_2;
        void var1_1;
        i0.o().c().a(this, (List<ByteBuffer>)var1_1, 0, true, (BCBeaconCommandCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void transportDataArrayForBeacon(ByteBuffer reqDatas, BCBeaconCommandCallback cb) {
        void var2_2;
        void var1_1;
        i0.o().c().a(this, (ByteBuffer)var1_1, (BCBeaconCommandCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateSettingsInBeacon(BCBeacon beacon, BCBeaconCommandCallback cb) {
        void var2_2;
        void var1_1;
        i0.o().c().d((BCBeacon)var1_1, (BCBeaconCommandCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateFirmwareInBeacon(BCBeacon beacon, String fwVersion, BCBeaconCommandCallback cb) {
        void var3_3;
        void var2_2;
        void var1_1;
        i0.o().c().a((BCBeacon)var1_1, (String)var2_2, (BCBeaconCommandCallback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateFirmwareInBeacon(BCBeacon beacon, BCBeaconCommandCallback cb) {
        void var2_2;
        void var1_1;
        i0.o().c().c((BCBeacon)var1_1, (BCBeaconCommandCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdownInBeacon(BCBeacon beacon, BCBeaconCommandCallback cb) {
        void var2_2;
        void var1_1;
        i0.o().c().b((BCBeacon)var1_1, (BCBeaconCommandCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateBeacon(BCBeaconCallback callback) {
        void var1_1;
        super.updateBeacon((BCBeaconCallback)var1_1);
    }
}

