/*
 * Decompiled with CFR 0.152.
 */
package com.bluecats.sdk;

import com.bluecats.sdk.BCBeacon;
import com.bluecats.sdk.BCBeaconInternal;
import com.bluecats.sdk.BCCustomValue;
import com.bluecats.sdk.BCLog;

public class BCLasso {
    public static final String TAG = "BCLasso";
    public static final String BCK_LASSO_VALUE_TYPE_DEVICE_ID_KEY = "DeviceId";
    public static final String BCK_LASSO_VALUE_TYPE_TRANSACTION_KEY = "Transaction";
    public static final String BCK_LASSO_VALUE_TYPE_AMOUNT_KEY = "Amount";
    public static final String BCK_LASSO_VALUE_TYPE_CODE_KEY = "Code";
    public static final String BCK_LASSO_VALUE_TYPE_OFFER_ID_KEY = "OfferId";
    public static final String BCK_LASSO_VALUE_TYPE_DEVICE_TIME_KEY = "DeviceTime";
    public static final String BCK_LASSO_VALUE_TYPE_REFERENCE_ID_KEY = "ReferenceId";
    public static final String BCK_LASSO_VALUE_TYPE_AUX_DATA_KEY = "AuxData";
    public static final String BCK_LASSO_VALUE_TYPE_ACCOUNT_UID_KEY = "AccountHolderUID";
    public static final String BCK_LASSO_VALUE_TYPE_DIGEST_KEY = "Digest";
    public static final String BCK_LASSO_VALUE_TYPE_FUNCTION_KEY = "Function";
    public static final String BCK_LASSO_VALUE_TYPE_MESSAGE_KEY = "Message";
    public static final String BCK_LASSO_VALUE_TYPE_RESPONSE_CODE_KEY = "ResponseCode";
    public static final String BCK_LASSO_VALUE_TYPE_SEQUENCE_KEY = "Sequence";
    public static final String BCK_LASSO_VALUE_TYPE_SHARED_SECRET_KEY = "SharedSecretKey";
    public static final String BCK_OFFER_TRANSACTION_TYPE_VALUE_KEY = "Value";
    public static final String BCK_OFFER_TRANSACTION_TYPE_CODE_KEY = "Code";
    public static final String BCK_OFFER_TRANSACTION_TYPE_DISCOUNT_KEY = "Discount";
    public static final String BCK_LASSO_RESPONSE_CODE_APPROVED = "00";
    public static final byte LASSO_DATA_TYPE_ALPHA = 1;
    public static final String BCK_LASSO_CUSTOM_VALUE_REDEMPTION_RADIUS_KEY = "LassoRedemptionRadius";
    public static final double DEFAULT_REDEMPTION_RADIUS = 0.25;
    public BCBeaconInternal mBeacon;
    public Double mRedemptionRadius;

    /*
     * WARNING - void declaration
     */
    public BCLasso(BCBeacon beacon) {
        void var1_1;
        this.mBeacon = (BCBeaconInternal)var1_1;
        this.setupPropertiesFromCustomValues();
    }

    public BCBeacon getBeacon() {
        return this.mBeacon;
    }

    public void setupPropertiesFromCustomValues() {
        this_.mRedemptionRadius = 0.25;
        BCCustomValue[] bCCustomValueArray = this_.mBeacon;
        if (this_.mBeacon == null) {
            return;
        }
        for (BCCustomValue bCCustomValue : bCCustomValueArray.getCustomValues()) {
            if (!BCK_LASSO_CUSTOM_VALUE_REDEMPTION_RADIUS_KEY.equals(bCCustomValue.getKey())) continue;
            try {
                this_.mRedemptionRadius = Double.valueOf(bCCustomValue.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray = new Object[1];
                Object[] this_ = objectArray;
                objectArray[0] = BCK_LASSO_CUSTOM_VALUE_REDEMPTION_RADIUS_KEY;
                BCLog.Log.d(TAG, "custom value %s is not a valid Double value, use 0.1 by default.", this_);
            }
            return;
        }
    }

    public double getRadius() {
        if (this.mRedemptionRadius == null) {
            this.mRedemptionRadius = 0.25;
        }
        return this.mRedemptionRadius;
    }

    public static final class LassoValueType
    extends Enum<LassoValueType> {
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_DEVICE_ID;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_TRANSACTION;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_AMOUNT;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_CODE;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_OFFER_ID;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_DEVICE_TIME;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_REFERENCE_ID;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_AUX_DATA;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_ACCOUNT_HOLDER_UID;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_DIGEST;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_RESPONSE_CODE;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_MESSAGE;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_FUNCTION;
        public static final /* enum */ LassoValueType LASSO_VALUE_TYPE_SEQUENCE;
        public static final /* synthetic */ LassoValueType[] $VALUES;
        public int mValue = 0;
        public String mKey = null;

        public static LassoValueType[] values() {
            return (LassoValueType[])$VALUES.clone();
        }

        public static LassoValueType valueOf(String name) {
            String string;
            return Enum.valueOf(LassoValueType.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public LassoValueType(int i2, String keyName) {
            void var4_4;
            void var3_3;
            this.mValue = var3_3;
            this.mKey = var4_4;
        }

        static {
            LassoValueType lassoValueType;
            LASSO_VALUE_TYPE_DEVICE_ID = new LassoValueType(32, BCLasso.BCK_LASSO_VALUE_TYPE_DEVICE_ID_KEY);
            LASSO_VALUE_TYPE_TRANSACTION = new LassoValueType(33, BCLasso.BCK_LASSO_VALUE_TYPE_TRANSACTION_KEY);
            LASSO_VALUE_TYPE_AMOUNT = new LassoValueType(34, BCLasso.BCK_LASSO_VALUE_TYPE_AMOUNT_KEY);
            LASSO_VALUE_TYPE_CODE = new LassoValueType(35, "Code");
            LASSO_VALUE_TYPE_OFFER_ID = new LassoValueType(36, BCLasso.BCK_LASSO_VALUE_TYPE_OFFER_ID_KEY);
            LASSO_VALUE_TYPE_DEVICE_TIME = new LassoValueType(37, BCLasso.BCK_LASSO_VALUE_TYPE_DEVICE_TIME_KEY);
            LASSO_VALUE_TYPE_REFERENCE_ID = new LassoValueType(38, BCLasso.BCK_LASSO_VALUE_TYPE_REFERENCE_ID_KEY);
            LASSO_VALUE_TYPE_AUX_DATA = new LassoValueType(39, BCLasso.BCK_LASSO_VALUE_TYPE_AUX_DATA_KEY);
            LASSO_VALUE_TYPE_ACCOUNT_HOLDER_UID = new LassoValueType(40, BCLasso.BCK_LASSO_VALUE_TYPE_ACCOUNT_UID_KEY);
            LASSO_VALUE_TYPE_DIGEST = new LassoValueType(41, BCLasso.BCK_LASSO_VALUE_TYPE_DIGEST_KEY);
            LASSO_VALUE_TYPE_RESPONSE_CODE = new LassoValueType(42, BCLasso.BCK_LASSO_VALUE_TYPE_RESPONSE_CODE_KEY);
            LASSO_VALUE_TYPE_MESSAGE = new LassoValueType(43, BCLasso.BCK_LASSO_VALUE_TYPE_MESSAGE_KEY);
            LASSO_VALUE_TYPE_FUNCTION = new LassoValueType(4, BCLasso.BCK_LASSO_VALUE_TYPE_FUNCTION_KEY);
            LassoValueType lassoValueType2 = lassoValueType;
            LASSO_VALUE_TYPE_SEQUENCE = new LassoValueType(44, BCLasso.BCK_LASSO_VALUE_TYPE_SEQUENCE_KEY);
            $VALUES = new LassoValueType[]{LASSO_VALUE_TYPE_DEVICE_ID, LASSO_VALUE_TYPE_TRANSACTION, LASSO_VALUE_TYPE_AMOUNT, LASSO_VALUE_TYPE_CODE, LASSO_VALUE_TYPE_OFFER_ID, LASSO_VALUE_TYPE_DEVICE_TIME, LASSO_VALUE_TYPE_REFERENCE_ID, LASSO_VALUE_TYPE_AUX_DATA, LASSO_VALUE_TYPE_ACCOUNT_HOLDER_UID, LASSO_VALUE_TYPE_DIGEST, LASSO_VALUE_TYPE_RESPONSE_CODE, LASSO_VALUE_TYPE_MESSAGE, LASSO_VALUE_TYPE_FUNCTION, lassoValueType2};
        }

        public byte getByteValue() {
            return (byte)this.mValue;
        }

        public String getName() {
            return this.mKey;
        }
    }

    public static final class LassoTransactionType
    extends Enum<LassoTransactionType> {
        public static final /* enum */ LassoTransactionType LASSO_TRANSACTION_TYPE_UNKNOWN;
        public static final /* enum */ LassoTransactionType LASSO_TRANSACTION_TYPE_VALUE;
        public static final /* enum */ LassoTransactionType LASSO_TRANSACTION_TYPE_DISCOUNT;
        public static final /* enum */ LassoTransactionType LASSO_TRANSACTION_TYPE_CODE;
        public static final /* synthetic */ LassoTransactionType[] $VALUES;
        public int mValue = 0;

        public static LassoTransactionType[] values() {
            return (LassoTransactionType[])$VALUES.clone();
        }

        public static LassoTransactionType valueOf(String name) {
            String string;
            return Enum.valueOf(LassoTransactionType.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public LassoTransactionType(int i2) {
            void var3_3;
            this.mValue = var3_3;
        }

        static {
            LassoTransactionType lassoTransactionType;
            LASSO_TRANSACTION_TYPE_UNKNOWN = new LassoTransactionType(0);
            LASSO_TRANSACTION_TYPE_VALUE = new LassoTransactionType(1);
            LASSO_TRANSACTION_TYPE_DISCOUNT = new LassoTransactionType(2);
            LassoTransactionType lassoTransactionType2 = lassoTransactionType;
            LASSO_TRANSACTION_TYPE_CODE = new LassoTransactionType(3);
            $VALUES = new LassoTransactionType[]{LASSO_TRANSACTION_TYPE_UNKNOWN, LASSO_TRANSACTION_TYPE_VALUE, LASSO_TRANSACTION_TYPE_DISCOUNT, lassoTransactionType2};
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static final class LassoFunctionType
    extends Enum<LassoFunctionType> {
        public static final /* enum */ LassoFunctionType LASSO_FUNCTION_TYPE_REDEEM;
        public static final /* enum */ LassoFunctionType LASSO_FUNCTION_TYPE_QUERY;
        public static final /* enum */ LassoFunctionType LASSO_FUNCTION_TYPE_MESSAGE;
        public static final /* synthetic */ LassoFunctionType[] $VALUES;
        public int mValue = 0;

        public static LassoFunctionType[] values() {
            return (LassoFunctionType[])$VALUES.clone();
        }

        public static LassoFunctionType valueOf(String name) {
            String string;
            return Enum.valueOf(LassoFunctionType.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public LassoFunctionType(int i2) {
            void var3_3;
            this.mValue = var3_3;
        }

        static {
            LassoFunctionType lassoFunctionType;
            LASSO_FUNCTION_TYPE_REDEEM = new LassoFunctionType(1);
            LASSO_FUNCTION_TYPE_QUERY = new LassoFunctionType(2);
            LassoFunctionType lassoFunctionType2 = lassoFunctionType;
            LASSO_FUNCTION_TYPE_MESSAGE = new LassoFunctionType(3);
            $VALUES = new LassoFunctionType[]{LASSO_FUNCTION_TYPE_REDEEM, LASSO_FUNCTION_TYPE_QUERY, lassoFunctionType2};
        }

        public int getValue() {
            return this.mValue;
        }

        public byte getByteValue() {
            return (byte)this.mValue;
        }
    }
}

