/*
 * Decompiled with CFR 0.152.
 */
package com.bluecats.sdk;

import a.a.a.j1;
import android.location.Location;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.bluecats.sdk.BCBeacon;
import com.bluecats.sdk.BCBeaconInternal;
import com.bluecats.sdk.BCCategory;
import com.bluecats.sdk.BCLog;
import com.bluecats.sdk.BCMapPoint;
import com.bluecats.sdk.BCPoint;
import com.bluecats.sdk.BCSite;
import com.bluecats.sdk.BCSiteInternal;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BCMicroLocation
implements Parcelable {
    public static final String TAG = "BCMicroLocation";
    public static final Parcelable.Creator<BCMicroLocation> CREATOR = new Parcelable.Creator<BCMicroLocation>(){

        public BCMicroLocation createFromParcel(Parcel parcel) {
            return new BCMicroLocation(parcel, null);
        }

        public BCMicroLocation[] newArray(int n2) {
            return new BCMicroLocation[n2];
        }
    };
    @SerializedName(value="sites")
    public BCSiteInternal[] mSites;
    @SerializedName(value="beaconsForSiteID")
    public Map<String, BCBeaconInternal[]> mBeaconsForSiteID;
    @SerializedName(value="beacons")
    public List<BCBeacon> mAllBeacons;
    public Date mTimestamp;
    public Location mLocation;

    public BCMicroLocation() {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap this_ = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.mBeaconsForSiteID = this_;
    }

    public BCMicroLocation(Set<BCSite> sites, List<BCBeacon> beacons) {
        HashMap<String, List<BCBeaconInternal>> hashMap;
        Iterator<BCBeacon> iterator;
        HashMap<String, List<BCBeaconInternal>> hashMap2;
        BCMicroLocation bCMicroLocation = this;
        void v12 = hashMap2;
        this.mSites = v12.toArray(new BCSiteInternal[v12.size()]);
        bCMicroLocation.mAllBeacons = Collections.synchronizedList(iterator);
        bCMicroLocation.mBeaconsForSiteID = new ConcurrentHashMap<String, BCBeaconInternal[]>();
        hashMap2 = hashMap;
        hashMap = new HashMap<String, List<BCBeaconInternal>>();
        for (BCBeaconInternal bCBeaconInternal : beacons) {
            String string = bCBeaconInternal.getSite() == null ? "" : bCBeaconInternal.getSite().getSiteID();
            List list = (List)hashMap2.get(string);
            if (list == null) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList();
                hashMap2.put(string, list);
            }
            list.add(bCBeaconInternal);
        }
        this.setBeaconsForSiteID(hashMap2);
    }

    /*
     * WARNING - void declaration
     */
    private BCMapPoint determineMapPointForBeacons(List<BCBeacon> beacons) throws Exception {
        if (beacons != null) {
            void var1_3;
            if (var1_3.size() == 0) {
                return null;
            }
            if (var1_3.size() == 1) {
                return ((BCBeacon)var1_3.get(0)).getMapPoint();
            }
            int n2 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (BCBeacon bCBeacon : var1_3) {
                if (bCBeacon.getMapPoint() == null) continue;
                d2 += bCBeacon.getMapPoint().getPoint().getX().doubleValue();
                d3 += bCBeacon.getMapPoint().getPoint().getY().doubleValue();
                ++n2;
            }
            if (n2 > 0) {
                BCMapPoint bCMapPoint = new BCMapPoint();
                bCMapPoint.setMapID(((BCBeacon)var1_3.get(0)).getMapPoint().getMapID());
                double d4 = n2;
                Double d5 = d2 / d4;
                bCMapPoint.setPoint(new BCPoint(d5, d3 / d4));
                return bCMapPoint;
            }
            return null;
        }
        throw new Exception("Expected List<BCBeacon> is null");
    }

    /*
     * WARNING - void declaration
     */
    public BCMicroLocation(Parcel in) {
        void var1_1;
        BCMicroLocation bCMicroLocation = this;
        bCMicroLocation.mSites = (BCSiteInternal[])var1_1.createTypedArray(BCSiteInternal.CREATOR);
        bCMicroLocation.mBeaconsForSiteID = new ConcurrentHashMap<String, BCBeaconInternal[]>();
        Bundle bundle = in.readBundle(BCBeaconInternal.class.getClassLoader());
        for (String string : bundle.keySet()) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = bundle.getParcelableArrayList(string);
            this.mBeaconsForSiteID.put(string, arrayList2.toArray(new BCBeaconInternal[arrayList2.size()]));
        }
        this.mTimestamp = new Date(var1_1.readLong());
    }

    public /* synthetic */ BCMicroLocation(Parcel parcel, a a3) {
        this(parcel);
    }

    public List<BCSite> getSites() {
        BCSiteInternal[] this_ = this_.mSites;
        if (this_.mSites == null) {
            return null;
        }
        return Arrays.asList(this_);
    }

    /*
     * WARNING - void declaration
     */
    public void setSites(List<BCSite> value) {
        void var1_1;
        void v02 = var1_1;
        this.mSites = v02.toArray(new BCSiteInternal[v02.size()]);
    }

    public Map<String, List<BCBeacon>> getBeaconsForSiteID() {
        HashMap hashMap;
        BCMicroLocation bCMicroLocation = this_;
        HashMap this_ = hashMap;
        hashMap = new HashMap();
        for (Map.Entry<String, BCBeaconInternal[]> entry : bCMicroLocation.mBeaconsForSiteID.entrySet()) {
            this_.put(entry.getKey(), Arrays.asList((BCBeacon[])entry.getValue()));
        }
        return this_;
    }

    public void setBeaconsForSiteID(Map<String, List<BCBeaconInternal>> value) {
        HashMap<String, BCBeaconInternal[]> hashMap;
        HashMap<String, BCBeaconInternal[]> hashMap2 = hashMap;
        hashMap = new HashMap<String, BCBeaconInternal[]>();
        for (Map.Entry<String, List<BCBeaconInternal>> entry : value.entrySet()) {
            hashMap2.put(entry.getKey(), entry.getValue().toArray(new BCBeaconInternal[entry.getValue().size()]));
        }
        this.mBeaconsForSiteID = hashMap2;
    }

    public List<BCBeacon> getBeacons() {
        List<BCBeacon> list = this.mAllBeacons;
        if (list != null) {
            return list;
        }
        if (this.mBeaconsForSiteID == null) {
            return new ArrayList<BCBeacon>();
        }
        this.mAllBeacons = Collections.synchronizedList(new ArrayList());
        for (BCBeaconInternal[] bCBeaconInternalArray : this.mBeaconsForSiteID.values()) {
            this.mAllBeacons.addAll(Arrays.asList(bCBeaconInternalArray));
        }
        return this.mAllBeacons;
    }

    /*
     * WARNING - void declaration
     */
    public void setBeacons(List<BCBeacon> value) {
        void var1_1;
        this.mAllBeacons = var1_1;
    }

    public Date getTimestamp() {
        return this.mTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimestamp(Date value) {
        void var1_1;
        this.mTimestamp = var1_1;
    }

    public Location getLocation() {
        return this.mLocation;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocation(Location value) {
        void var1_1;
        this.mLocation = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public List<BCSite> getSitesWithBeaconsInProximity(BCBeacon.BCProximity proximity) {
        ArrayList<BCSite> arrayList;
        ArrayList<BCSite> arrayList2 = arrayList;
        arrayList = new ArrayList<BCSite>();
        BCSiteInternal[] bCSiteInternalArray = this.mSites;
        int n2 = this.mSites.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            Object[] objectArray = bCSiteInternalArray[i2];
            if (this.getBeaconsForSite((BCSite)objectArray, (BCBeacon.BCProximity)var1_1).size() <= 0) continue;
            try {
                arrayList2.add((BCSite)objectArray);
            }
            catch (Exception exception) {
                objectArray = new Object[]{};
                BCLog.Log.e(TAG, exception.toString(), objectArray);
            }
            continue;
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public List<BCSite> getSitesWithCategoriesInProximity(BCBeacon.BCProximity proximity) {
        ArrayList<BCSite> arrayList;
        ArrayList<BCSite> arrayList2 = arrayList;
        arrayList = new ArrayList<BCSite>();
        BCSiteInternal[] bCSiteInternalArray = this.mSites;
        int n2 = this.mSites.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            Object[] objectArray = bCSiteInternalArray[i2];
            if (this.getCategoriesForSite((BCSite)objectArray, (BCBeacon.BCProximity)var1_1).size() <= 0) continue;
            try {
                arrayList2.add((BCSite)objectArray);
            }
            catch (Exception exception) {
                objectArray = new Object[]{};
                BCLog.Log.e(TAG, exception.toString(), objectArray);
            }
            continue;
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public List<BCBeacon> getBeaconsForSite(BCSite site, BCBeacon.BCProximity proximity) throws Exception {
        if (site != null) {
            void var1_1;
            Object object = object.mBeaconsForSiteID.get(var1_1.getSiteID());
            if (object != null && (object = Arrays.asList(object)).size() > 0) {
                void var2_2;
                return j1.c(j1.a((List<BCBeacon>)object, (BCBeacon.BCProximity)var2_2), true);
            }
            return new ArrayList<BCBeacon>();
        }
        throw new Exception("Expected BCSite is null");
    }

    public List<BCCategory> getCategoriesForSite(BCSite site, BCBeacon.BCProximity proximity) throws Exception {
        if (site != null) {
            BCBeacon bCBeacon;
            Iterator iterator;
            if ((object2 = ((BCMicroLocation)object2).getBeaconsForSite((BCSite)((Object)iterator), (BCBeacon.BCProximity)((Object)bCBeacon))).size() > 0) {
                ArrayList arrayList;
                Object object = object2;
                Object object2 = arrayList;
                arrayList = new ArrayList();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    bCBeacon = (BCBeacon)iterator.next();
                    if (bCBeacon.getCategories() == null || bCBeacon.getCategories().length <= 0) continue;
                    object2.addAll(Arrays.asList(bCBeacon.getCategories()));
                }
                return object2;
            }
            return new ArrayList<BCCategory>();
        }
        throw new Exception("Expected BCSite is null");
    }

    /*
     * WARNING - void declaration
     */
    public BCMapPoint getMapPointForSite(BCSite site) throws Exception {
        if (site != null) {
            void var1_1;
            BCMicroLocation bCMicroLocation = this;
            BCMapPoint bCMapPoint = bCMicroLocation.determineMapPointForBeacons(bCMicroLocation.getBeaconsForSite((BCSite)var1_1, BCBeacon.BCProximity.BC_PROXIMITY_IMMEDIATE));
            if (bCMapPoint != null) {
                BCMicroLocation bCMicroLocation2 = this;
                bCMapPoint = bCMicroLocation2.determineMapPointForBeacons(bCMicroLocation2.getBeaconsForSite((BCSite)var1_1, BCBeacon.BCProximity.BC_PROXIMITY_NEAR));
            }
            return bCMapPoint;
        }
        throw new Exception("Expected BCSite is null");
    }

    public int hashCode() {
        int n2 = 31;
        Date date = this.mTimestamp;
        int n3 = date == null ? 0 : date.hashCode();
        return n2 + n3;
    }

    public boolean equals(Object obj) {
        Date date;
        if (this_ == date) {
            return true;
        }
        if (date == null) {
            return false;
        }
        if (BCMicroLocation.class != date.getClass()) {
            return false;
        }
        BCMicroLocation bCMicroLocation = this_;
        BCMicroLocation this_ = (BCMicroLocation)((Object)date);
        date = bCMicroLocation.mTimestamp;
        return !(date == null ? this_.mTimestamp != null : !date.equals(this_.mTimestamp));
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle;
        void var2_2;
        void var1_1;
        var1_1.writeTypedArray((Parcelable[])this.mSites, (int)var2_2);
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        for (Map.Entry<String, BCBeaconInternal[]> entry : this.mBeaconsForSiteID.entrySet()) {
            Object object = entry;
            object = Arrays.asList(object.getValue());
            bundle2.putParcelableArrayList(entry.getKey(), new ArrayList(object));
        }
        var1_1.writeBundle(bundle2);
        var1_1.writeLong(this.mTimestamp.getTime());
    }
}

