/*
 * Decompiled with CFR 0.152.
 */
package com.blueconic.browscap.impl;

import com.blueconic.browscap.BrowsCapField;
import com.blueconic.browscap.Capabilities;
import com.blueconic.browscap.ParseException;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.impl.CapabilitiesImpl;
import com.blueconic.browscap.impl.Literal;
import com.blueconic.browscap.impl.Mapper;
import com.blueconic.browscap.impl.Rule;
import com.blueconic.browscap.impl.UserAgentParserImpl;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class UserAgentFileParser {
    private final Map<String, Literal> myUniqueLiterals = new HashMap<String, Literal>();
    private final Map<Capabilities, Capabilities> myCache = new HashMap<Capabilities, Capabilities>();
    private final Map<String, String> myStrings = new HashMap<String, String>();
    private final Mapper myMapper;
    private final Set<BrowsCapField> myFields;

    UserAgentFileParser(Collection<BrowsCapField> fields) {
        this.myFields = new HashSet<BrowsCapField>(fields);
        this.myMapper = new Mapper(this.myFields);
    }

    public static UserAgentParser parse(Reader input, Collection<BrowsCapField> fields) throws IOException, ParseException {
        return new UserAgentFileParser(fields).parse(input);
    }

    private UserAgentParser parse(Reader input) throws IOException, ParseException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        CSVFormat format = CSVFormat.DEFAULT.withSkipHeaderRecord();
        try (CSVParser records = format.parse(input);){
            for (CSVRecord record : records) {
                Rule rule = this.getRule(record);
                if (rule == null) continue;
                rules.add(rule);
            }
        }
        return new UserAgentParserImpl(rules.toArray(new Rule[0]), this.getDefaultCapabilities());
    }

    Capabilities getDefaultCapabilities() {
        EnumMap<BrowsCapField, String> result = new EnumMap<BrowsCapField, String>(BrowsCapField.class);
        for (BrowsCapField field : this.myFields) {
            result.put(field, "Unknown");
        }
        return this.getCapabilities(result);
    }

    private Rule getRule(CSVRecord record) throws ParseException {
        if (record.size() <= 47) {
            return null;
        }
        String pattern = UserAgentFileParser.normalizePattern(record.get(0));
        try {
            Map<BrowsCapField, String> values = this.getBrowsCapFields(record);
            Capabilities capabilities = this.getCapabilities(values);
            Rule rule = this.createRule(pattern, capabilities);
            if (!pattern.equals(rule.getPattern())) {
                throw new ParseException("Unable to parse " + pattern);
            }
            return rule;
        }
        catch (IllegalStateException e) {
            throw new ParseException("Unable to parse " + pattern);
        }
    }

    private static String normalizePattern(String pattern) {
        String lowerCase = pattern.toLowerCase();
        if (lowerCase.contains("**")) {
            return lowerCase.replaceAll("\\*+", "*");
        }
        return lowerCase;
    }

    private Map<BrowsCapField, String> getBrowsCapFields(CSVRecord record) {
        EnumMap<BrowsCapField, String> values = new EnumMap<BrowsCapField, String>(BrowsCapField.class);
        for (BrowsCapField field : this.myFields) {
            values.put(field, this.getValue(record.get(field.getIndex())));
        }
        return values;
    }

    String getValue(String value) {
        if (value == null) {
            return "Unknown";
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return "Unknown";
        }
        String cached = this.myStrings.get(trimmed);
        if (cached != null) {
            return cached;
        }
        this.myStrings.put(trimmed, trimmed);
        return trimmed;
    }

    Capabilities getCapabilities(Map<BrowsCapField, String> values) {
        CapabilitiesImpl result = new CapabilitiesImpl(this.myMapper.getValues(values), this.myMapper);
        Capabilities fromCache = this.myCache.get(result);
        if (fromCache != null) {
            return fromCache;
        }
        this.myCache.put(result, result);
        return result;
    }

    Literal getLiteral(String value) {
        return this.myUniqueLiterals.computeIfAbsent(value, Literal::new);
    }

    Rule createRule(String pattern, Capabilities capabilities) {
        List<String> parts = UserAgentFileParser.getParts(pattern);
        if (parts.isEmpty()) {
            throw new IllegalStateException();
        }
        String first = parts.get(0);
        if (parts.size() == 1) {
            if ("*".equals(first)) {
                return this.getWildCardRule();
            }
            return new Rule(this.getLiteral(first), null, null, pattern, capabilities);
        }
        LinkedList<String> suffixes = new LinkedList<String>(parts);
        Literal prefix = null;
        if (!"*".equals(first)) {
            prefix = this.getLiteral(first);
            suffixes.remove(0);
        }
        String last = parts.get(parts.size() - 1);
        Literal postfix = null;
        if (!"*".equals(last)) {
            postfix = this.getLiteral(last);
            suffixes.removeLast();
        }
        suffixes.removeAll(Collections.singleton("*"));
        Literal[] suffixArray = new Literal[suffixes.size()];
        for (int i = 0; i < suffixArray.length; ++i) {
            suffixArray[i] = this.getLiteral(suffixes.get(i));
        }
        return new Rule(prefix, suffixArray, postfix, pattern, capabilities);
    }

    private Rule getWildCardRule() {
        EnumMap<BrowsCapField, String> fieldValues = new EnumMap<BrowsCapField, String>(BrowsCapField.class);
        for (BrowsCapField field : this.myFields) {
            if (field.isDefault()) continue;
            fieldValues.put(field, "Unknown");
        }
        Capabilities capabilities = this.getCapabilities(fieldValues);
        return new Rule(null, new Literal[0], null, "*", capabilities);
    }

    static List<String> getParts(String pattern) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder literal = new StringBuilder();
        for (char c : pattern.toCharArray()) {
            if (c == '*') {
                if (literal.length() != 0) {
                    parts.add(literal.toString());
                    literal.setLength(0);
                }
                parts.add(String.valueOf(c));
                continue;
            }
            literal.append(c);
        }
        if (literal.length() != 0) {
            parts.add(literal.toString());
            literal.setLength(0);
        }
        return parts;
    }
}

