/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.common.bigqueue;

import com.bluejeans.common.bigqueue.BigArray;
import com.bluejeans.common.bigqueue.FolderNameValidator;
import com.bluejeans.common.bigqueue.MappedPage;
import com.bluejeans.common.bigqueue.MappedPageFactory;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FanOutQueue
implements Closeable {
    public static final long EARLIEST = -1L;
    public static final long LATEST = -2L;
    final BigArray innerArray;
    static final int QUEUE_FRONT_INDEX_ITEM_LENGTH_BITS = 3;
    static final int QUEUE_FRONT_INDEX_PAGE_SIZE = 8;
    static final long QUEUE_FRONT_PAGE_INDEX = 0L;
    static final String QUEUE_FRONT_INDEX_PAGE_FOLDER_PREFIX = "front_index_";
    final ConcurrentMap<String, QueueFront> queueFrontMap = new ConcurrentHashMap<String, QueueFront>();

    public FanOutQueue(String queueDir, String queueName, int pageSize) {
        this.innerArray = new BigArray(queueDir, queueName, pageSize);
    }

    public FanOutQueue(String queueDir, String queueName) {
        this(queueDir, queueName, 0x8000000);
    }

    QueueFront getQueueFront(String fanoutId) {
        QueueFront found;
        QueueFront qf = (QueueFront)this.queueFrontMap.get(fanoutId);
        if (qf == null && (found = this.queueFrontMap.putIfAbsent(fanoutId, qf = new QueueFront(fanoutId))) != null) {
            qf.indexPageFactory.releaseCachedPages();
            qf = found;
        }
        return qf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(String fanoutId) {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            boolean bl = qf.index.get() == this.innerArray.getHeadIndex();
            return bl;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.innerArray.isEmpty();
    }

    public long enqueue(byte[] data) {
        return this.innerArray.append(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] dequeue(String fanoutId) {
        try {
            byte[] byArray;
            QueueFront qf;
            block11: {
                this.innerArray.arrayReadLock.lock();
                qf = this.getQueueFront(fanoutId);
                qf.writeLock.lock();
                if (qf.index.get() != this.innerArray.arrayHeadIndex.get()) break block11;
                byte[] byArray2 = null;
                qf.writeLock.unlock();
                return byArray2;
            }
            try {
                byte[] data = this.innerArray.get(qf.index.get());
                qf.incrementIndex();
                byArray = data;
            }
            catch (IndexOutOfBoundsException ex) {
                try {
                    ex.printStackTrace();
                    qf.resetIndex();
                    byte[] data = this.innerArray.get(qf.index.get());
                    qf.incrementIndex();
                    byte[] byArray3 = data;
                    qf.writeLock.unlock();
                    this.innerArray.arrayReadLock.unlock();
                    return byArray3;
                }
                catch (Throwable throwable) {
                    qf.writeLock.unlock();
                    throw throwable;
                }
            }
            qf.writeLock.unlock();
            return byArray;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] peek(String fanoutId) {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            if (qf.index.get() == this.innerArray.getHeadIndex()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.innerArray.get(qf.index.get());
            return byArray;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peekLength(String fanoutId) {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            if (qf.index.get() == this.innerArray.getHeadIndex()) {
                int n = -1;
                return n;
            }
            int n = this.innerArray.getItemLength(qf.index.get());
            return n;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long peekTimestamp(String fanoutId) {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            if (qf.index.get() == this.innerArray.getHeadIndex()) {
                long l = -1L;
                return l;
            }
            long l = this.innerArray.getTimestamp(qf.index.get());
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    public byte[] get(long index) {
        return this.innerArray.get(index);
    }

    public int getLength(long index) {
        return this.innerArray.getItemLength(index);
    }

    public long getTimestamp(long index) {
        return this.innerArray.getTimestamp(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBefore(long timestamp) {
        try {
            this.innerArray.arrayWriteLock.lock();
            this.innerArray.removeBefore(timestamp);
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.validateAndAdjustIndex();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limitBackFileSize(long sizeLimit) {
        try {
            this.innerArray.arrayWriteLock.lock();
            this.innerArray.limitBackFileSize(sizeLimit);
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.validateAndAdjustIndex();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    public long getBackFileSize() {
        return this.innerArray.getBackFileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findClosestIndex(long timestamp) {
        try {
            this.innerArray.arrayReadLock.lock();
            if (timestamp == -2L) {
                long l = this.innerArray.getHeadIndex();
                return l;
            }
            if (timestamp == -1L) {
                long l = this.innerArray.getTailIndex();
                return l;
            }
            long l = this.innerArray.findClosestIndex(timestamp);
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetQueueFrontIndex(String fanoutId, long index) {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            try {
                qf.writeLock.lock();
                if (index != this.innerArray.getHeadIndex()) {
                    this.innerArray.validateIndex(index);
                }
                qf.index.set(index);
                qf.persistIndex();
            }
            finally {
                qf.writeLock.unlock();
            }
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(String fanoutId) {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            long qFront = qf.index.get();
            long qRear = this.innerArray.getHeadIndex();
            if (qFront <= qRear) {
                long l = qRear - qFront;
                return l;
            }
            long l = Long.MAX_VALUE - qFront + 1L + qRear;
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    public long size() {
        return this.innerArray.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            this.innerArray.arrayReadLock.lock();
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.indexPageFactory.flush();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
            this.innerArray.flush();
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.innerArray.arrayWriteLock.lock();
            for (QueueFront qf : this.queueFrontMap.values()) {
                qf.indexPageFactory.releaseCachedPages();
            }
            this.innerArray.close();
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        try {
            this.innerArray.arrayWriteLock.lock();
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.index.set(0L);
                    qf.persistIndex();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
            this.innerArray.removeAll();
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    public long getFrontIndex() {
        return this.innerArray.getTailIndex();
    }

    public long getRearIndex() {
        return this.innerArray.getHeadIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFrontIndex(String fanoutId) {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            long l = qf.index.get();
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    class QueueFront {
        final String fanoutId;
        final AtomicLong index = new AtomicLong();
        final MappedPageFactory indexPageFactory;
        final Lock writeLock = new ReentrantLock();

        QueueFront(String fanoutId) {
            try {
                FolderNameValidator.validate(fanoutId);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("invalid fanout identifier", ex);
            }
            this.fanoutId = fanoutId;
            this.indexPageFactory = new MappedPageFactory(8, FanOutQueue.this.innerArray.arrayDirectory + FanOutQueue.QUEUE_FRONT_INDEX_PAGE_FOLDER_PREFIX + fanoutId, 10000L);
            MappedPage indexPage = this.indexPageFactory.acquirePage(0L);
            ByteBuffer indexBuffer = indexPage.getLocal(0);
            this.index.set(indexBuffer.getLong());
            this.validateAndAdjustIndex();
        }

        void validateAndAdjustIndex() {
            if (this.index.get() != FanOutQueue.this.innerArray.arrayHeadIndex.get()) {
                try {
                    FanOutQueue.this.innerArray.validateIndex(this.index.get());
                }
                catch (IndexOutOfBoundsException ex) {
                    this.resetIndex();
                }
            }
        }

        void resetIndex() {
            this.index.set(FanOutQueue.this.innerArray.arrayTailIndex.get());
            this.persistIndex();
        }

        void incrementIndex() {
            long nextIndex = this.index.get();
            nextIndex = nextIndex == Long.MAX_VALUE ? 0L : ++nextIndex;
            this.index.set(nextIndex);
            this.persistIndex();
        }

        void persistIndex() {
            MappedPage indexPage = this.indexPageFactory.acquirePage(0L);
            ByteBuffer indexBuffer = indexPage.getLocal(0);
            indexBuffer.putLong(this.index.get());
            indexPage.setDirty(true);
        }
    }
}

