/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.common.bigqueue;

import com.bluejeans.common.bigqueue.BigQueueException;
import com.bluejeans.common.bigqueue.CloseCommand;
import com.bluejeans.common.bigqueue.FileUtil;
import com.bluejeans.common.bigqueue.LRUCache;
import com.bluejeans.common.bigqueue.MappedPage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MappedPageFactory {
    private static final Logger logger = LoggerFactory.getLogger(MappedPageFactory.class);
    private final int pageSize;
    private String pageDir;
    private final File pageDirFile;
    private final String pageFile;
    private final long ttl;
    private final Object mapLock = new Object();
    private final Map<Long, Object> pageCreationLockMap = new HashMap<Long, Object>();
    public static final String PAGE_FILE_NAME = "page";
    public static final String PAGE_FILE_SUFFIX = ".dat";
    private final LRUCache<Long, MappedPage> cache;

    public MappedPageFactory(int pageSize, String pageDir, long cacheTTL) {
        this.pageSize = pageSize;
        this.pageDir = pageDir;
        this.ttl = cacheTTL;
        this.pageDirFile = new File(this.pageDir);
        if (!this.pageDirFile.exists()) {
            this.pageDirFile.mkdirs();
        }
        if (!this.pageDir.endsWith(File.separator)) {
            this.pageDir = this.pageDir + File.separator;
        }
        this.pageFile = this.pageDir + PAGE_FILE_NAME + "-";
        this.cache = new LRUCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedPage acquirePage(long index) {
        MappedPage mpi;
        block27: {
            block28: {
                mpi = this.cache.get(index);
                if (mpi != null) break block28;
                try {
                    Object lock = null;
                    Object object = this.mapLock;
                    synchronized (object) {
                        if (!this.pageCreationLockMap.containsKey(index)) {
                            this.pageCreationLockMap.put(index, new Object());
                        }
                        lock = this.pageCreationLockMap.get(index);
                    }
                    object = lock;
                    synchronized (object) {
                        mpi = this.cache.get(index);
                        if (mpi == null) {
                            RandomAccessFile raf;
                            block26: {
                                raf = null;
                                FileChannel channel = null;
                                try {
                                    String fileName = this.getFileNameByIndex(index);
                                    raf = new RandomAccessFile(fileName, "rw");
                                    channel = raf.getChannel();
                                    MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.pageSize);
                                    mpi = new MappedPage(mbb, fileName, index);
                                    this.cache.put(index, mpi, this.ttl);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Mapped page for " + fileName + " was just created and cached.");
                                    }
                                    if (channel == null) break block26;
                                }
                                catch (IOException e) {
                                    try {
                                        throw new BigQueueException(e);
                                    }
                                    catch (Throwable throwable) {
                                        if (channel != null) {
                                            CloseCommand.close(channel);
                                        }
                                        if (raf != null) {
                                            CloseCommand.close(raf);
                                        }
                                        throw throwable;
                                    }
                                }
                                CloseCommand.close(channel);
                            }
                            if (raf != null) {
                                CloseCommand.close(raf);
                            }
                            break block27;
                        }
                        break block27;
                    }
                }
                finally {
                    Object object = this.mapLock;
                    synchronized (object) {
                        this.pageCreationLockMap.remove(index);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Hit mapped page " + mpi.getPageFile() + " in cache.");
            }
        }
        return mpi;
    }

    private String getFileNameByIndex(long index) {
        return this.pageFile + index + PAGE_FILE_SUFFIX;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getPageDir() {
        return this.pageDir;
    }

    public void releasePage(long index) {
        this.cache.release(index);
    }

    public void releaseCachedPages() {
        this.cache.removeAll();
    }

    public void deleteAllPages() {
        this.cache.removeAll();
        Set<Long> indexSet = this.getExistingBackFileIndexSet();
        this.deletePages(indexSet);
        if (logger.isDebugEnabled()) {
            logger.debug("All page files in dir " + this.pageDir + " have been deleted.");
        }
    }

    public void deletePages(Set<Long> indexes) {
        if (indexes == null) {
            return;
        }
        for (long index : indexes) {
            this.deletePage(index);
        }
    }

    public void deletePage(long index) {
        this.cache.remove(index);
        String fileName = this.getFileNameByIndex(index);
        int maxRound = 10;
        boolean deleted = false;
        for (int count = 0; count < 10; ++count) {
            try {
                FileUtil.deleteFile(new File(fileName));
                deleted = true;
                break;
            }
            catch (IllegalStateException ex) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!logger.isDebugEnabled()) continue;
                logger.warn("fail to delete file " + fileName + ", tried round = " + count);
                continue;
            }
        }
        if (deleted) {
            logger.info("Page file " + fileName + " was just deleted.");
        } else {
            logger.warn("fail to delete file " + fileName + " after max " + 10 + " rounds of try, you may delete it manually.");
        }
    }

    public Set<Long> getPageIndexSetBefore(long timestamp) {
        HashSet<Long> beforeIndexSet = new HashSet<Long>();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName;
                if (pageFile.lastModified() >= timestamp || !(fileName = pageFile.getName()).endsWith(PAGE_FILE_SUFFIX)) continue;
                long index = this.getIndexByFileName(fileName);
                beforeIndexSet.add(index);
            }
        }
        return beforeIndexSet;
    }

    private long getIndexByFileName(String fileName) {
        int beginIndex = fileName.lastIndexOf(45);
        int endIndex = fileName.lastIndexOf(PAGE_FILE_SUFFIX);
        String sIndex = fileName.substring(++beginIndex, endIndex);
        long index = Long.parseLong(sIndex);
        return index;
    }

    public void deletePagesBefore(long timestamp) {
        Set<Long> indexSet = this.getPageIndexSetBefore(timestamp);
        this.deletePages(indexSet);
        if (logger.isDebugEnabled()) {
            logger.debug("All page files in dir [" + this.pageDir + "], before [" + timestamp + "] have been deleted.");
        }
    }

    public void deletePagesBeforePageIndex(long pageIndex) {
        Set<Long> indexSet = this.getExistingBackFileIndexSet();
        for (Long index : indexSet) {
            if (index >= pageIndex) continue;
            this.deletePage(index);
        }
    }

    public Set<Long> getExistingBackFileIndexSet() {
        HashSet<Long> indexSet = new HashSet<Long>();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith(PAGE_FILE_SUFFIX)) continue;
                long index = this.getIndexByFileName(fileName);
                indexSet.add(index);
            }
        }
        return indexSet;
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    int getLockMapSize() {
        return this.pageCreationLockMap.size();
    }

    public long getPageFileLastModifiedTime(long index) {
        String pageFileName = this.getFileNameByIndex(index);
        File pageFile = new File(pageFileName);
        if (!pageFile.exists()) {
            return -1L;
        }
        return pageFile.lastModified();
    }

    public long getFirstPageIndexBefore(long timestamp) {
        Set<Long> beforeIndexSet = this.getPageIndexSetBefore(timestamp);
        if (beforeIndexSet.size() == 0) {
            return -1L;
        }
        TreeSet<Long> sortedIndexSet = new TreeSet<Long>(beforeIndexSet);
        Long largestIndex = sortedIndexSet.last();
        if (largestIndex != Long.MAX_VALUE) {
            return largestIndex;
        }
        Long next = 0L;
        while (sortedIndexSet.contains(next)) {
            Long l = next;
            Long l2 = next = Long.valueOf(next + 1L);
        }
        if (next == 0L) {
            return Long.MAX_VALUE;
        }
        next = next - 1L;
        return next;
    }

    public void flush() {
        Collection<MappedPage> cachedPages = this.cache.getValues();
        for (MappedPage mappedPage : cachedPages) {
            mappedPage.flush();
        }
    }

    public Set<String> getBackPageFileSet() {
        HashSet<String> fileSet = new HashSet<String>();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith(PAGE_FILE_SUFFIX)) continue;
                fileSet.add(fileName);
            }
        }
        return fileSet;
    }

    public long getBackPageFileSize() {
        long totalSize = 0L;
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith(PAGE_FILE_SUFFIX)) continue;
                totalSize += pageFile.length();
            }
        }
        return totalSize;
    }
}

