/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils.ipc;

import com.bluejeans.utils.EnumCounter;
import com.bluejeans.utils.MetaUtil;
import com.bluejeans.utils.ipc.IPCChannel;
import com.bluejeans.utils.ipc.IPCEventType;
import com.bluejeans.utils.ipc.IPCHandler;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IPCBasicChannel
implements IPCChannel {
    private static final Logger logger = LoggerFactory.getLogger(IPCBasicChannel.class);
    private final String channelId = UUID.randomUUID().toString();
    private final ObjectMapper mapper = new ObjectMapper();
    private List<IPCHandler> handlers = new ArrayList<IPCHandler>();
    private boolean sendToMyself = false;
    private final EnumCounter<IPCEventType> messageCounts = new EnumCounter(IPCEventType.class);

    @Override
    public void addHandler(IPCHandler handler) {
        this.handlers.add(handler);
    }

    public void handleMessage(String message) {
        try {
            JsonNode event = this.mapper.readTree(message);
            if (this.sendToMyself || !this.channelId.equals(event.get("senderUuid").asText())) {
                this.messageCounts.incrementEventCount((Enum)IPCEventType.MESSAGE_PROCESSED);
                for (IPCHandler handler : this.handlers) {
                    try {
                        handler.handleMessage(event);
                    }
                    catch (RuntimeException re) {
                        logger.error("Problem in handler - " + handler, (Throwable)re);
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.error("Problem in parsing the JSON message", (Throwable)ex);
        }
    }

    @Override
    public void sendCommand(String command, String application, String entity, Object ... params) {
        this.sendCommand(command, application, entity, MetaUtil.createParamMap((Object[])params));
    }

    @Override
    public void sendCommand(String command, String application, String entity, Map<String, Object> params) {
        ObjectNode dataNode = this.mapper.createObjectNode();
        dataNode.put("command", command);
        dataNode.put("application", application);
        dataNode.put("entity", entity);
        dataNode.put("event", "__COMMAND");
        ObjectNode paramsNode = dataNode.putObject("params");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramsNode.set(entry.getKey(), this.mapper.valueToTree(entry.getValue()));
        }
        this.produceMessage((JsonNode)dataNode);
    }

    @Override
    public void produceMessage(JsonNode ipcEvent) {
        ObjectNode dataNode = null;
        if (ipcEvent.isObject()) {
            dataNode = (ObjectNode)ipcEvent;
        } else {
            dataNode = this.mapper.createObjectNode();
            dataNode.set("data", ipcEvent);
        }
        dataNode.put("senderUuid", this.channelId);
        this.produceMessage(dataNode.toString());
    }

    public String getChannelId() {
        return this.channelId;
    }

    public List<IPCHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<IPCHandler> handlers) {
        this.handlers = handlers;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public EnumCounter<IPCEventType> getMessageCounts() {
        return this.messageCounts;
    }

    public boolean isSendToMyself() {
        return this.sendToMyself;
    }

    public void setSendToMyself(boolean sendToMyself) {
        this.sendToMyself = sendToMyself;
    }
}

