/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils.ipc;

import com.bluejeans.utils.MetaUtil;
import com.bluejeans.utils.ipc.IPCHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IPCBasicHandler
implements IPCHandler {
    private final Logger logger = LoggerFactory.getLogger(IPCBasicHandler.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void handleMessage(String message) {
        try {
            this.handleMessage(this.mapper.readTree(message));
        }
        catch (IOException ex) {
            this.logger.error("Problem parsing from JSON", (Throwable)ex);
        }
    }

    @Override
    public void handleMessage(JsonNode ipcEvent) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        Iterator iter = ipcEvent.get("params").fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            try {
                paramsMap.put((String)entry.getKey(), this.mapper.treeToValue((TreeNode)entry.getValue(), Object.class));
            }
            catch (JsonProcessingException ex) {
                this.logger.warn("Problem in reading this value - " + entry.getValue(), (Throwable)ex);
            }
        }
        this.handleCommand(ipcEvent.get("command").asText(), ipcEvent.get("application").asText(), ipcEvent.get("entity").asText(), paramsMap);
    }

    @Override
    public void handleCommand(String command, String application, String entity, Object ... params) {
        this.handleCommand(command, application, entity, MetaUtil.createParamMap((Object[])params));
    }
}

