/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils.ipc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class IPCEvent {
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String EVENT_TYPE = "__COMMAND";
    private String event = "__COMMAND";
    private String senderUuid;
    private String command;
    private String application;
    private String entity;
    private Map<String, Object> params;

    public static IPCEvent valueOf(String eventStr) {
        try {
            return (IPCEvent)mapper.readValue(eventStr, IPCEvent.class);
        }
        catch (IOException e) {
            return new IPCEvent();
        }
    }

    public IPCEvent() {
        this.params = new HashMap<String, Object>();
    }

    public IPCEvent(String senderUuid, String command, String application, String entity, Map<String, Object> params) {
        this.senderUuid = senderUuid;
        this.command = command;
        this.application = application;
        this.entity = entity;
        this.params = params;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getSenderUuid() {
        return this.senderUuid;
    }

    public void setSenderUuid(String senderUuid) {
        this.senderUuid = senderUuid;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

