/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils.ipc.impl;

import com.bluejeans.kafka.KafkaProcessorContext;
import com.bluejeans.kafka.KafkaRecordProcessor;
import com.bluejeans.kafka.SimpleKafkaProducer;
import com.bluejeans.utils.ipc.IPCBasicChannel;
import com.bluejeans.utils.ipc.IPCEventType;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class KafkaIPCChannel
extends IPCBasicChannel
implements KafkaRecordProcessor<String, String> {
    private SimpleKafkaProducer<String, String> kafkaProducer;
    private String topicName;
    private String routingKey = "";

    @Override
    public void produceMessage(String message) {
        this.getMessageCounts().incrementEventCount((Enum)IPCEventType.MESSAGE_SENT);
        this.kafkaProducer.send(this.topicName, (Object)this.routingKey, (Object)message);
    }

    public void processKafkaRecord(ConsumerRecord<String, String> record, KafkaProcessorContext<String, String> context) {
        this.getMessageCounts().incrementEventCount((Enum)IPCEventType.MESSAGE_RECIEVED);
        this.handleMessage((String)record.value());
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public SimpleKafkaProducer<String, String> getKafkaProducer() {
        return this.kafkaProducer;
    }

    public void setKafkaProducer(SimpleKafkaProducer<String, String> kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
}

