/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils.ipc.impl;

import com.bluejeans.utils.ipc.IPCBasicChannel;
import com.bluejeans.utils.ipc.IPCEventType;
import java.nio.charset.Charset;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;

public class RabbitIPCChannel
extends IPCBasicChannel
implements MessageListener {
    private AmqpTemplate amqpTemplate;
    private String exchangeName;
    private String routingKey = "";
    private final MessageProperties emptyProperties = MessagePropertiesBuilder.newInstance().build();

    @Override
    public void produceMessage(String message) {
        this.getMessageCounts().incrementEventCount((Enum)IPCEventType.MESSAGE_SENT);
        this.amqpTemplate.send(this.exchangeName, this.routingKey, new Message(message.toString().getBytes(Charset.defaultCharset()), this.emptyProperties));
    }

    public void onMessage(Message message) {
        this.getMessageCounts().incrementEventCount((Enum)IPCEventType.MESSAGE_RECIEVED);
        this.handleMessage(new String(message.getBody()));
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public AmqpTemplate getAmqpTemplate() {
        return this.amqpTemplate;
    }

    public void setAmqpTemplate(AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }
}

