/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;

public class BigQueue<E>
extends com.bluejeans.bigqueue.BigQueue {
    private Class<E> entityType;
    private E dummyElement;

    public BigQueue(String queueDir, String queueName, int pageSize) {
        super(queueDir, queueName, pageSize);
    }

    public BigQueue(String queueDir, String queueName) {
        super(queueDir, queueName);
    }

    public BigQueue(String queueDir, String queueName, int pageSize, Class<E> entityType) {
        super(queueDir, queueName, pageSize);
        this.entityType = entityType;
    }

    public BigQueue(String queueDir, String queueName, Class<E> entityType) {
        super(queueDir, queueName);
        this.entityType = entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(E element) {
        if (this.entityType == null) {
            BigQueue bigQueue = this;
            synchronized (bigQueue) {
                if (this.entityType == null) {
                    this.entityType = element.getClass();
                }
            }
        }
        if (this.entityType.equals(byte[].class)) {
            this.enqueue((byte[])element);
        } else if (this.entityType.equals(String.class)) {
            this.enqueue(((String)element).getBytes());
        } else {
            this.enqueue(SerializationUtils.serialize((Serializable)((Serializable)element)));
        }
    }

    public E pop() {
        return this.element(this.dequeue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E element(byte[] data) {
        if (data != null) {
            if (this.entityType == null) {
                BigQueue bigQueue = this;
                synchronized (bigQueue) {
                    if (this.entityType == null) {
                        try {
                            this.entityType = SerializationUtils.deserialize((byte[])data).getClass();
                        }
                        catch (Exception ex) {
                            try {
                                this.entityType = String.class;
                            }
                            catch (Exception ex1) {
                                try {
                                    this.entityType = byte[].class;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            if (this.entityType.equals(byte[].class)) {
                return (E)data;
            }
            if (this.entityType.equals(String.class)) {
                return (E)new String(data);
            }
            try {
                return (E)SerializationUtils.deserialize((byte[])data);
            }
            catch (Exception ex) {
                return this.dummyElement;
            }
        }
        return null;
    }

    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        List elements = this.dequeueMulti(maxElements);
        for (byte[] data : elements) {
            E el = this.element(data);
            if (el == null) continue;
            c.add(el);
        }
        return elements.size();
    }

    public int peekTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        List elements = this.peekMulti(maxElements);
        for (byte[] data : elements) {
            E el = this.element(data);
            if (el == null) continue;
            c.add(el);
        }
        return elements.size();
    }

    public Class<E> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<E> entityType) {
        this.entityType = entityType;
    }

    public E getDummyElement() {
        return this.dummyElement;
    }

    public void setDummyElement(E dummyElement) {
        this.dummyElement = dummyElement;
    }
}

