/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import com.bluejeans.utils.BigQueue;
import com.bluejeans.utils.EnumCounter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkOperationUtil<E> {
    private static Logger logger = LoggerFactory.getLogger(BulkOperationUtil.class);
    private final BlockingQueue<E> queue;
    private BigQueue<E> bigQueue;
    private boolean fileBased;
    private boolean peekEnabled;
    private boolean waitEnabled;
    private final String queueDir;
    private final String queueName;
    private final long bigQueueTimerInterval;
    private final Timer bigQueueTimer = new Timer();
    private final long bulkPollInterval;
    private final BulkOperation<E> bulkOperation;
    private final Doer doer;
    private int batchSize;
    private int minBatchSize = 100;
    private final int bulkExecutorSize;
    private final int bulkExecutorQueueCapacity;
    private final ThreadPoolExecutor bulkExecutor;
    private final Runnable bulkRunnable = new Runnable(){

        @Override
        public void run() {
            BulkOperationUtil.this.doBulk();
        }
    };
    private final AtomicLong queueAddFailCount;
    private final EnumCounter<BulkStatus> bulkStatusCounter = new EnumCounter<BulkStatus>(BulkStatus.class);
    private boolean stopped = false;
    private boolean parallel = false;
    private boolean bulkRetryEnabled = true;
    private int bulkRetryCount = 0x7FFFFFFE;
    private Class<E> entityType;
    private E dummyElement;

    private BulkOperationUtil(int bulkPollIntervalSecs, int capacity, String queueDir, String queueName, long bigQueueTimerInterval, BulkOperation<E> bulkOperation, int batchSize, int bulkExecutorSize, int bulkExecutorQueueCapacity) {
        this.bulkPollInterval = bulkPollIntervalSecs * 1000;
        this.queue = new LinkedBlockingQueue(capacity);
        this.bulkOperation = bulkOperation;
        this.batchSize = batchSize;
        this.bulkExecutorSize = bulkExecutorSize;
        this.bulkExecutorQueueCapacity = bulkExecutorQueueCapacity;
        this.doer = new Doer();
        this.queueAddFailCount = new AtomicLong();
        this.bulkExecutor = new ThreadPoolExecutor(bulkExecutorSize, bulkExecutorSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(bulkExecutorQueueCapacity), new ThreadPoolExecutor.CallerRunsPolicy());
        this.queueDir = queueDir;
        this.queueName = queueName;
        this.bigQueueTimerInterval = bigQueueTimerInterval;
        if (queueDir != null) {
            try {
                this.bigQueue = new BigQueue(this.queueDir, this.queueName, 0x2000000);
                this.bigQueueTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        BulkOperationUtil.this.bigQueue.gc();
                    }
                }, 0L, bigQueueTimerInterval);
            }
            catch (RuntimeException rex) {
                logger.warn("Problem creating big queue", (Throwable)rex);
            }
        }
    }

    public static <E> BulkOperationUtil<E> create(int bulkPollInterval, int capacity, String queueDir, String queueName, long bigQueueTimerInterval, BulkOperation<E> bulkOperation, int batchSize, int bulkExecutorSize, int bulkExecutorQueueCapacity, boolean start) {
        BulkOperationUtil<E> bulkOperationUtil = new BulkOperationUtil<E>(bulkPollInterval, capacity, queueDir, queueName, bigQueueTimerInterval, bulkOperation, batchSize, bulkExecutorSize, bulkExecutorQueueCapacity);
        if (start) {
            bulkOperationUtil.doer.start();
        }
        return bulkOperationUtil;
    }

    public static <E> BulkOperationUtil<E> create(int bulkPollInterval, int capacity, String queueDir, String queueName, long bigQueueTimerInterval, BulkOperation<E> bulkOperation, int batchSize, int bulkExecutorSize, int bulkExecutorQueueCapacity) {
        return BulkOperationUtil.create(bulkPollInterval, capacity, queueDir, queueName, bigQueueTimerInterval, bulkOperation, batchSize, bulkExecutorSize, bulkExecutorQueueCapacity, true);
    }

    public static <E> BulkOperationUtil<E> create(int bulkPollInterval, int capacity, BulkOperation<E> bulkOperation, int batchSize, int bulkExecutorSize, int bulkExecutorQueueCapacity) {
        return BulkOperationUtil.create(bulkPollInterval, capacity, null, null, 300000L, bulkOperation, batchSize, bulkExecutorSize, bulkExecutorQueueCapacity);
    }

    public static <E> BulkOperationUtil<E> create(int bulkPollInterval, int capacity, BulkOperation<E> bulkOperation) {
        return BulkOperationUtil.create(bulkPollInterval, capacity, null, null, 300000L, bulkOperation, 1000, 1, 1);
    }

    private boolean bulkInternal(Collection<E> coll) {
        boolean success = false;
        if (this.bulkRetryEnabled) {
            int retryCount = 0;
            do {
                try {
                    this.bulkOperation.doBulk(coll);
                    success = true;
                }
                catch (NullPointerException npe) {
                    success = true;
                    this.bulkStatusCounter.incrementEventCount(BulkStatus.INTERNAL_ERROR);
                    logger.error("Internal Error", (Throwable)npe);
                }
                catch (RuntimeException ex) {
                    this.bulkStatusCounter.incrementEventCount(BulkStatus.DO_BULK_ERROR);
                    logger.error("Error in bulk operation {}", (Throwable)ex);
                }
            } while (!success && ++retryCount <= this.bulkRetryCount);
        } else {
            try {
                this.bulkOperation.doBulk(coll);
                success = true;
            }
            catch (RuntimeException ex) {
                this.bulkStatusCounter.incrementEventCount(BulkStatus.DO_BULK_ERROR);
                logger.error("Error in bulk operation {}", (Throwable)ex);
            }
        }
        return success;
    }

    public void doBulk() {
        LinkedList coll = Lists.newLinkedList();
        if (this.bigQueue == null) {
            this.queue.drainTo(coll, this.batchSize);
            if (!coll.isEmpty()) {
                this.bulkInternal(coll);
            }
        } else if (this.peekEnabled) {
            int peeked = 0;
            if (this.fileBased) {
                if (this.queue.size() > 0) {
                    this.queue.drainTo(coll, this.batchSize);
                }
                if (this.bigQueue.size() > 0L) {
                    peeked = this.bigQueue.peekTo(coll, this.batchSize - coll.size());
                }
            } else {
                if (this.bigQueue.size() > 0L) {
                    peeked = this.bigQueue.peekTo(coll, this.batchSize);
                }
                if (this.queue.size() > 0) {
                    this.queue.drainTo(coll, this.batchSize - coll.size());
                }
            }
            if (!coll.isEmpty() && this.bulkInternal(coll)) {
                this.bigQueue.dequeueMulti(peeked);
            }
        } else {
            if (this.fileBased) {
                if (this.queue.size() > 0) {
                    this.queue.drainTo(coll, this.batchSize);
                }
                if (this.bigQueue.size() > 0L) {
                    this.bigQueue.drainTo(coll, this.batchSize - coll.size());
                }
            } else {
                if (this.bigQueue.size() > 0L) {
                    this.bigQueue.drainTo(coll, this.batchSize);
                }
                if (this.queue.size() > 0) {
                    this.queue.drainTo(coll, this.batchSize - coll.size());
                }
            }
            if (!coll.isEmpty()) {
                this.bulkInternal(coll);
            }
        }
    }

    public long getQueueSize() {
        if (this.fileBased && this.bigQueue != null) {
            return this.bigQueue.size();
        }
        return this.queue.size();
    }

    public void add(E e) {
        if (this.fileBased && this.bigQueue != null) {
            this.bigQueue.push(e);
            this.bulkStatusCounter.incrementEventCount(BulkStatus.QUEUE_ADD);
        } else {
            boolean inserted = false;
            if (this.waitEnabled) {
                try {
                    this.queue.put(e);
                    inserted = true;
                }
                catch (InterruptedException e1) {
                    inserted = false;
                }
            } else {
                inserted = this.queue.offer(e);
            }
            if (inserted) {
                this.bulkStatusCounter.incrementEventCount(BulkStatus.QUEUE_ADD);
            } else {
                this.queueAddFailCount.incrementAndGet();
                logger.error("Failed to insert into queue", e);
            }
        }
    }

    public void start() {
        this.doer.start();
    }

    public void stop() {
        this.stopped = true;
        if (this.bigQueue != null) {
            this.bigQueueTimer.cancel();
            this.bigQueue.gc();
            try {
                this.bigQueue.close();
            }
            catch (IOException ioe) {
                logger.warn("Problem closing big queue", (Throwable)ioe);
            }
        }
    }

    public BlockingQueue<E> getQueue() {
        return this.queue;
    }

    public BigQueue<E> getBigQueue() {
        return this.bigQueue;
    }

    public boolean isFileBased() {
        return this.fileBased;
    }

    public void setFileBased(boolean fileBased) {
        this.fileBased = fileBased;
    }

    public boolean isPeekEnabled() {
        return this.peekEnabled;
    }

    public void setPeekEnabled(boolean peekEnabled) {
        this.peekEnabled = peekEnabled;
    }

    public boolean isWaitEnabled() {
        return this.waitEnabled;
    }

    public void setWaitEnabled(boolean waitEnabled) {
        this.waitEnabled = waitEnabled;
    }

    public String getQueueDir() {
        return this.queueDir;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public long getBigQueueTimerInterval() {
        return this.bigQueueTimerInterval;
    }

    public Timer getBigQueueTimer() {
        return this.bigQueueTimer;
    }

    public long getBulkPollInterval() {
        return this.bulkPollInterval;
    }

    public BulkOperation<E> getBulkOperation() {
        return this.bulkOperation;
    }

    public Doer getDoer() {
        return this.doer;
    }

    public AtomicLong getQueueAddFailCount() {
        return this.queueAddFailCount;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBulkExecutorSize() {
        return this.bulkExecutorSize;
    }

    public int getBulkExecutorQueueCapacity() {
        return this.bulkExecutorQueueCapacity;
    }

    public ThreadPoolExecutor getBulkExecutor() {
        return this.bulkExecutor;
    }

    public Runnable getBulkRunnable() {
        return this.bulkRunnable;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public int getMinBatchSize() {
        return this.minBatchSize;
    }

    public void setMinBatchSize(int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    public boolean isBulkRetryEnabled() {
        return this.bulkRetryEnabled;
    }

    public void setBulkRetryEnabled(boolean bulkRetryEnabled) {
        this.bulkRetryEnabled = bulkRetryEnabled;
    }

    public int getBulkRetryCount() {
        return this.bulkRetryCount;
    }

    public void setBulkRetryCount(int bulkRetryCount) {
        this.bulkRetryCount = bulkRetryCount;
    }

    public EnumCounter<BulkStatus> getBulkStatusCounter() {
        return this.bulkStatusCounter;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<E> entityType) {
        this.entityType = entityType;
    }

    public void entityTypeIs(Class<E> entityType) {
        this.entityType = entityType;
        if (this.bigQueue != null) {
            this.bigQueue.setEntityType(entityType);
        }
    }

    public E getDummyElement() {
        return this.dummyElement;
    }

    public void setDummyElement(E dummyElement) {
        this.dummyElement = dummyElement;
    }

    public void dummyElementIs(E el) {
        this.dummyElement = el;
        if (this.bigQueue != null) {
            this.bigQueue.setDummyElement(el);
        }
    }

    private class Doer
    extends Thread {
        public Doer() {
            this.setName("bulk-operation-worker");
        }

        @Override
        public void run() {
            while (true) {
                if (BulkOperationUtil.this.stopped) {
                    if (BulkOperationUtil.this.getQueueSize() == 0L) break;
                    logger.warn("DO NOT KILL, WILL STOP AFTER PROCESSING " + BulkOperationUtil.this.queue.size() + " MESSAGES");
                }
                if (BulkOperationUtil.this.parallel) {
                    BulkOperationUtil.this.bulkExecutor.execute(BulkOperationUtil.this.bulkRunnable);
                } else {
                    BulkOperationUtil.this.doBulk();
                }
                try {
                    if (BulkOperationUtil.this.getQueueSize() >= (long)BulkOperationUtil.this.minBatchSize || BulkOperationUtil.this.stopped) continue;
                    Doer.sleep(BulkOperationUtil.this.bulkPollInterval);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            logger.warn("STOPPED");
        }
    }

    public static interface BulkOperation<E> {
        public void doBulk(Collection<E> var1);
    }

    public static enum BulkStatus {
        DO_BULK_ERROR,
        INTERNAL_ERROR,
        QUEUE_ADD;

    }
}

