/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import java.util.Date;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.helpers.ISO8601DateFormat;

public class EnumCounter<E extends Enum<E>> {
    private final EventCountMap eventCounts;
    private final EventCountMap secEventCounts;
    private long _lut = System.currentTimeMillis();

    public EnumCounter(Class<E> keyType) {
        this.eventCounts = new EventCountMap(keyType);
        this.secEventCounts = new EventCountMap(keyType);
        try {
            for (Enum type : (Enum[])keyType.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                this.eventCounts.put(type, new AtomicLong());
                this.secEventCounts.put(type, new AtomicLong());
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void reset() {
        for (Object key : this.eventCounts.keySet()) {
            this.eventCounts.get(key).set(0L);
        }
        for (Object key : this.secEventCounts.keySet()) {
            this.secEventCounts.get(key).set(0L);
        }
    }

    public void resetSecEventCounts() {
        for (Object key : this.secEventCounts.keySet()) {
            this.secEventCounts.get(key).set(0L);
        }
    }

    public EventCountMap getEventCounts() {
        return this.eventCounts;
    }

    public EventCountMap getSecEventCounts() {
        return this.secEventCounts;
    }

    public long getValue(String event) {
        return this.eventCounts.getValue(event);
    }

    public void incrementEventCount(E event) {
        this.incrementEventCount(event, 1);
    }

    public void incrementEventCount(E event, int count) {
        this.eventCounts.get(event).addAndGet(count);
        this.secEventCounts.get(event).addAndGet(count);
        this._lut = System.currentTimeMillis();
    }

    public String getLastUpdated() {
        return ISO8601DateFormat.getDateTimeInstance().format(new Date(this._lut));
    }

    public class EventCountMap
    extends EnumMap<E, AtomicLong> {
        private static final long serialVersionUID = -6906468090357760718L;
        private final Class<E> keyType;
        private boolean autoCreateValue;

        public EventCountMap(Class<E> keyType) {
            super(keyType);
            this.autoCreateValue = false;
            this.keyType = keyType;
        }

        public boolean isAutoCreateValue() {
            return this.autoCreateValue;
        }

        public void setAutoCreateValue(boolean autoCreateValue) {
            this.autoCreateValue = autoCreateValue;
        }

        @Override
        public AtomicLong get(Object key) {
            AtomicLong value = (AtomicLong)super.get(key);
            if (value == null && this.autoCreateValue) {
                value = this.getS(key);
            }
            return value;
        }

        public synchronized AtomicLong getS(Object key) {
            return this.getN(key);
        }

        public AtomicLong getN(Object key) {
            AtomicLong value = (AtomicLong)super.get(key);
            if (value == null && this.autoCreateValue) {
                value = new AtomicLong();
                this.put(this.getEnum(key.toString()), value);
            }
            return value;
        }

        public AtomicLong getO(Object key) {
            return (AtomicLong)super.get(key);
        }

        public E getEnum(String enumString) {
            return Enum.valueOf(this.keyType, enumString);
        }

        public long getValue(String event) {
            return this.getO(this.getEnum(event)).get();
        }
    }
}

