/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import com.bluejeans.utils.MetaUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.apache.commons.lang.ClassUtils;

public interface InvokerMXBean {
    public String printThis(String var1, String ... var2);

    public static class Invoker
    implements InvokerMXBean {
        public Invoker() {
            try {
                MetaUtil.registerAsMBean(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object runThis(String name, String ... args) throws Exception {
            int len = 0;
            if (args != null) {
                len = args.length;
            }
            Object[] invokeArgs = new Object[len];
            Method method = MetaUtil.findFirstMethod(this.getClass(), name, len);
            for (int index = 0; index < len; ++index) {
                Class paramType = method.getParameterTypes()[index];
                try {
                    if (paramType.isPrimitive()) {
                        paramType = ClassUtils.primitiveToWrapper(paramType);
                    }
                    invokeArgs[index] = paramType.getMethod("valueOf", String.class).invoke(null, args[index]);
                    continue;
                }
                catch (NoSuchMethodException nsme) {
                    invokeArgs[index] = paramType.getConstructor(String.class).newInstance(args[index]);
                }
            }
            return method.invoke((Object)this, invokeArgs);
        }

        @Override
        public String printThis(String name, String ... args) {
            StringBuilder val = new StringBuilder();
            try {
                Object result = this.runThis(name, args);
                if (result.getClass().isArray()) {
                    for (int index = 0; index < Array.getLength(result); ++index) {
                        val.append(Array.get(result, index));
                        val.append("\n");
                    }
                } else {
                    val.append(this.runThis(name, args));
                }
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                val.append(sw);
            }
            return val.toString();
        }
    }
}

