/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import com.bluejeans.utils.URIInvoker;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.strobel.decompiler.Decompiler;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.rmi.registry.LocateRegistry;
import java.security.GeneralSecurityException;
import java.security.ProtectionDomain;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.owasp.encoder.esapi.ESAPIEncoder;

public class MetaUtil {
    public static final Map<String, Object> META_MAP = new HashMap<String, Object>();
    public static final List<Class<?>> SIMPLE_RETURN_TYPE_LIST = new ArrayList<Class>(Arrays.asList(Boolean.TYPE, Boolean.class, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Double.TYPE, Double.class, Float.class, Float.TYPE, String.class));

    public static Map<String, Object> createParamMap(Object ... params) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (params.length > 1) {
            for (int index = 0; index < params.length; index += 2) {
                paramMap.put(params[index].toString(), params[index + 1]);
            }
        }
        return paramMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String resourceName) {
        InputStream resourceStream = null;
        try {
            resourceStream = MetaUtil.class.getResourceAsStream(resourceName);
            String string = IOUtils.toString((InputStream)resourceStream);
            return string;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (resourceStream != null) {
                try {
                    resourceStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] getResourceAsBytes(String resourceName) {
        return MetaUtil.getResourceAsBytes(MetaUtil.class, resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsBytes(Class<?> loader, String resourceName) {
        InputStream resourceStream = null;
        try {
            resourceStream = loader.getResourceAsStream(resourceName);
            byte[] byArray = IOUtils.toByteArray((InputStream)resourceStream);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (resourceStream != null) {
                try {
                    resourceStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void registerAsMBean(Object bean) throws JMException {
        try {
            MetaUtil.registerAsMBean(bean, bean.getClass().getPackage().getName() + ":type=" + bean.getClass().getSimpleName());
        }
        catch (InstanceAlreadyExistsException iaex) {
            MetaUtil.registerAsMBean(bean, bean.getClass().getPackage().getName() + ":type=" + bean.getClass().getSimpleName() + "-" + Integer.toHexString(bean.hashCode()));
        }
    }

    public static void registerAsMBean(Object bean, String objectName) throws JMException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName(objectName);
        mbs.registerMBean(bean, name);
    }

    public static Method findFirstMethodStartsWith(Class<?> clazz, String methodName) {
        for (Method method : MetaUtil.allMethodsOf(clazz)) {
            if (!method.getName().startsWith(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Method findFirstMethodEndsWithAndReturns(Class<?> clazz, String methodName, Class<?> returnType) {
        for (Method method : MetaUtil.allMethodsOf(clazz)) {
            if (!method.getName().endsWith(methodName) || method.getReturnType() != returnType) continue;
            return method;
        }
        return null;
    }

    public static Method findFirstMethod(Class<?> clazz, String methodName) {
        for (Method method : MetaUtil.allMethodsOf(clazz)) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Method findFirstMethod(Class<?> classz, String methodName, int totalArguments) {
        for (Method method : MetaUtil.allMethodsOf(classz)) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != totalArguments) continue;
            return method;
        }
        return null;
    }

    public static List<Class<?>> allExtendedClassesOf(Class<?> classz) {
        ArrayList clazzList = new ArrayList();
        for (Class<?> c = classz; c != null; c = c.getSuperclass()) {
            clazzList.add(c);
        }
        return clazzList;
    }

    public static List<Method> allMethodsOf(Class<?> classz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList clazzList = new ArrayList();
        for (Class<?> c = classz; c != null; c = c.getSuperclass()) {
            clazzList.add(c);
        }
        clazzList.addAll(Arrays.asList(classz.getInterfaces()));
        for (Class clazz : clazzList) {
            AccessibleObject[] declaredMethods = clazz.getDeclaredMethods();
            try {
                AccessibleObject.setAccessible(declaredMethods, true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            methods.addAll(Arrays.asList(declaredMethods));
        }
        return methods;
    }

    public static Field findFirstField(Class<?> clazz, String fieldName) {
        for (Field field : MetaUtil.allFieldsOf(clazz)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static Field findFirstSuperField(Class<?> clazz, String fieldName) {
        for (Field field : MetaUtil.allSuperFieldsOf(clazz)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static Field findFirstFieldByType(Class<?> clazz, String typeName) {
        for (Field field : MetaUtil.allFieldsOf(clazz)) {
            if (!field.getType().getSimpleName().equals(typeName)) continue;
            return field;
        }
        return null;
    }

    public static List<Field> allFieldsOf(Class<?> classz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = classz; c != null; c = c.getSuperclass()) {
            AccessibleObject[] declaredFields = c.getDeclaredFields();
            try {
                AccessibleObject.setAccessible(declaredFields, true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            fields.addAll(Arrays.asList(declaredFields));
        }
        return fields;
    }

    public static List<Field> allSuperFieldsOf(Class<?> classz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = classz.getSuperclass(); c != null; c = c.getSuperclass()) {
            AccessibleObject[] declaredFields = c.getDeclaredFields();
            try {
                AccessibleObject.setAccessible(declaredFields, true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            fields.addAll(Arrays.asList(declaredFields));
        }
        return fields;
    }

    public static Method findSetter(Class<?> classz, String propertyName) {
        return MetaUtil.findFirstMethod(classz, "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1), 1);
    }

    public static void setPropertyIfExists(Object obj, String propertyName, Object propertyValue) {
        Class<?> clazz = obj.getClass();
        Method propSetter = MetaUtil.findSetter(clazz, propertyName);
        if (propSetter != null) {
            Class paramType = propSetter.getParameterTypes()[0];
            if (paramType.isPrimitive()) {
                paramType = ClassUtils.primitiveToWrapper(paramType);
            }
            Object value = propertyValue;
            try {
                if (!propertyValue.getClass().equals(paramType)) {
                    value = paramType.getMethod("valueOf", propertyValue.getClass()).invoke(null, propertyValue);
                }
                propSetter.invoke(obj, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Map<String, Object> fieldDataMap(Object target, boolean prependClassName, String methodPrefix, List<Class<?>> returnTypeList) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String className = target.getClass().getSimpleName();
        for (Method method : MetaUtil.allMethodsOf(target.getClass())) {
            if (!method.getName().startsWith(methodPrefix) || method.getParameterTypes().length != 0 || !returnTypeList.contains(method.getReturnType())) continue;
            try {
                if (prependClassName) {
                    dataMap.put(className + "." + method.getName(), method.invoke(target, new Object[0]));
                    continue;
                }
                dataMap.put(method.getName(), method.invoke(target, new Object[0]));
            }
            catch (Exception exception) {}
        }
        return dataMap;
    }

    public static Map<String, Object> simpleFieldDataMap(Object target, boolean prependClassName) {
        return MetaUtil.fieldDataMap(target, prependClassName, "", SIMPLE_RETURN_TYPE_LIST);
    }

    public static Map<String, Object> classNameObjectMap(Object ... objects) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int index = 0;
        for (Object object : objects) {
            String key = object.getClass().getName();
            key = key.substring(key.lastIndexOf(46) + 1).replaceAll(";", "");
            if (valueMap.containsKey(key = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, key))) {
                valueMap.put(key + index++, object);
                continue;
            }
            valueMap.put(key, object);
        }
        return valueMap;
    }

    public static Map<String, Object> createMap(String key, Object value) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(key, value);
        return valueMap;
    }

    public static <T> Map<String, T> createMap(String key, Object value, Class<T> clazz) {
        HashMap<String, T> valueMap = new HashMap<String, T>();
        valueMap.put(key, clazz.cast(value));
        return valueMap;
    }

    public static Map<String, String> createPropsMap(String ... args) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        String[] prop = null;
        for (String arg : args) {
            prop = arg.split("=");
            propMap.put(prop[0], prop[1]);
        }
        return propMap;
    }

    public static void shuffleArray(Object array) {
        if (!array.getClass().isArray()) {
            return;
        }
        Random random = new Random();
        for (int i = Array.getLength(array) - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            Object temp = Array.get(array, index);
            Array.set(array, index, Array.get(array, i));
            Array.set(array, i, temp);
        }
    }

    public static int availablePort(int startPort, int maxCount) {
        int delta = 0;
        while (delta < maxCount) {
            try {
                Socket tmpSocket = new Socket("localhost", startPort + delta);
                Throwable throwable = null;
                try {
                    ++delta;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tmpSocket == null) continue;
                    if (throwable != null) {
                        try {
                            tmpSocket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tmpSocket.close();
                }
            }
            catch (IOException ioe) {
                break;
            }
        }
        return startPort + delta;
    }

    public static Object runNestedMethod(Object target, String nestedMethod) throws ReflectiveOperationException, ScriptException {
        return new URIInvoker(target).invokeNestedMethod(target, nestedMethod);
    }

    public static Map<String, Object> runNestedMethodsSilently(Object target, String nestedMethods) {
        HashMap<String, Object> returnValues = new HashMap<String, Object>();
        URIInvoker invoker = new URIInvoker(target);
        for (String method : nestedMethods.split(";;")) {
            try {
                returnValues.put(method, invoker.invokeNestedMethod(target, method));
            }
            catch (ReflectiveOperationException | RuntimeException | ScriptException e) {
                returnValues.put(method, null);
            }
        }
        return returnValues;
    }

    public static void disableSslCertificates() throws GeneralSecurityException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static long hash(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    public static void assignFromHierarchy(Object obj) {
        Class<?> dstClass = obj.getClass();
        Field[] declaredFields = dstClass.getDeclaredFields();
        List<Field> superFields = MetaUtil.allSuperFieldsOf(obj.getClass());
        block4: for (Field field : declaredFields) {
            for (Field superField : superFields) {
                if (!superField.getName().equals(field.getName())) continue;
                try {
                    AccessibleObject.setAccessible(new Field[]{field, superField}, true);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                try {
                    field.set(obj, superField.get(obj));
                }
                catch (ReflectiveOperationException | RuntimeException exception) {}
                continue block4;
            }
        }
    }

    public static void copyFields(Object dst, Object src) {
        List<Field> dstFields = MetaUtil.allFieldsOf(dst.getClass());
        List<Field> srcFields = MetaUtil.allFieldsOf(src.getClass());
        block4: for (Field dstField : dstFields) {
            for (Field srcField : srcFields) {
                if (!srcField.getName().equals(dstField.getName())) continue;
                try {
                    AccessibleObject.setAccessible(new Field[]{dstField, srcField}, true);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                try {
                    dstField.set(dst, srcField.get(src));
                }
                catch (ReflectiveOperationException | RuntimeException exception) {}
                continue block4;
            }
        }
    }

    public static int enableJmx() throws IOException {
        int port = MetaUtil.availablePort(9001, 100);
        MetaUtil.enableJmx(port);
        return port;
    }

    public static void enableJmx(int port) throws IOException {
        LocateRegistry.createRegistry(port);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("com.sun.management.jmxremote.authenticate", "false");
        env.put("com.sun.management.jmxremote.local.only", "false");
        env.put("com.sun.management.jmxremote.ssl", "false");
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:" + port + "/jmxrmi");
        JMXConnectorServer svr = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
        svr.start();
    }

    public static byte[] fetchClassDefinitionBytes(Class<?> loader, Class<?> clazz) throws IOException {
        return IOUtils.toByteArray((InputStream)loader.getResourceAsStream("/" + clazz.getName().replace(".", "/") + ".class"));
    }

    public static byte[] fetchClassDefinitionBytes(Class<?> clazz) throws IOException {
        return MetaUtil.fetchClassDefinitionBytes(clazz, clazz);
    }

    public static File writeClassDefinition(Class<?> loader, String folder, Class<?> clazz) throws IOException {
        File parent = new File(folder + "/" + clazz.getPackage().getName().replace(".", "/"));
        parent.mkdirs();
        File file = new File(parent, clazz.getSimpleName() + ".class");
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(MetaUtil.fetchClassDefinitionBytes(loader, clazz));
        fos.flush();
        fos.close();
        return file;
    }

    public static File writeClassDefinition(String folder, Class<?> clazz) throws IOException {
        File parent = new File(folder + "/" + clazz.getPackage().getName().replaceAll("\\.", "/"));
        parent.mkdirs();
        File file = new File(parent, clazz.getSimpleName() + ".class");
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(MetaUtil.fetchClassDefinitionBytes(clazz));
        fos.flush();
        fos.close();
        return file;
    }

    public static void writeClassDefinitions(Class<?> loader, String folder, List<Class<?>> clazzes) throws IOException {
        for (Class<?> clazz : clazzes) {
            MetaUtil.writeClassDefinition(loader, folder, clazz);
        }
    }

    public static void writeClassDefinitions(Class<?> loader, String folder, Class<?> ... clazzes) throws IOException {
        for (Class<?> clazz : clazzes) {
            MetaUtil.writeClassDefinition(loader, folder, clazz);
        }
    }

    public static void writeClassDefinitions(String folder, Class<?> ... clazzes) throws IOException {
        for (Class<?> clazz : clazzes) {
            MetaUtil.writeClassDefinition(folder, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSourceToJarStream(String prefix, File source, JarOutputStream jarStream, String jarName) throws IOException {
        try (BufferedInputStream in = null;){
            if (source.isDirectory()) {
                String name = source.getPath().replace("\\", "/");
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                if (!(name = name.replace(prefix, "")).isEmpty()) {
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    jarStream.putNextEntry(entry);
                    jarStream.closeEntry();
                }
                for (File nestedFile : source.listFiles()) {
                    MetaUtil.addSourceToJarStream(prefix, nestedFile, jarStream, jarName);
                }
                return;
            }
            String name = source.getPath().replace("\\", "/").replace(prefix, "");
            if (!name.equals(jarName + ".jar") && !name.equals("META-INF/MANIFEST.MF")) {
                int count;
                JarEntry entry = new JarEntry(name);
                entry.setTime(source.lastModified());
                jarStream.putNextEntry(entry);
                in = new BufferedInputStream(new FileInputStream(source));
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    jarStream.write(buffer, 0, count);
                }
                jarStream.closeEntry();
            }
        }
    }

    public static File createJarFromDir(String srcDir, String dstDir, String name, Map<String, String> attributes) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                manifest.getMainAttributes().put(new Attributes.Name(key), attributes.get(key));
            }
        }
        File parent = new File(dstDir);
        parent.mkdirs();
        File jarFile = new File(dstDir, name + ".jar");
        JarOutputStream jarStream = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        MetaUtil.addSourceToJarStream(srcDir + "/", new File(srcDir), jarStream, name);
        jarStream.close();
        return jarFile;
    }

    public static File createJarFromClasses(Class<?> loader, String folder, String jarName, Map<String, String> attributes, List<Class<?>> clazzes) throws IOException {
        MetaUtil.writeClassDefinitions(loader, folder, clazzes);
        return MetaUtil.createJarFromDir(folder, folder, jarName, attributes);
    }

    public static File createJarFromClasses(Class<?> loader, String folder, String jarName, Map<String, String> attributes, Class<?> ... clazzes) throws IOException {
        MetaUtil.writeClassDefinitions(loader, folder, clazzes);
        return MetaUtil.createJarFromDir(folder, folder, jarName, attributes);
    }

    public static File createJarFromClasses(String folder, String jarName, Map<String, String> attributes, Class<?> ... clazzes) throws IOException {
        MetaUtil.writeClassDefinitions(folder, clazzes);
        return MetaUtil.createJarFromDir(folder, folder, jarName, attributes);
    }

    public static boolean ftpUpload(String ftpUrl, String local, String remote) throws IOException {
        return MetaUtil.ftpUpload(ftpUrl, local, remote, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ftpUpload(String ftpUrl, String local, String remote, boolean recursive) throws IOException {
        boolean status = false;
        FTPClient ftpClient = new FTPClient();
        try {
            URL url = new URL(ftpUrl);
            ftpClient.connect(url.getHost(), url.getPort());
            String[] userInfo = url.getUserInfo().split(":");
            ftpClient.login(userInfo[0], userInfo[1]);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            status = MetaUtil.ftpUpload(ftpClient, new File(local), remote, recursive);
        }
        finally {
            if (ftpClient.isConnected()) {
                ftpClient.logout();
                ftpClient.disconnect();
            }
        }
        return status;
    }

    public static boolean ftpUpload(FTPClient ftpClient, File local, String remote, boolean recursive) throws IOException {
        boolean status = false;
        if (local.isDirectory()) {
            File[] files;
            for (File file : files = local.listFiles()) {
                if ((!file.isDirectory() || !recursive) && !file.isFile()) continue;
                status &= MetaUtil.ftpUpload(ftpClient, file, remote + (remote.endsWith("/") ? "" : "/") + local.getName() + "/", recursive);
            }
        } else {
            FileInputStream fis = new FileInputStream(local);
            status = ftpClient.storeFile(remote.endsWith("/") ? remote + local.getName() : remote, (InputStream)fis);
            fis.close();
        }
        return status;
    }

    public static void extractResource(Class<?> loader, String resourceName, String folder) throws IOException {
        File parent = new File(folder);
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(new File(parent, resourceName));
        fos.write(MetaUtil.getResourceAsBytes(loader, resourceName));
        fos.close();
    }

    public static List<Class<?>> getLoadedClassesByName(Instrumentation instr, String className) {
        Class[] classes;
        ArrayList classList = new ArrayList();
        for (Class clazz : classes = instr.getAllLoadedClasses()) {
            if (!clazz.getName().equals(className)) continue;
            classList.add(clazz);
        }
        return classList;
    }

    public static void addLogic(Instrumentation instr, String fqcn, String methodName, String argLength, String mode, String logic) throws Exception {
        boolean methodMulti = false;
        if (methodName.contains(",")) {
            methodMulti = true;
        }
        String[] methodInfo = methodName.split(",");
        String[] argLengthInfo = argLength.split(",");
        String[] modeInfo = mode.split(",");
        String[] logicInfo = logic.split(",,");
        ArrayList<LogicTransformer> transformers = new ArrayList<LogicTransformer>();
        for (int index = 0; index < logicInfo.length; ++index) {
            ClassFileTransformer transformer = new LogicTransformer(fqcn, methodMulti ? methodInfo[index] : methodName, Integer.parseInt(methodMulti ? argLengthInfo[index] : argLength), modeInfo[index], logicInfo[index]);
            instr.addTransformer(transformer, true);
            transformers.add((LogicTransformer)transformer);
        }
        instr.retransformClasses(Class.forName(fqcn));
        for (ClassFileTransformer transformer : transformers) {
            instr.removeTransformer(transformer);
        }
    }

    public static List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(MetaUtil.findClasses(directory, packageName));
        }
        return classes;
    }

    public static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(MetaUtil.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static String decompileClass(String className) {
        DecompilerSettings settings = DecompilerSettings.javaDefaults();
        PlainTextOutput output = new PlainTextOutput();
        Decompiler.decompile((String)className, (ITextOutput)output, (DecompilerSettings)settings);
        return output.toString();
    }

    public static String encodeForHTML(String text) {
        return ESAPIEncoder.getInstance().encodeForHTML(text);
    }

    public static JsonNode encodeForHTML(JsonNode node) {
        if (node.isArray()) {
            ArrayNode arr = (ArrayNode)node;
            for (int i = 0; i < arr.size(); ++i) {
                arr.set(i, MetaUtil.encodeForHTML(arr.get(i)));
            }
        } else if (node.isObject()) {
            ObjectNode obj = (ObjectNode)node;
            for (String key : Lists.newArrayList((Iterator)obj.fieldNames())) {
                obj.set(key, MetaUtil.encodeForHTML(obj.get(key)));
            }
        } else if (node.isTextual()) {
            return new TextNode(MetaUtil.encodeForHTML(node.asText()));
        }
        return node;
    }

    public static class LogicTransformer
    implements ClassFileTransformer {
        private final String fqcn;
        private final String methodName;
        private final int argLength;
        private final String mode;
        private final String logic;

        public LogicTransformer(String fqcn, String methodName, int argLength, String mode, String logic) {
            this.fqcn = fqcn;
            this.methodName = methodName;
            this.argLength = argLength;
            this.mode = mode;
            this.logic = logic;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            byte[] byteCode = classfileBuffer;
            if (className.equals(this.fqcn.replace('.', '/'))) {
                try {
                    CtMethod[] methods;
                    ClassPool classPool = ClassPool.getDefault();
                    CtClass ctClass = classPool.makeClass((InputStream)new ByteArrayInputStream(classfileBuffer));
                    for (CtMethod method : methods = ctClass.getDeclaredMethods()) {
                        if (!method.getName().equals(this.methodName) || method.getParameterTypes().length != this.argLength) continue;
                        if ("prepend".equalsIgnoreCase(this.mode)) {
                            method.insertBefore(this.logic);
                            continue;
                        }
                        if ("append".equalsIgnoreCase(this.mode)) {
                            method.insertAfter(this.logic);
                            continue;
                        }
                        method.insertAt(Integer.parseInt(this.mode), this.logic);
                    }
                    byteCode = ctClass.toBytecode();
                    ctClass.detach();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return byteCode;
        }
    }
}

