/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public class ObjectSizeCalculator {
    private static final int REFERENCE_SIZE;
    private static final int HEADER_SIZE;
    private static final int LONG_SIZE = 8;
    private static final int INT_SIZE = 4;
    private static final int BYTE_SIZE = 1;
    private static final int BOOLEAN_SIZE = 1;
    private static final int CHAR_SIZE = 2;
    private static final int SHORT_SIZE = 2;
    private static final int FLOAT_SIZE = 4;
    private static final int DOUBLE_SIZE = 8;
    private static final int ALIGNMENT = 8;

    public static long sizeOf(Object o) throws IllegalAccessException {
        return ObjectSizeCalculator.sizeOf(o, new HashSet<ObjectWrapper>());
    }

    private static long sizeOf(Object o, Set<ObjectWrapper> visited) throws IllegalAccessException {
        if (o == null) {
            return 0L;
        }
        ObjectWrapper objectWrapper = new ObjectWrapper(o);
        if (visited.contains(objectWrapper)) {
            return 0L;
        }
        visited.add(objectWrapper);
        long size = HEADER_SIZE;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            if (clazz == long[].class) {
                long[] objs = (long[])o;
                size += (long)(objs.length * 8);
            } else if (clazz == int[].class) {
                int[] objs = (int[])o;
                size += (long)(objs.length * 4);
            } else if (clazz == byte[].class) {
                byte[] objs = (byte[])o;
                size += (long)(objs.length * 1);
            } else if (clazz == boolean[].class) {
                boolean[] objs = (boolean[])o;
                size += (long)(objs.length * 1);
            } else if (clazz == char[].class) {
                char[] objs = (char[])o;
                size += (long)(objs.length * 2);
            } else if (clazz == short[].class) {
                short[] objs = (short[])o;
                size += (long)(objs.length * 2);
            } else if (clazz == float[].class) {
                float[] objs = (float[])o;
                size += (long)(objs.length * 4);
            } else if (clazz == double[].class) {
                double[] objs = (double[])o;
                size += (long)(objs.length * 8);
            } else {
                Object[] objs;
                for (Object obj : objs = (Object[])o) {
                    size += ObjectSizeCalculator.sizeOf(obj, visited) + (long)REFERENCE_SIZE;
                }
            }
            size += 4L;
        } else {
            Field[] fields = o.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String fieldType;
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                if (!fields[i].isAccessible()) {
                    fields[i].setAccessible(true);
                }
                if ((fieldType = fields[i].getGenericType().toString()).equals("long")) {
                    size += 8L;
                    continue;
                }
                if (fieldType.equals("int")) {
                    size += 4L;
                    continue;
                }
                if (fieldType.equals("byte")) {
                    ++size;
                    continue;
                }
                if (fieldType.equals("boolean")) {
                    ++size;
                    continue;
                }
                if (fieldType.equals("char")) {
                    size += 2L;
                    continue;
                }
                if (fieldType.equals("short")) {
                    size += 2L;
                    continue;
                }
                if (fieldType.equals("float")) {
                    size += 4L;
                    continue;
                }
                if (fieldType.equals("double")) {
                    size += 8L;
                    continue;
                }
                size += ObjectSizeCalculator.sizeOf(fields[i].get(o), visited) + (long)REFERENCE_SIZE;
            }
        }
        if (size % 8L != 0L) {
            size = 8L * (size / 8L + 1L);
        }
        return size;
    }

    static {
        try {
            if (System.getProperties().get("java.vm.name").toString().contains("64")) {
                REFERENCE_SIZE = 8;
                HEADER_SIZE = 16;
            } else {
                REFERENCE_SIZE = 4;
                HEADER_SIZE = 8;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AssertionError((Object)ex);
        }
    }

    private static final class ObjectWrapper {
        private final Object object;

        public ObjectWrapper(Object object) {
            this.object = object;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ObjectWrapper.class) {
                return false;
            }
            return this.object == ((ObjectWrapper)obj).object;
        }

        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + System.identityHashCode(this.object);
            return hash;
        }
    }
}

