/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;

public class SuperTester {
    private final transient Object[] objects;

    public SuperTester(Object[] objects) throws IllegalAccessException, InstantiationException, IOException {
        this.objects = Arrays.copyOf(objects, objects.length);
    }

    public SuperTester(String packageName, String[] classNames) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
        this.objects = new Object[classNames.length];
        for (int index = 0; index < classNames.length; ++index) {
            this.objects[index] = this.createInstance(Class.forName(packageName + "." + classNames[index]));
        }
    }

    public SuperTester(Class<?> ... classes) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
        this.objects = new Object[classes.length];
        for (int index = 0; index < classes.length; ++index) {
            this.objects[index] = this.createInstance(classes[index]);
        }
    }

    public void testGetters() throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, NoSuchFieldException, ClassNotFoundException {
        for (Object object : this.objects) {
            Method[] methods;
            for (Method method : methods = object.getClass().getMethods()) {
                if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
                this.invokeMethod(method, object);
            }
        }
    }

    public void testSetters() throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, NoSuchFieldException, ClassNotFoundException {
        for (Object object : this.objects) {
            Method[] methods;
            for (Method method : methods = object.getClass().getMethods()) {
                if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
                this.invokeMethod(method, object);
            }
        }
    }

    public void testPublics() throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, NoSuchFieldException, ClassNotFoundException {
        for (Object object : this.objects) {
            Method[] methods;
            for (Method method : methods = object.getClass().getMethods()) {
                this.invokeMethod(method, object);
            }
        }
    }

    private void invokeMethod(final Method method, final Object object) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SuperTester.this.belogToClass(method, object.getClass()) && !SuperTester.this.isTestMethod(method)) {
                        Class<?>[] paramTypes = method.getParameterTypes();
                        Object[] params = new Object[paramTypes.length];
                        for (int index = 0; index < params.length; ++index) {
                            params[index] = SuperTester.this.createInstance(paramTypes[index]);
                        }
                        method.invoke(object, params);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    private boolean belogToClass(Method method, Class<?> classs) {
        Method[] declaredMethods;
        boolean value = false;
        for (Method declared : declaredMethods = classs.getDeclaredMethods()) {
            if (!declared.equals(method)) continue;
            value = true;
            break;
        }
        return value;
    }

    private boolean isTestMethod(Method method) {
        boolean value = false;
        value = method.getName().toLowerCase(Locale.getDefault()).indexOf("test") >= 0;
        return value;
    }

    private Object createInstance(Class<?> classs) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException, ClassNotFoundException {
        Cloneable obj = null;
        if (classs.isArray()) {
            Class<?> component = classs.getComponentType();
            obj = Array.newInstance(component, 1);
            Array.set(obj, 0, this.createInstance(component));
        } else if (classs.isPrimitive()) {
            Class boxClass = ClassUtils.wrapperToPrimitive(classs);
            Class[] primitiveTypes = new Class[]{classs};
            Object[] primitiveValues = new Object[]{0};
            obj = boxClass.getConstructor(primitiveTypes).newInstance(primitiveValues);
        } else if (classs.isAssignableFrom(List.class)) {
            obj = new ArrayList();
        } else if (classs.isAssignableFrom(Set.class)) {
            obj = new HashSet();
        } else if (classs.isAssignableFrom(Map.class)) {
            obj = new HashMap();
        } else {
            Constructor<?> construct = null;
            try {
                construct = classs.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException primitiveTypes) {
                // empty catch block
            }
            Constructor<?>[] constructs = classs.getConstructors();
            if (constructs.length > 0) {
                if (construct == null) {
                    construct = constructs[0];
                }
                Class<?>[] paramTypes = construct.getParameterTypes();
                Object[] params = new Object[paramTypes.length];
                for (int index = 0; index < params.length; ++index) {
                    params[index] = this.createInstance(paramTypes[index]);
                }
                obj = construct.newInstance(params);
            }
        }
        return obj;
    }

    public void testAll() {
        try {
            this.testGetters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.testSetters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.testPublics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testAll(String packageName) throws Exception {
        SuperTester tester = new SuperTester(SuperTester.getClasses(packageName));
        tester.testAll();
    }

    public static void testObjects(Object ... objects) throws Exception {
        SuperTester tester = new SuperTester(objects);
        tester.testAll();
    }

    private static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(SuperTester.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(SuperTester.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

