/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class SystemInfo {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PROCESS_ID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    private final Map<String, Process> processMap = new HashMap<String, Process>();

    public Runtime getRuntime() {
        return Runtime.getRuntime();
    }

    public RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    public MemoryMXBean getMemoryMXBean() {
        return ManagementFactory.getMemoryMXBean();
    }

    public OperatingSystemMXBean getOsMXBean() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    public ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactory.getClassLoadingMXBean();
    }

    public CompilationMXBean getCompilationMXBean() {
        return ManagementFactory.getCompilationMXBean();
    }

    public static Process runCommandFromStream(InputStream commandStream, String runName, String arguments, boolean deleteOnExit) {
        Process process = null;
        try {
            File runFile = new File("/tmp/" + runName);
            FileOutputStream outStream = new FileOutputStream(runFile);
            IOUtils.copy((InputStream)commandStream, (OutputStream)outStream);
            outStream.flush();
            outStream.close();
            if (deleteOnExit) {
                runFile.deleteOnExit();
            }
            runFile.setExecutable(true);
            process = Runtime.getRuntime().exec(runFile.getAbsolutePath() + " " + arguments);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return process;
    }

    public String getProcessId() {
        return PROCESS_ID;
    }

    public Map<String, Process> getProcessMap() {
        return this.processMap;
    }

    public void writeLine(String command, String line) {
        this.writeLine(this.processMap.get(command), line);
    }

    public void writeLine(Process process, String line) {
        new PrintStream(process.getOutputStream()).println(line);
    }

    public String readLine(String command) throws IOException {
        return this.readLine(this.processMap.get(command));
    }

    public String readLine(Process process) throws IOException {
        return new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
    }

    public String readLines(String command) throws IOException {
        return this.readLines(this.processMap.get(command));
    }

    public String readLines(Process process) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String outLine = null;
        builder.append(LINE_SEPARATOR);
        while ((outLine = reader.readLine()) != null) {
            builder.append(outLine);
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public String execOut(String command, String line) throws IOException {
        return this.execOut(command, null, null, line, true);
    }

    public String execOut(String command, String[] envp, File dir, String line, boolean destroy) throws IOException {
        Process process = this.exec(command, envp, dir);
        this.writeLine(command, line);
        String lines = this.readLines(process);
        if (destroy) {
            process.destroy();
            this.processMap.remove(command);
        }
        return lines;
    }

    public String execOut(String command) throws IOException {
        return this.execOut(command, null, null, true);
    }

    public String run(String command) {
        try {
            return this.execOut(command);
        }
        catch (Exception ex) {
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
    }

    public String execOut(String command, String[] envp, File dir, boolean destroy) throws IOException {
        Process process = this.exec(command, envp, dir);
        String lines = this.readLines(process);
        if (destroy) {
            process.destroy();
            this.processMap.remove(command);
        }
        return lines;
    }

    public Process exec(String command) throws IOException {
        return this.exec(command, null, null);
    }

    public Process exec(String command, String[] envp, File dir) throws IOException {
        Process proc = this.getRuntime().exec(command, envp, dir);
        this.processMap.put(command, proc);
        return proc;
    }
}

