/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils;

import com.bluejeans.utils.InvokerMXBean;
import com.bluejeans.utils.MetaUtil;
import com.bluejeans.utils.ObjectSizeCalculator;
import com.bluejeans.utils.SystemInfo;
import com.google.gson.internal.Primitives;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;

public class URIInvoker
extends InvokerMXBean.Invoker {
    public static final String[] SIZE_STEPS = new String[]{"B", "KB", "MB", "GB"};
    private final Map<String, Object> targetMap;
    private final SystemInfo system = new SystemInfo();
    private final MetaUtil metaUtil = new MetaUtil();
    private final ConvertUtilsBean convertUtil;
    private ScriptEngine jsEngine;

    public URIInvoker(Object target) {
        this(MetaUtil.createMap("target", target));
    }

    public URIInvoker(Object ... targets) {
        this(MetaUtil.classNameObjectMap(targets));
    }

    public URIInvoker(Map<String, Object> targetMap) {
        this.targetMap = new HashMap<String, Object>();
        this.targetMap.put("system", this.system);
        this.targetMap.put("metaUtil", this.metaUtil);
        this.convertUtil = new ConvertUtilsBean();
        this.resetJsEngine();
    }

    public void resetJsEngine() {
        this.resetJsEngine("JavaScript");
    }

    public void resetJsEngine(String engineName) {
        this.jsEngine = new ScriptEngineManager().getEngineByName(engineName);
        this.addTargets(this.targetMap);
    }

    public void setTarget(String name, Object target) {
        this.targetMap.put(name, target);
        this.jsEngine.put(name, target);
    }

    public void setTarget(Object target) {
        this.setTarget("target", target);
    }

    public void addTargets(Map<String, Object> targetMap) {
        if (targetMap != this.targetMap) {
            this.targetMap.putAll(targetMap);
        }
        for (Map.Entry<String, Object> targetEntry : this.targetMap.entrySet()) {
            this.jsEngine.put(targetEntry.getKey(), targetEntry.getValue());
        }
    }

    public void addTargets(Object ... targets) {
        this.addTargets(MetaUtil.classNameObjectMap(targets));
    }

    public void addTarget(String targetName, Object targetObject) {
        this.addTargets(MetaUtil.createMap(targetName, targetObject));
    }

    public Map<String, Object> getTargetMap() {
        return this.targetMap;
    }

    public ConvertUtilsBean getConvertUtil() {
        return this.convertUtil;
    }

    public ScriptEngine getJsEngine() {
        return this.jsEngine;
    }

    public Object runLink(String link) throws ScriptException, IOException {
        String url = link;
        if (!link.contains(":/")) {
            url = "http://" + link;
        }
        return this.run(IOUtils.toString((InputStream)new URL(url).openStream()));
    }

    public Object run(String script) throws ScriptException {
        return this.jsEngine.eval(script);
    }

    public void appendRunLink(Appendable value, String runLink) {
        try {
            this.appendValue(value, this.runLink(runLink));
        }
        catch (IOException ioe) {
            this.appendError(value, ioe);
        }
        catch (ScriptException se) {
            this.appendError(value, se);
        }
    }

    public void appendRunValue(Appendable value, String runThis) {
        try {
            this.appendValue(value, this.run(runThis));
        }
        catch (IOException ioe) {
            this.appendError(value, ioe);
        }
        catch (ScriptException se) {
            this.appendError(value, se);
        }
    }

    public void appendValue(Appendable value, String keys, boolean isProperty) {
        this.appendValue(value, "target", keys, isProperty);
    }

    public void appendValue(Appendable value, String targetName, String keys, boolean isProperty) {
        String[] keyArray = keys.split(";;");
        try {
            if (keyArray.length == 1) {
                if (isProperty) {
                    value.append(BeanUtils.getProperty((Object)this.targetMap.get(targetName), (String)keyArray[0]));
                } else {
                    this.appendValue(value, this.invokeNestedMethod(targetName, keyArray[0]));
                }
                return;
            }
            value.append("{");
            for (int index = 0; index < keyArray.length; ++index) {
                if (index > 0) {
                    value.append(",");
                }
                value.append('\"');
                value.append(keyArray[index].replaceAll("\"", "\\\""));
                value.append("\":");
                value.append('\"');
                if (isProperty) {
                    value.append(BeanUtils.getProperty((Object)this.targetMap.get(targetName), (String)keyArray[index]));
                } else {
                    this.appendValue(value, this.invokeNestedMethod(targetName, keyArray[index]));
                }
                value.append('\"');
            }
            value.append("}");
        }
        catch (ReflectiveOperationException roe) {
            this.appendError(value, roe);
        }
        catch (RuntimeException re) {
            this.appendError(value, re);
        }
        catch (IOException ioe) {
            this.appendError(value, ioe);
        }
        catch (ScriptException se) {
            this.appendError(value, se);
        }
        catch (Throwable th) {
            this.appendError(value, th);
        }
    }

    public String convert(Object obj) throws IOException {
        StringBuilder value = new StringBuilder();
        this.appendValue(value, obj);
        return value.toString();
    }

    public void appendValue(Appendable value, Object obj) throws IOException {
        if (obj == null) {
            value.append("[no return value]");
        } else if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int index = 0; index < len; ++index) {
                this.appendValue(value, Array.get(obj, index));
                value.append(SystemInfo.LINE_SEPARATOR);
            }
        } else if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                this.appendValue(value, iter.next());
                value.append(SystemInfo.LINE_SEPARATOR);
            }
        } else if (obj instanceof Iterable) {
            Iterable iter = (Iterable)obj;
            for (Object element : iter) {
                this.appendValue(value, element);
                value.append(SystemInfo.LINE_SEPARATOR);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                this.appendValue(value, entry);
                value.append(SystemInfo.LINE_SEPARATOR);
            }
        } else {
            value.append(this.convertUtil.convert(obj).replaceAll("\"", "\\\""));
        }
    }

    @Override
    public Object runThis(String name, String ... args) throws Exception {
        String[] data = name.split("/", 2);
        return this.invokeNestedMethod(data[0], data[1]);
    }

    public Object invokeNestedMethod(String targetName, String nestedMethod) throws ReflectiveOperationException, ScriptException {
        return this.invokeNestedMethod(this.targetMap.get(targetName), nestedMethod);
    }

    public Object invokeNestedMethod(Object targetObj, String nestedMethod) throws ReflectiveOperationException, ScriptException {
        String[] methods = nestedMethod.split("\\.\\.");
        Object currentTarget = targetObj;
        for (String method : methods) {
            if (method.startsWith("$")) {
                String[] fieldInfo = method.split("~~", 2);
                Field field = null;
                field = fieldInfo[0].startsWith("$$") ? MetaUtil.findFirstFieldByType(currentTarget.getClass(), fieldInfo[0].substring(2)) : MetaUtil.findFirstField(currentTarget.getClass(), fieldInfo[0].substring(1));
                field.setAccessible(true);
                if (fieldInfo.length > 1) {
                    Class fieldType = Primitives.wrap(field.getType());
                    if (fieldType.equals(String.class)) {
                        field.set(currentTarget, fieldInfo[1]);
                    } else if (fieldInfo[1].startsWith("$")) {
                        Object result = this.run(fieldInfo[1].substring(1));
                        if (fieldType.equals(result.getClass())) {
                            field.set(currentTarget, result);
                        } else {
                            field.set(currentTarget, fieldType.getMethod("valueOf", String.class).invoke(null, result.toString()));
                        }
                    } else {
                        field.set(currentTarget, fieldType.getMethod("valueOf", String.class).invoke(null, fieldInfo[1]));
                    }
                }
                currentTarget = field.get(currentTarget);
                continue;
            }
            if (method.equals("_interfaces")) {
                currentTarget = ClassUtils.getAllInterfaces(currentTarget.getClass());
                continue;
            }
            if (method.equals("_extends")) {
                currentTarget = MetaUtil.allExtendedClassesOf(currentTarget.getClass());
                continue;
            }
            if (method.equals("_fields")) {
                currentTarget = MetaUtil.allFieldsOf(currentTarget.getClass());
                continue;
            }
            if (method.equals("_methods")) {
                currentTarget = MetaUtil.allMethodsOf(currentTarget.getClass());
                continue;
            }
            if (method.equals("_length")) {
                currentTarget = Array.getLength(currentTarget);
                continue;
            }
            String[] methodInfo = method.split("~~", 2);
            String methodName = methodInfo[0];
            if (methodName.startsWith("~")) {
                methodName = methodName.substring(1);
            }
            if (methodName.startsWith("~$")) {
                methodName = methodName.substring(2);
            }
            Object[] args = new Object[]{};
            Object[] longArgs = new Object[]{};
            Object[] argStrs = new String[]{};
            boolean nullPresent = false;
            if (methodInfo.length > 1) {
                argStrs = methodInfo[1].split("::");
                args = new Object[argStrs.length];
                longArgs = new Object[argStrs.length];
                for (int index = 0; index < args.length; ++index) {
                    try {
                        try {
                            longArgs[index] = Long.valueOf((String)argStrs[index]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        args[index] = Integer.valueOf((String)argStrs[index]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        if ("{NULL}".equals(argStrs[index])) {
                            argStrs[index] = null;
                            args[index] = null;
                            longArgs[index] = null;
                            nullPresent = true;
                            continue;
                        }
                        args[index] = "{true}".equals(argStrs[index]) ? Boolean.TRUE : ("{false}".equals(argStrs[index]) ? Boolean.FALSE : (((String)argStrs[index]).startsWith("$") ? this.run(((String)argStrs[index]).substring(1)) : argStrs[index]));
                    }
                }
            }
            if (nullPresent || methodInfo[0].startsWith("~")) {
                Object methodObject = null;
                if (methodInfo[0].startsWith("~$")) {
                    methodObject = this.run(methodName);
                }
                try {
                    currentTarget = this.findMethod(currentTarget.getClass(), methodName, args.length).invoke(currentTarget, args);
                }
                catch (IllegalArgumentException iae) {
                    try {
                        currentTarget = this.findMethod(currentTarget.getClass(), methodName, args.length).invoke(currentTarget, longArgs);
                    }
                    catch (IllegalArgumentException iae1) {
                        currentTarget = this.findMethod(currentTarget.getClass(), methodName, args.length).invoke(currentTarget, argStrs);
                    }
                }
                catch (NullPointerException npe) {
                    Object result;
                    Object parent = currentTarget;
                    String parentType = "";
                    try {
                        currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)"get", (Object)Integer.parseInt(methodObject == null ? methodName : methodObject.toString()));
                        parentType = "coll";
                    }
                    catch (NumberFormatException | ReflectiveOperationException ex) {
                        try {
                            currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)"get", (Object)(methodObject == null ? methodName : methodObject));
                            parentType = "coll";
                        }
                        catch (ReflectiveOperationException roe) {
                            currentTarget = Array.get(currentTarget, Integer.parseInt(methodObject == null ? methodName : methodObject.toString()));
                            parentType = "array";
                        }
                    }
                    if (methodInfo.length <= 1) continue;
                    Class valueType = Primitives.wrap(currentTarget.getClass());
                    currentTarget = valueType.equals(String.class) ? methodInfo[1] : (methodInfo[1].startsWith("$") ? (valueType.equals((result = this.run(methodInfo[1].substring(1))).getClass()) ? result : valueType.getMethod("valueOf", String.class).invoke(null, result.toString())) : valueType.getMethod("valueOf", String.class).invoke(null, methodInfo[1]));
                    switch (parentType) {
                        case "array": {
                            Array.set(parent, Integer.parseInt(methodObject == null ? methodName : methodObject.toString()), currentTarget);
                            break;
                        }
                        case "coll": {
                            try {
                                MethodUtils.invokeMethod((Object)parent, (String)"set", (Object[])new Object[]{Integer.parseInt(methodObject == null ? methodName : methodObject.toString()), currentTarget});
                            }
                            catch (Exception roe) {
                                MethodUtils.invokeMethod((Object)parent, (String)"put", (Object[])new Object[]{methodObject == null ? methodName : methodObject, currentTarget});
                            }
                            break;
                        }
                    }
                }
                continue;
            }
            try {
                currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)methodName, (Object[])args);
            }
            catch (NoSuchMethodException nsmex) {
                try {
                    currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)methodName, (Object[])longArgs);
                }
                catch (NoSuchMethodException nsmex1) {
                    try {
                        currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)methodName, (Object[])argStrs);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)("get" + methodName.substring(0, 1).toUpperCase(Locale.getDefault()) + methodName.substring(1)), (Object[])args);
                        }
                        catch (NoSuchMethodException nsme1) {
                            try {
                                currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)"get", (Object)Integer.parseInt(methodName));
                            }
                            catch (NumberFormatException nfe) {
                                currentTarget = MethodUtils.invokeMethod((Object)currentTarget, (String)"get", (Object)methodName);
                            }
                            catch (ReflectiveOperationException roe) {
                                currentTarget = Array.get(currentTarget, Integer.parseInt(methodName));
                            }
                        }
                    }
                }
            }
        }
        return currentTarget;
    }

    public Method findMethod(Class<?> classz, String methodName, int totalArguments) {
        return MetaUtil.findFirstMethod(classz, methodName, totalArguments);
    }

    public void appendError(Appendable value, Throwable th) {
        try {
            value.append("{\"error\":\"");
            value.append(th.toString());
            StringWriter exWriter = new StringWriter();
            th.printStackTrace(new PrintWriter(exWriter));
            value.append(" -->> ");
            value.append(exWriter.toString());
            value.append("\"}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toSize(String targetName, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return URIInvoker.readableSize(this.sizeofProperty(targetName, propertyName));
    }

    public long sizeofProperty(String targetName, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return URIInvoker.sizeof(PropertyUtils.getProperty((Object)this.targetMap.get(targetName), (String)propertyName));
    }

    public static long sizeof(Object obj) throws IllegalAccessException {
        return ObjectSizeCalculator.sizeOf(obj);
    }

    public static String readableSize(long size) {
        long newSize = size;
        StringBuilder builder = new StringBuilder();
        long remainder = 0L;
        for (String element : SIZE_STEPS) {
            remainder = newSize % 1024L;
            newSize /= 1024L;
            builder.insert(0, '.');
            builder.insert(0, element);
            builder.insert(0, remainder);
            if (newSize == 0L) break;
        }
        return builder.toString();
    }
}

