/*
 * Decompiled with CFR 0.152.
 */
package com.bluejeans.utils.theon;

import com.bluejeans.utils.BulkOperationUtil;
import com.bluejeans.utils.EnumCounter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheonClient<E extends Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(TheonClient.class);
    private String theonUrl;
    private URI theonUri;
    private String username;
    private String password;
    private Charset charset;
    private boolean postPerKey = false;
    private String defaultKey = "";
    private final BulkOperationUtil.BulkOperation<TheonMessage<E>> bulkOperation = coll -> {
        HashMap messageMap = new HashMap();
        boolean status = true;
        for (TheonMessage tm : coll) {
            if (tm.topic == null) continue;
            if (!messageMap.containsKey(tm.topic)) {
                messageMap.put(tm.topic, new HashMap());
            }
            if (!((Map)messageMap.get(tm.topic)).containsKey(tm.key)) {
                ((Map)messageMap.get(tm.topic)).put(tm.key, new ArrayList());
            }
            ((List)((Map)messageMap.get(tm.topic)).get(tm.key)).add(tm.message);
        }
        if (this.postPerKey) {
            for (String topic1 : messageMap.keySet()) {
                for (String key : ((Map)messageMap.get(topic1)).keySet()) {
                    status &= this.postMessagesNow(topic1, key, (List)((Map)messageMap.get(topic1)).get(key));
                }
            }
        } else {
            for (String topic2 : messageMap.keySet()) {
                status = this.postMessagesNow(topic2, this.defaultKey, (Map)messageMap.get(topic2));
            }
        }
        if (!status) {
            throw new RuntimeException("Error in posting messages");
        }
    };
    private BulkOperationUtil<TheonMessage<E>> bulkOperationUtil;
    private BulkOperationUtil<TheonMessage<E>> parallelBulkOperationUtil;
    private boolean fileBasedQueue = false;
    private boolean peekEnabled = false;
    private final boolean waitEnabled = false;
    private String queueDir;
    private String queueName;
    private long bigQueueTimerInterval = 30000L;
    private boolean parallelEnabled = false;
    private int queueCapacity = 5000;
    private int bulkPollIntervalSecs = 5;
    private int maxPostEntitySize = 0xA00000;
    private CloseableHttpClient httpClient;
    private RequestConfig requestConfig;
    private boolean initialized = false;
    private EnumCounter<TheonStatus> theonCounter;
    private int bulkMessageSize = 200;
    private int httpConnPoolSize = 10;
    private boolean gzipEnabled = false;
    private boolean certValidationDisabled = false;
    private boolean stringType = false;

    public TheonClient() {
    }

    public TheonClient(String theonUrl, String username, String password) {
        this.theonUrl = theonUrl;
        this.username = username;
        this.password = password;
    }

    @PostConstruct
    public void init() throws URISyntaxException {
        PoolingHttpClientConnectionManager cm;
        if (this.charset == null) {
            this.charset = Consts.UTF_8;
        }
        if (StringUtils.isEmpty((String)this.theonUrl) || StringUtils.isEmpty((String)this.username) || StringUtils.isEmpty((String)this.password)) {
            return;
        }
        String usedUrl = this.theonUrl;
        if (usedUrl.charAt(usedUrl.length() - 1) == '/') {
            usedUrl = usedUrl.substring(0, usedUrl.length() - 1);
        }
        this.theonUri = new URI(usedUrl);
        String host = this.theonUri.getHost();
        int port = this.theonUri.getPort();
        SSLContextBuilder sslBuilder = SSLContexts.custom();
        if (this.certValidationDisabled) {
            try {
                sslBuilder.loadTrustMaterial(null, (chain, authType) -> true);
                SSLContext sslContext = sslBuilder.build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
                cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                logger.warn("Problem in disabling SSL certificate checks", (Throwable)ex);
                cm = new PoolingHttpClientConnectionManager();
            }
        } else {
            cm = new PoolingHttpClientConnectionManager();
        }
        cm.setMaxTotal(this.httpConnPoolSize);
        cm.setDefaultMaxPerRoute(this.httpConnPoolSize);
        BasicCredentialsProvider credentialProvider = new BasicCredentialsProvider();
        credentialProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler((HttpRequestRetryHandler)DefaultHttpRequestRetryHandler.INSTANCE).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(60000).setSoKeepAlive(true).build()).setDefaultCredentialsProvider((CredentialsProvider)credentialProvider);
        this.httpClient = builder.build();
        RequestConfig.Builder config = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        config.setConnectionRequestTimeout(60000);
        config.setSocketTimeout(60000);
        this.requestConfig = config.build();
        this.bulkOperationUtil = BulkOperationUtil.create(this.bulkPollIntervalSecs, this.queueCapacity, this.queueDir, this.queueName, this.bigQueueTimerInterval, this.bulkOperation, this.bulkMessageSize, 1, 1, false);
        this.parallelBulkOperationUtil = BulkOperationUtil.create(this.bulkPollIntervalSecs, this.queueCapacity, this.queueDir, this.queueName, this.bigQueueTimerInterval, this.bulkOperation, this.bulkMessageSize, this.httpConnPoolSize, this.httpConnPoolSize, false);
        this.bulkOperationUtil.setFileBased(this.fileBasedQueue);
        this.parallelBulkOperationUtil.setFileBased(this.fileBasedQueue);
        this.bulkOperationUtil.setPeekEnabled(this.peekEnabled);
        this.parallelBulkOperationUtil.setPeekEnabled(this.peekEnabled);
        this.bulkOperationUtil.setWaitEnabled(false);
        this.parallelBulkOperationUtil.setWaitEnabled(false);
        this.parallelBulkOperationUtil.setParallel(true);
        this.theonCounter = new EnumCounter<TheonStatus>(TheonStatus.class);
        TheonMessage<Object> tm = new TheonMessage<Object>(null, null);
        this.bulkOperationUtil.dummyElementIs(tm);
        this.parallelBulkOperationUtil.dummyElementIs(tm);
        if (this.stringType) {
            TheonMessage<String> stm = new TheonMessage<String>("", "");
            this.bulkOperationUtil.entityTypeIs(stm.getClass());
            this.parallelBulkOperationUtil.entityTypeIs(stm.getClass());
        } else {
            this.bulkOperationUtil.entityTypeIs(tm.getClass());
            this.parallelBulkOperationUtil.entityTypeIs(tm.getClass());
        }
        this.bulkOperationUtil.start();
        this.parallelBulkOperationUtil.start();
        this.initialized = true;
    }

    @PreDestroy
    public void destroy() {
        if (!this.initialized) {
            return;
        }
        this.bulkOperationUtil.stop();
        this.parallelBulkOperationUtil.stop();
        try {
            this.httpClient.close();
        }
        catch (IOException ioe) {
            logger.warn("problem closing the HTTP client", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postMessagesNow(String topic, String defaultKey, Map<String, List<E>> messagesMap) {
        if (!this.initialized) {
            return false;
        }
        boolean status = true;
        StringBuilder builder = new StringBuilder();
        int count = 0;
        int total = 0;
        int msgSize = 0;
        for (List<E> msgs : messagesMap.values()) {
            msgSize += msgs.size();
        }
        for (String key : messagesMap.keySet()) {
            List<E> messages = messagesMap.get(key);
            String postKey = defaultKey;
            if (key == null) {
                logger.warn("Key is 'null' for below messages - \n\t" + messages);
            } else {
                postKey = key.indexOf(58) == -1 ? key : key.replaceAll(":", "_");
            }
            for (Serializable message : messages) {
                builder.append(postKey);
                builder.append(':');
                builder.append(message.toString());
                builder.append("\r\n");
                ++count;
                if (builder.length() <= this.maxPostEntitySize && ++total != msgSize) continue;
                if (builder.length() > this.maxPostEntitySize) {
                    this.theonCounter.incrementEventCount(TheonStatus.POST_SIZE_LIMIT_REACHED);
                }
                String url = this.theonUri + "/" + topic;
                if (StringUtils.isNotBlank((String)defaultKey)) {
                    url = url + "/" + defaultKey;
                }
                HttpPost post = new HttpPost(url);
                post.setConfig(this.requestConfig);
                CloseableHttpResponse response = null;
                try {
                    if (this.gzipEnabled) {
                        post.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new StringEntity(builder.toString())));
                    } else {
                        post.setEntity((HttpEntity)new StringEntity(builder.toString(), this.charset));
                    }
                    response = this.httpClient.execute((HttpUriRequest)post);
                    this.theonCounter.incrementEventCount(TheonStatus.HTTP_POST_SUCCESS);
                    this.theonCounter.incrementEventCount(TheonStatus.MESSAGE_SEND_SUCCESS, count);
                }
                catch (Exception ex) {
                    this.theonCounter.incrementEventCount(TheonStatus.HTTP_POST_FAILURE);
                    this.theonCounter.incrementEventCount(TheonStatus.MESSAGE_SEND_FAILURE, count);
                    logger.error("Could not bulk post with length " + builder.length() + " to - " + post.getRequestLine(), (Throwable)ex);
                    status = false;
                }
                finally {
                    try {
                        response.close();
                    }
                    catch (Exception exception) {}
                }
                builder = new StringBuilder();
                count = 0;
            }
        }
        return status;
    }

    public void postMessagesNow(String topic, String key, E ... messages) {
        this.postMessagesNow(topic, key, Arrays.asList(messages));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postMessagesNow(String topic, String key, List<E> messages) {
        if (!this.initialized) {
            return false;
        }
        boolean status = true;
        StringBuilder builder = new StringBuilder();
        int count = 0;
        int total = 0;
        for (Serializable message : messages) {
            builder.append(':');
            builder.append(message.toString());
            ++count;
            if (builder.length() > this.maxPostEntitySize || ++total == messages.size()) {
                if (builder.length() > this.maxPostEntitySize) {
                    this.theonCounter.incrementEventCount(TheonStatus.POST_SIZE_LIMIT_REACHED);
                }
                String url = this.theonUri + "/" + topic;
                if (StringUtils.isNotBlank((String)key)) {
                    url = url + "/" + key;
                }
                HttpPost post = new HttpPost(url);
                post.setConfig(this.requestConfig);
                CloseableHttpResponse response = null;
                try {
                    post.setEntity((HttpEntity)new StringEntity(builder.toString(), this.charset));
                    response = this.httpClient.execute((HttpUriRequest)post);
                    this.theonCounter.incrementEventCount(TheonStatus.HTTP_POST_SUCCESS);
                    this.theonCounter.incrementEventCount(TheonStatus.MESSAGE_SEND_SUCCESS, count);
                }
                catch (Exception ex) {
                    this.theonCounter.incrementEventCount(TheonStatus.HTTP_POST_FAILURE);
                    this.theonCounter.incrementEventCount(TheonStatus.MESSAGE_SEND_FAILURE, count);
                    logger.error("Could not bulk post with length " + builder.length() + " to - " + post.getRequestLine(), (Throwable)ex);
                    status = false;
                }
                finally {
                    try {
                        response.close();
                    }
                    catch (Exception exception) {}
                }
                builder = new StringBuilder();
                count = 0;
                continue;
            }
            builder.append("\r\n");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessageNow(String topic, String key, E message) {
        if (!this.initialized) {
            return;
        }
        HttpPost post = new HttpPost(this.theonUri + "/" + topic + "/" + key);
        post.setConfig(this.requestConfig);
        CloseableHttpResponse response = null;
        try {
            post.setEntity((HttpEntity)new StringEntity(':' + message.toString(), this.charset));
            response = this.httpClient.execute((HttpUriRequest)post);
            this.theonCounter.incrementEventCount(TheonStatus.HTTP_POST_SUCCESS);
            this.theonCounter.incrementEventCount(TheonStatus.MESSAGE_SEND_SUCCESS);
        }
        catch (IOException ioe) {
            this.theonCounter.incrementEventCount(TheonStatus.HTTP_POST_FAILURE);
            this.theonCounter.incrementEventCount(TheonStatus.MESSAGE_SEND_FAILURE);
            logger.error("Could not post to - " + post.getRequestLine(), (Throwable)ioe);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    public void postMessage(String topic, String key, E message) {
        this.postMessage(topic, key, message, this.parallelEnabled);
    }

    public void postMessage(String topic, String key, E message, boolean parallel) {
        if (!this.initialized) {
            return;
        }
        if (parallel) {
            this.parallelBulkOperationUtil.add(new TheonMessage<E>(topic, key, message));
        } else {
            this.bulkOperationUtil.add(new TheonMessage<E>(topic, key, message));
        }
        this.theonCounter.incrementEventCount(TheonStatus.MESSAGE_ADDED);
    }

    public String getTheonUrl() {
        return this.theonUrl;
    }

    public void setTheonUrl(String theonUrl) {
        this.theonUrl = theonUrl;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isWaitEnabled() {
        return false;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public URI getTheonUri() {
        return this.theonUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getBulkPollIntervalSecs() {
        return this.bulkPollIntervalSecs;
    }

    public void setBulkPollIntervalSecs(int bulkPollIntervalSecs) {
        this.bulkPollIntervalSecs = bulkPollIntervalSecs;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public int getMaxPostEntitySize() {
        return this.maxPostEntitySize;
    }

    public void setMaxPostEntitySize(int maxPostEntitySize) {
        this.maxPostEntitySize = maxPostEntitySize;
    }

    public BulkOperationUtil<TheonMessage<E>> getBulkOperationUtil() {
        return this.bulkOperationUtil;
    }

    public BulkOperationUtil.BulkOperation<TheonMessage<E>> getBulkOperation() {
        return this.bulkOperation;
    }

    public BulkOperationUtil<TheonMessage<E>> getParallelBulkOperationUtil() {
        return this.parallelBulkOperationUtil;
    }

    public boolean isFileBasedQueue() {
        return this.fileBasedQueue;
    }

    public void setFileBasedQueue(boolean fileBasedQueue) {
        this.fileBasedQueue = fileBasedQueue;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public EnumCounter<TheonStatus> getTheonCounter() {
        return this.theonCounter;
    }

    public int getHttpConnPoolSize() {
        return this.httpConnPoolSize;
    }

    public void setHttpConnPoolSize(int httpConnPoolSize) {
        this.httpConnPoolSize = httpConnPoolSize;
    }

    public int getBulkMessageSize() {
        return this.bulkMessageSize;
    }

    public void setBulkMessageSize(int bulkMessageSize) {
        this.bulkMessageSize = bulkMessageSize;
    }

    public boolean isPostPerKey() {
        return this.postPerKey;
    }

    public void setPostPerKey(boolean postPerKey) {
        this.postPerKey = postPerKey;
    }

    public String getDefaultKey() {
        return this.defaultKey;
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    public void setGzipEnabled(boolean gzipEnabled) {
        this.gzipEnabled = gzipEnabled;
    }

    public boolean isParallelEnabled() {
        return this.parallelEnabled;
    }

    public void setParallelEnabled(boolean parallelEnabled) {
        this.parallelEnabled = parallelEnabled;
    }

    public String getQueueDir() {
        return this.queueDir;
    }

    public void setQueueDir(String queueDir) {
        this.queueDir = queueDir;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public long getBigQueueTimerInterval() {
        return this.bigQueueTimerInterval;
    }

    public void setBigQueueTimerInterval(long bigQueueTimerInterval) {
        this.bigQueueTimerInterval = bigQueueTimerInterval;
    }

    public boolean isPeekEnabled() {
        return this.peekEnabled;
    }

    public void setPeekEnabled(boolean peekEnabled) {
        this.peekEnabled = peekEnabled;
    }

    public boolean isCertValidationDisabled() {
        return this.certValidationDisabled;
    }

    public void setCertValidationDisabled(boolean certValidationDisabled) {
        this.certValidationDisabled = certValidationDisabled;
    }

    public boolean isStringType() {
        return this.stringType;
    }

    public void setStringType(boolean stringType) {
        this.stringType = stringType;
    }

    public static class TheonMessage<E extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 339681800724722659L;
        private final String topic;
        private final String key;
        private final E message;

        public TheonMessage(String topic, E message) {
            this(topic, "", message);
        }

        public TheonMessage(String topic, String key, E message) {
            this.topic = topic;
            this.key = key;
            this.message = message;
        }

        public String getTopic() {
            return this.topic;
        }

        public String getKey() {
            return this.key;
        }

        public E getMessage() {
            return this.message;
        }
    }

    public static enum TheonStatus {
        MESSAGE_ADDED,
        HTTP_POST_SUCCESS,
        HTTP_POST_FAILURE,
        MESSAGE_SEND_SUCCESS,
        MESSAGE_SEND_FAILURE,
        POST_SIZE_LIMIT_REACHED;

    }
}

