/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.support;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.RouterTransaction;

@Deprecated
public abstract class ControllerPagerAdapter
extends PagerAdapter {
    private static final String KEY_SAVED_PAGES = "ControllerPagerAdapter.savedStates";
    private static final String KEY_SAVES_STATE = "ControllerPagerAdapter.savesState";
    private static final String KEY_VISIBLE_PAGE_IDS_KEYS = "ControllerPagerAdapter.visiblePageIds.keys";
    private static final String KEY_VISIBLE_PAGE_IDS_VALUES = "ControllerPagerAdapter.visiblePageIds.values";
    private final Controller host;
    private boolean savesState;
    private SparseArray<Bundle> savedPages = new SparseArray();
    private SparseArray<String> visiblePageIds = new SparseArray();

    public ControllerPagerAdapter(@NonNull Controller host, boolean saveControllerState) {
        this.host = host;
        this.savesState = saveControllerState;
    }

    @NonNull
    public abstract Controller getItem(int var1);

    public Object instantiateItem(ViewGroup container, int position) {
        Controller controller;
        Bundle routerSavedState;
        String name = ControllerPagerAdapter.makeControllerName(container.getId(), this.getItemId(position));
        Router router = this.host.getChildRouter(container, name);
        if (this.savesState && !router.hasRootController() && (routerSavedState = (Bundle)this.savedPages.get(position)) != null) {
            router.restoreInstanceState(routerSavedState);
        }
        if (!router.hasRootController()) {
            controller = this.getItem(position);
            router.setRoot(RouterTransaction.with((Controller)controller).tag(name));
        } else {
            router.rebindIfNeeded();
            controller = router.getControllerWithTag(name);
        }
        if (controller != null) {
            this.visiblePageIds.put(position, (Object)controller.getInstanceId());
        }
        return router.getControllerWithTag(name);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        Router router = ((Controller)object).getRouter();
        if (this.savesState) {
            Bundle savedState = new Bundle();
            router.saveInstanceState(savedState);
            this.savedPages.put(position, (Object)savedState);
        }
        this.visiblePageIds.remove(position);
        this.host.removeChildRouter(router);
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Controller)object).getView() == view;
    }

    public Parcelable saveState() {
        Bundle bundle = new Bundle();
        bundle.putBoolean(KEY_SAVES_STATE, this.savesState);
        bundle.putSparseParcelableArray(KEY_SAVED_PAGES, this.savedPages);
        int[] visiblePageIdsKeys = new int[this.visiblePageIds.size()];
        String[] visiblePageIdsValues = new String[this.visiblePageIds.size()];
        for (int i = 0; i < this.visiblePageIds.size(); ++i) {
            visiblePageIdsKeys[i] = this.visiblePageIds.keyAt(i);
            visiblePageIdsValues[i] = (String)this.visiblePageIds.valueAt(i);
        }
        bundle.putIntArray(KEY_VISIBLE_PAGE_IDS_KEYS, visiblePageIdsKeys);
        bundle.putStringArray(KEY_VISIBLE_PAGE_IDS_VALUES, visiblePageIdsValues);
        return bundle;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        Bundle bundle = (Bundle)state;
        if (state != null) {
            this.savesState = bundle.getBoolean(KEY_SAVES_STATE, false);
            this.savedPages = bundle.getSparseParcelableArray(KEY_SAVED_PAGES);
            int[] visiblePageIdsKeys = bundle.getIntArray(KEY_VISIBLE_PAGE_IDS_KEYS);
            String[] visiblePageIdsValues = bundle.getStringArray(KEY_VISIBLE_PAGE_IDS_VALUES);
            this.visiblePageIds = new SparseArray(visiblePageIdsKeys.length);
            for (int i = 0; i < visiblePageIdsKeys.length; ++i) {
                this.visiblePageIds.put(visiblePageIdsKeys[i], (Object)visiblePageIdsValues[i]);
            }
        }
    }

    @Nullable
    public Controller getController(int position) {
        String instanceId = (String)this.visiblePageIds.get(position);
        if (instanceId != null) {
            return this.host.getRouter().getControllerWithInstanceId(instanceId);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    private static String makeControllerName(int viewId, long id) {
        return viewId + ":" + id;
    }
}

