/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.support;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.RouterTransaction;
import java.util.ArrayList;
import java.util.List;

public abstract class RouterPagerAdapter
extends PagerAdapter {
    private static final String KEY_SAVED_PAGES = "RouterPagerAdapter.savedStates";
    private static final String KEY_MAX_PAGES_TO_STATE_SAVE = "RouterPagerAdapter.maxPagesToStateSave";
    private static final String KEY_SAVE_PAGE_HISTORY = "RouterPagerAdapter.savedPageHistory";
    private final Controller host;
    private int maxPagesToStateSave = Integer.MAX_VALUE;
    private SparseArray<Bundle> savedPages = new SparseArray();
    private SparseArray<Router> visibleRouters = new SparseArray();
    private ArrayList<Integer> savedPageHistory = new ArrayList();
    private Router currentPrimaryRouter;

    public RouterPagerAdapter(@NonNull Controller host) {
        this.host = host;
    }

    public abstract void configureRouter(@NonNull Router var1, int var2);

    public void setMaxPagesToStateSave(int maxPagesToStateSave) {
        if (maxPagesToStateSave < 0) {
            throw new IllegalArgumentException("Only positive integers may be passed for maxPagesToStateSave.");
        }
        this.maxPagesToStateSave = maxPagesToStateSave;
        this.ensurePagesSaved();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Bundle routerSavedState;
        String name = RouterPagerAdapter.makeRouterName(container.getId(), this.getItemId(position));
        Router router = this.host.getChildRouter(container, name);
        if (!router.hasRootController() && (routerSavedState = (Bundle)this.savedPages.get(position)) != null) {
            router.restoreInstanceState(routerSavedState);
            this.savedPages.remove(position);
            this.savedPageHistory.remove((Object)position);
        }
        router.rebindIfNeeded();
        this.configureRouter(router, position);
        if (router != this.currentPrimaryRouter) {
            for (RouterTransaction transaction : router.getBackstack()) {
                transaction.controller().setOptionsMenuHidden(true);
            }
        }
        this.visibleRouters.put(position, (Object)router);
        return router;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        Router router = (Router)object;
        Bundle savedState = new Bundle();
        router.saveInstanceState(savedState);
        this.savedPages.put(position, (Object)savedState);
        this.savedPageHistory.remove((Object)position);
        this.savedPageHistory.add(position);
        this.ensurePagesSaved();
        this.host.removeChildRouter(router);
        this.visibleRouters.remove(position);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Router router = (Router)object;
        if (router != this.currentPrimaryRouter) {
            if (this.currentPrimaryRouter != null) {
                for (RouterTransaction transaction : this.currentPrimaryRouter.getBackstack()) {
                    transaction.controller().setOptionsMenuHidden(true);
                }
            }
            if (router != null) {
                for (RouterTransaction transaction : router.getBackstack()) {
                    transaction.controller().setOptionsMenuHidden(false);
                }
            }
            this.currentPrimaryRouter = router;
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        Router router = (Router)object;
        List backstack = router.getBackstack();
        for (RouterTransaction transaction : backstack) {
            if (transaction.controller().getView() != view) continue;
            return true;
        }
        return false;
    }

    public Parcelable saveState() {
        Bundle bundle = new Bundle();
        bundle.putSparseParcelableArray(KEY_SAVED_PAGES, this.savedPages);
        bundle.putInt(KEY_MAX_PAGES_TO_STATE_SAVE, this.maxPagesToStateSave);
        bundle.putIntegerArrayList(KEY_SAVE_PAGE_HISTORY, this.savedPageHistory);
        return bundle;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        Bundle bundle = (Bundle)state;
        if (state != null) {
            this.savedPages = bundle.getSparseParcelableArray(KEY_SAVED_PAGES);
            this.maxPagesToStateSave = bundle.getInt(KEY_MAX_PAGES_TO_STATE_SAVE);
            this.savedPageHistory = bundle.getIntegerArrayList(KEY_SAVE_PAGE_HISTORY);
        }
    }

    @Nullable
    public Router getRouter(int position) {
        return (Router)this.visibleRouters.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    SparseArray<Bundle> getSavedPages() {
        return this.savedPages;
    }

    private void ensurePagesSaved() {
        while (this.savedPages.size() > this.maxPagesToStateSave) {
            int positionToRemove = this.savedPageHistory.remove(0);
            this.savedPages.remove(positionToRemove);
        }
    }

    private static String makeRouterName(int viewId, long id) {
        return viewId + ":" + id;
    }
}

