/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor;

import com.bluelinelabs.logansquare.processor.JsonObjectHolder;
import com.bluelinelabs.logansquare.processor.ObjectMapperInjector;
import com.bluelinelabs.logansquare.processor.processor.Processor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class JsonAnnotationProcessor
extends AbstractProcessor {
    private Elements mElementUtils;
    private Types mTypeUtils;
    private Filer mFiler;
    private List<Processor> mProcessors;
    private Map<String, JsonObjectHolder> mJsonObjectMap;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.mElementUtils = env.getElementUtils();
        this.mTypeUtils = env.getTypeUtils();
        this.mFiler = env.getFiler();
        this.mJsonObjectMap = new HashMap<String, JsonObjectHolder>();
        this.mProcessors = Processor.allProcessors(this.processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> supportTypes = new LinkedHashSet<String>();
        for (Processor processor : this.mProcessors) {
            supportTypes.add(processor.getAnnotation().getCanonicalName());
        }
        return supportTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        try {
            for (Processor processor : this.mProcessors) {
                processor.findAndParseObjects(env, this.mJsonObjectMap, this.mElementUtils, this.mTypeUtils);
            }
            for (Map.Entry entry : this.mJsonObjectMap.entrySet()) {
                String fqcn = (String)entry.getKey();
                JsonObjectHolder jsonObjectHolder = (JsonObjectHolder)entry.getValue();
                if (jsonObjectHolder.fileCreated) continue;
                jsonObjectHolder.fileCreated = true;
                try {
                    JavaFileObject jfo = this.mFiler.createSourceFile(fqcn, new Element[0]);
                    Writer writer = jfo.openWriter();
                    writer.write(new ObjectMapperInjector(jsonObjectHolder).getJavaClassFile());
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    this.error(fqcn, "Exception occurred while attempting to write injector for type %s. Exception message: %s", fqcn, e.getMessage());
                }
            }
            return true;
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.error("Exception while processing Json classes. Stack trace incoming:\n%s", stringWriter.toString());
            return false;
        }
    }

    private void error(String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args));
    }
}

