/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor;

import com.bluelinelabs.logansquare.annotation.JsonObject;
import com.bluelinelabs.logansquare.processor.JsonFieldHolder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.TypeParameterElement;

public class JsonObjectHolder {
    public final String packageName;
    public final String injectedClassName;
    public final TypeName objectTypeName;
    public final boolean isAbstractClass;
    public final TypeName parentTypeName;
    public final List<? extends TypeParameterElement> parentTypeParameters;
    public final List<String> parentUsedTypeParameters;
    public final JsonObject.FieldDetectionPolicy fieldDetectionPolicy;
    public final JsonObject.FieldNamingPolicy fieldNamingPolicy;
    public final boolean serializeNullObjects;
    public final boolean serializeNullCollectionElements;
    public final List<? extends TypeParameterElement> typeParameters;
    public String onCompleteCallback;
    public String preSerializeCallback;
    public final Map<String, JsonFieldHolder> fieldMap = new TreeMap<String, JsonFieldHolder>();
    public boolean fileCreated;

    public boolean hasParentClass() {
        return this.parentTypeName != null;
    }

    public TypeName getParameterizedParentTypeName() {
        if (this.parentUsedTypeParameters.size() > 0) {
            ArrayList<Object> usedParameters = new ArrayList<Object>();
            for (String parameter : this.parentUsedTypeParameters) {
                if (parameter.indexOf(".") > 0) {
                    usedParameters.add(ClassName.bestGuess((String)parameter));
                    continue;
                }
                usedParameters.add(TypeVariableName.get((String)parameter));
            }
            return ParameterizedTypeName.get((ClassName)((ClassName)this.parentTypeName), (TypeName[])usedParameters.toArray(new TypeName[usedParameters.size()]));
        }
        return this.parentTypeName;
    }

    private JsonObjectHolder(JsonObjectHolderBuilder builder) {
        this.packageName = builder.packageName;
        this.injectedClassName = builder.injectedClassName;
        this.objectTypeName = builder.objectTypeName;
        this.isAbstractClass = builder.isAbstractClass;
        this.parentTypeName = builder.parentTypeName;
        this.parentTypeParameters = builder.parentTypeParameters;
        this.parentUsedTypeParameters = builder.parentUsedTypeParameters;
        this.fieldDetectionPolicy = builder.fieldDetectionPolicy;
        this.fieldNamingPolicy = builder.fieldNamingPolicy;
        this.serializeNullObjects = builder.serializeNullObjects;
        this.serializeNullCollectionElements = builder.serializeNullCollectionElements;
        this.typeParameters = builder.typeParameters;
    }

    public static class JsonObjectHolderBuilder {
        private String packageName;
        private String injectedClassName;
        private TypeName objectTypeName;
        private boolean isAbstractClass;
        private TypeName parentTypeName;
        private List<? extends TypeParameterElement> parentTypeParameters;
        private List<String> parentUsedTypeParameters;
        private JsonObject.FieldDetectionPolicy fieldDetectionPolicy;
        private JsonObject.FieldNamingPolicy fieldNamingPolicy;
        private boolean serializeNullObjects;
        private boolean serializeNullCollectionElements;
        private List<? extends TypeParameterElement> typeParameters;

        public JsonObjectHolderBuilder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public JsonObjectHolderBuilder setInjectedClassName(String injectedClassName) {
            this.injectedClassName = injectedClassName;
            return this;
        }

        public JsonObjectHolderBuilder setObjectTypeName(TypeName objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public JsonObjectHolderBuilder setIsAbstractClass(boolean isAbstractClass) {
            this.isAbstractClass = isAbstractClass;
            return this;
        }

        public JsonObjectHolderBuilder setParentTypeName(TypeName parentTypeName) {
            this.parentTypeName = parentTypeName;
            return this;
        }

        public JsonObjectHolderBuilder setParentTypeParameters(List<? extends TypeParameterElement> parentTypeParameters) {
            this.parentTypeParameters = parentTypeParameters;
            return this;
        }

        public JsonObjectHolderBuilder setParentUsedTypeParameters(List<String> parentUsedTypeParameters) {
            this.parentUsedTypeParameters = parentUsedTypeParameters;
            return this;
        }

        public JsonObjectHolderBuilder setFieldDetectionPolicy(JsonObject.FieldDetectionPolicy fieldDetectionPolicy) {
            this.fieldDetectionPolicy = fieldDetectionPolicy;
            return this;
        }

        public JsonObjectHolderBuilder setFieldNamingPolicy(JsonObject.FieldNamingPolicy fieldNamingPolicy) {
            this.fieldNamingPolicy = fieldNamingPolicy;
            return this;
        }

        public JsonObjectHolderBuilder setSerializeNullObjects(boolean serializeNullObjects) {
            this.serializeNullObjects = serializeNullObjects;
            return this;
        }

        public JsonObjectHolderBuilder setSerializeNullCollectionElements(boolean serializeNullCollectionElements) {
            this.serializeNullCollectionElements = serializeNullCollectionElements;
            return this;
        }

        public JsonObjectHolderBuilder setTypeParameters(List<? extends TypeParameterElement> typeParameters) {
            this.typeParameters = typeParameters;
            return this;
        }

        public JsonObjectHolder build() {
            return new JsonObjectHolder(this);
        }
    }
}

