/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.processor;

import com.bluelinelabs.logansquare.processor.JsonObjectHolder;
import com.bluelinelabs.logansquare.processor.processor.JsonFieldProcessor;
import com.bluelinelabs.logansquare.processor.processor.JsonObjectProcessor;
import com.bluelinelabs.logansquare.processor.processor.OnJsonParseCompleteProcessor;
import com.bluelinelabs.logansquare.processor.processor.OnPreSerializeProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public abstract class Processor {
    protected ProcessingEnvironment mProcessingEnv;

    protected Processor(ProcessingEnvironment processingEnv) {
        this.mProcessingEnv = processingEnv;
    }

    public abstract Class getAnnotation();

    public abstract void findAndParseObjects(RoundEnvironment var1, Map<String, JsonObjectHolder> var2, Elements var3, Types var4);

    public static List<Processor> allProcessors(ProcessingEnvironment processingEnvironment) {
        ArrayList<Processor> list = new ArrayList<Processor>();
        list.add(new JsonObjectProcessor(processingEnvironment));
        list.add(new OnJsonParseCompleteProcessor(processingEnvironment));
        list.add(new OnPreSerializeProcessor(processingEnvironment));
        list.add(new JsonFieldProcessor(processingEnvironment));
        return list;
    }

    public void error(Element element, String message, Object ... args) {
        this.mProcessingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
    }
}

