/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.type.collection;

import com.bluelinelabs.logansquare.processor.TextUtils;
import com.bluelinelabs.logansquare.processor.type.Type;
import com.bluelinelabs.logansquare.processor.type.collection.CollectionType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ArrayCollectionType
extends CollectionType {
    private final Type arrayType;

    public ArrayCollectionType(Type arrayType) {
        this.arrayType = arrayType;
        this.addParameterType(arrayType);
    }

    @Override
    public TypeName getTypeName() {
        return ArrayTypeName.of((TypeName)this.arrayType.getTypeName());
    }

    @Override
    public String getParameterizedTypeString() {
        return this.arrayType.getParameterizedTypeString() + "[]";
    }

    @Override
    public Object[] getParameterizedTypeStringArgs() {
        return this.arrayType.getParameterizedTypeStringArgs();
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        TypeName fieldType = this.arrayType.getTypeName();
        String collectionVarName = "collection" + depth;
        String instanceCreator = String.format("$T<%s> $L = new $T<%s>()", this.arrayType.getParameterizedTypeString(), this.arrayType.getParameterizedTypeString());
        Object[] instanceCreatorArgs = this.expandStringArgs(List.class, this.arrayType.getParameterizedTypeStringArgs(), collectionVarName, ArrayList.class, this.arrayType.getParameterizedTypeStringArgs());
        builder.beginControlFlow("if ($L.getCurrentToken() == $T.START_ARRAY)", new Object[]{"jsonParser", JsonToken.class}).addStatement(instanceCreator, instanceCreatorArgs).beginControlFlow("while ($L.nextToken() != $T.END_ARRAY)", new Object[]{"jsonParser", JsonToken.class});
        if (!fieldType.isPrimitive()) {
            String valueVarName = "value" + depth;
            builder.addStatement("$T $L", new Object[]{this.arrayType.getTypeName(), valueVarName});
            this.arrayType.parse(builder, depth + 1, "$L = $L", valueVarName);
            builder.addStatement("$L.add($L)", new Object[]{collectionVarName, valueVarName});
        } else {
            this.arrayType.parse(builder, depth + 1, "$L.add($L)", collectionVarName);
        }
        builder.endControlFlow();
        if (fieldType.isPrimitive()) {
            builder.addStatement("$T[] array = new $T[$L.size()]", new Object[]{fieldType, fieldType, collectionVarName}).addStatement("int i = 0", new Object[0]).beginControlFlow("for ($T value : $L)", new Object[]{fieldType, collectionVarName}).addStatement("array[i++] = value", new Object[0]).endControlFlow();
        } else {
            builder.addStatement("$T[] array = $L.toArray(new $T[$L.size()])", new Object[]{fieldType, collectionVarName, fieldType, collectionVarName});
        }
        builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "array")).nextControlFlow("else", new Object[0]).addStatement(setter, this.expandStringArgs(setterFormatArgs, "null")).endControlFlow();
    }

    @Override
    public void serialize(MethodSpec.Builder builder, int depth, String fieldName, List<String> processedFieldNames, String getter, boolean isObjectProperty, boolean checkIfNull, boolean writeIfNull, boolean writeCollectionElementIfNull) {
        Object[] forLineArgs;
        String forLine;
        Object[] instanceCreatorArgs;
        String instanceCreator;
        String cleanFieldName = TextUtils.toUniqueFieldNameVariable(fieldName, processedFieldNames);
        String collectionVariableName = "lslocal" + cleanFieldName;
        String elementVarName = "element" + depth;
        if (this.arrayType.getTypeName().isPrimitive()) {
            instanceCreator = "final $T[] $L = $L";
            instanceCreatorArgs = this.expandStringArgs(this.arrayType.getTypeName(), collectionVariableName, getter);
            forLine = "for ($T $L : $L)";
            forLineArgs = this.expandStringArgs(this.arrayType.getTypeName(), elementVarName, collectionVariableName);
        } else {
            instanceCreator = String.format("final %s[] $L = $L", this.arrayType.getParameterizedTypeString());
            instanceCreatorArgs = this.expandStringArgs(this.arrayType.getParameterizedTypeStringArgs(), collectionVariableName, getter);
            forLine = String.format("for (%s $L : $L)", this.arrayType.getParameterizedTypeString());
            forLineArgs = this.expandStringArgs(this.arrayType.getParameterizedTypeStringArgs(), elementVarName, collectionVariableName);
        }
        builder.addStatement(instanceCreator, instanceCreatorArgs).beginControlFlow("if ($L != null)", new Object[]{collectionVariableName});
        if (isObjectProperty) {
            builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
        }
        builder.addStatement("$L.writeStartArray()", new Object[]{"jsonGenerator"}).beginControlFlow(forLine, forLineArgs);
        if (!this.arrayType.getTypeName().isPrimitive()) {
            builder.beginControlFlow("if ($L != null)", new Object[]{elementVarName});
        }
        this.arrayType.serialize(builder, depth + 1, collectionVariableName + "Element", processedFieldNames, elementVarName, false, false, false, writeCollectionElementIfNull);
        if (!this.arrayType.getTypeName().isPrimitive()) {
            if (writeCollectionElementIfNull) {
                builder.nextControlFlow("else", new Object[0]).addStatement("$L.writeNull()", new Object[]{"jsonGenerator"});
            }
            builder.endControlFlow();
        }
        builder.endControlFlow().addStatement("$L.writeEndArray()", new Object[]{"jsonGenerator"}).endControlFlow();
    }

    @Override
    public Set<Type.ClassNameObjectMapper> getUsedJsonObjectMappers() {
        Set<Type.ClassNameObjectMapper> mappers = super.getUsedJsonObjectMappers();
        mappers.addAll(this.arrayType.getUsedJsonObjectMappers());
        return mappers;
    }
}

