/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.type.field;

import com.bluelinelabs.logansquare.processor.type.field.FieldType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;

public class BooleanFieldType
extends FieldType {
    protected boolean isPrimitive;

    public BooleanFieldType(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public TypeName getTypeName() {
        return this.isPrimitive ? TypeName.BOOLEAN : ClassName.get(Boolean.class);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return ClassName.get(Boolean.class);
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        if (this.isPrimitive) {
            setter = BooleanFieldType.replaceLastLiteral(setter, "$L.getValueAsBoolean()");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
        } else {
            setter = BooleanFieldType.replaceLastLiteral(setter, "$L.getCurrentToken() == $T.VALUE_NULL ? null : Boolean.valueOf($L.getValueAsBoolean())");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser", JsonToken.class, "jsonParser"));
        }
    }

    @Override
    public void serialize(MethodSpec.Builder builder, int depth, String fieldName, List<String> processedFieldNames, String getter, boolean isObjectProperty, boolean checkIfNull, boolean writeIfNull, boolean writeCollectionElementIfNull) {
        if (!this.isPrimitive && checkIfNull) {
            builder.beginControlFlow("if ($L != null)", new Object[]{getter});
        }
        if (isObjectProperty) {
            builder.addStatement("$L.writeBooleanField($S, $L)", new Object[]{"jsonGenerator", fieldName, getter});
        } else {
            builder.addStatement("$L.writeBoolean($L)", new Object[]{"jsonGenerator", getter});
        }
        if (!this.isPrimitive && checkIfNull) {
            if (writeIfNull) {
                builder.nextControlFlow("else", new Object[0]);
                if (isObjectProperty) {
                    builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
                }
                builder.addStatement("$L.writeNull()", new Object[]{"jsonGenerator"});
            }
            builder.endControlFlow();
        }
    }
}

