/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.type.field;

import com.bluelinelabs.logansquare.processor.type.field.NumberFieldType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class ByteFieldType
extends NumberFieldType {
    public ByteFieldType(boolean isPrimitive) {
        super(isPrimitive);
    }

    @Override
    public TypeName getTypeName() {
        return this.isPrimitive ? TypeName.BYTE : ClassName.get(Byte.class);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return ClassName.get(Byte.class);
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        if (this.isPrimitive) {
            setter = ByteFieldType.replaceLastLiteral(setter, "(byte)$L.getValueAsInt()");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
        } else {
            setter = ByteFieldType.replaceLastLiteral(setter, "$L.getCurrentToken() == $T.VALUE_NULL ? null : Byte.valueOf((byte)$L.getValueAsInt())");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser", JsonToken.class, "jsonParser"));
        }
    }
}

