/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.type.field;

import com.bluelinelabs.logansquare.processor.ObjectMapperInjector;
import com.bluelinelabs.logansquare.processor.type.field.FieldType;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Set;

public class DynamicFieldType
extends FieldType {
    private TypeName mTypeName;

    public DynamicFieldType(TypeName typeName) {
        this.mTypeName = typeName;
    }

    @Override
    public TypeName getTypeName() {
        return this.mTypeName;
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return this.mTypeName;
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        setter = DynamicFieldType.replaceLastLiteral(setter, ObjectMapperInjector.getTypeConverterGetter(this.mTypeName) + "().parse($L)");
        builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
    }

    @Override
    public void serialize(MethodSpec.Builder builder, int depth, String fieldName, List<String> processedFieldNames, String getter, boolean isObjectProperty, boolean checkIfNull, boolean writeIfNull, boolean writeCollectionElementIfNull) {
        if (!this.mTypeName.isPrimitive() && checkIfNull) {
            builder.beginControlFlow("if ($L != null)", new Object[]{getter});
        }
        builder.addStatement(ObjectMapperInjector.getTypeConverterGetter(this.mTypeName) + "().serialize($L, $S, $L, $L)", new Object[]{getter, isObjectProperty ? fieldName : null, isObjectProperty, "jsonGenerator"});
        if (!this.mTypeName.isPrimitive() && checkIfNull) {
            if (writeIfNull) {
                builder.nextControlFlow("else", new Object[0]);
                if (isObjectProperty) {
                    builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
                }
                builder.addStatement("$L.writeNull()", new Object[]{"jsonGenerator"});
            }
            builder.endControlFlow();
        }
    }

    @Override
    public Set<TypeName> getUsedTypeConverters() {
        Set<TypeName> set = super.getUsedTypeConverters();
        set.add(this.mTypeName);
        return set;
    }
}

